/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntity;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsLabel;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.docs.UxAbstractDocsQuery;
import crazydev.iccube.ux.admin.queries.docs.UxDocsAddQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsAllSharingsQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsDeleteQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsDownloadQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryDetails;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsFileContentQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsMoveQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsOpenUrlQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRenameQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.admin.queries.docs.UxDocsSharingsQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionUtils;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.console.queries.upload.UxUploadFileQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDocsDetailsQuery
extends UxAbstractDocsQuery {
    private final UxDocsRepositoryType repositoryType;
    @Nullable
    private final UxDocsEntryPath path;
    @Nullable
    private final List<String> names;

    public UxDocsDetailsQuery(UxQueryMeta meta, OlapRequestId requestId, UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path, @Nullable List<String> names) {
        super(meta, requestId);
        this.repositoryType = repositoryType;
        this.path = path;
        this.names = names;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) throws OlapDocsErrorException {
        Object repository = queryContext.getDocsRepository(this.repositoryType);
        OlapPath absPath = UxDocsDetailsQuery.setupOlapPath(this.path);
        UxDocsEntryDetails details = this.doExecuteQuery(queryContext, (OlapDocsRepository)repository, absPath);
        return UxReply.actionSuccess(details);
    }

    private UxDocsEntryDetails doExecuteQuery(UxQueryContext context, OlapDocsRepository repository, OlapPath absPath) throws OlapDocsErrorException {
        if (this.names == null || this.names.isEmpty()) {
            return this.executeForNoSelection(context, this.repositoryType, repository, absPath);
        }
        if (this.names.size() == 1) {
            return this.executeForSingleSelection(context, this.repositoryType, repository, absPath.append(new OlapPathEntry[]{OlapPathEntry.create((String)this.names.get(0))}));
        }
        return this.executeForMultiSelection(context, this.repositoryType, repository, absPath, this.names);
    }

    private UxDocsEntryDetails executeForNoSelection(UxQueryContext context, UxDocsRepositoryType repositoryType, OlapDocsRepository repository, OlapPath path) {
        UxModel details = null;
        List<UxAction> actions = UxDocsDetailsQuery.setupActions(context, repositoryType, repository, path, null);
        return new UxDocsEntryDetails(details, actions);
    }

    private UxDocsEntryDetails executeForSingleSelection(UxQueryContext context, UxDocsRepositoryType repositoryType, OlapDocsRepository repository, OlapPath path) throws OlapDocsErrorException {
        IOlapDocsRequestContext docsContext = context.createDocsRequestContext();
        OlapDocsEntity entity = repository.getEntity(docsContext, path, false);
        UxModel details = this.setupUxDetails(context, path, entity);
        List<UxAction> actions = UxDocsDetailsQuery.setupActions(context, repositoryType, repository, path, entity);
        return new UxDocsEntryDetails(details, actions);
    }

    private UxDocsEntryDetails executeForMultiSelection(UxQueryContext context, UxDocsRepositoryType repositoryType, OlapDocsRepository repository, OlapPath path, List<String> names) {
        UxModel details = null;
        List<UxAction> actions = this.setupActions(context, repositoryType, repository, path, names);
        return new UxDocsEntryDetails(details, actions);
    }

    private UxModel setupUxDetails(UxQueryContext context, OlapPath entityPath, @Nullable OlapDocsEntity entity) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxField> details = new ArrayList<UxField>();
        String name = entityPath.getName().getName();
        if (entity != null) {
            name = entity.getCaption();
        }
        details.add(new UxField(babylon, "name", new UxFieldMeta(UxFieldTypes.STRING, true, true, false), new UxFieldValue(name)));
        if (!(entity instanceof OlapDocsLabel) && entity instanceof OlapDocsDoc) {
            OlapDocsDoc file = (OlapDocsDoc)entity;
            details.add(new UxField(babylon, "charset", new UxFieldMeta(UxFieldTypes.STRING, true, true, false), new UxFieldValue(file.getCharset())));
            details.add(new UxField(babylon, "mimeType", new UxFieldMeta(UxFieldTypes.STRING, true, true, false), new UxFieldValue(file.getMimeType())));
        }
        return new UxModel(details);
    }

    public static List<UxAction> setupActions(UxQueryContext context, UxDocsRepositoryType repositoryType, OlapDocsRepository repository, OlapPath path, @Nullable OlapDocsEntity entity) {
        List<UxAction> fixed;
        OlapDocsDoc file;
        ArrayList<UxAction> actions = new ArrayList<UxAction>();
        if (entity == null) {
            return actions;
        }
        OlapPath parentPath = path.getParent() != null ? path.getParent() : OlapPath.ROOT;
        UxDocsEntryPath uxParentPath = UxDocsEntryPath.fromOlapPath(parentPath);
        UxDocsEntryPath uxPath = UxDocsEntryPath.fromOlapPath(path);
        if (entity.isLabel()) {
            actions.add(UxDocsAddQueryMeta.createAction(context, 3, repositoryType, uxPath));
        }
        if (entity.isLabel()) {
            actions.add(UxUploadFileQueryMeta.createActionForDocs(context, 3, repositoryType, path));
        }
        if (entity instanceof OlapDocsDoc && (file = (OlapDocsDoc)entity).isFileEditable()) {
            actions.add(UxDocsFileContentQueryMeta.createAction(context, repositoryType, UxDocsEntryPath.fromOlapPath(path)));
        }
        String id = entity.isLabel() ? UxDocsDownloadQueryMeta.DocsDownload.queryName().name() + "Folder" : UxDocsDownloadQueryMeta.DocsDownload.queryName().name() + "File";
        actions.add(UxDocsDownloadQueryMeta.createAction(context, id, repositoryType, uxParentPath, Collections.singletonList(path.getName().getName())));
        if (repository.isWebRepository()) {
            if (entity instanceof OlapDocsDoc) {
                OlapPath url = entity.getNameUrlX();
                actions.add(UxDocsOpenUrlQueryMeta.createAction(context, UxUrl.fromOlapPath(url)));
            }
            if (path.isEmpty()) {
                actions.add(UxDocsAllSharingsQueryMeta.createAction(context, 3, repositoryType));
            } else {
                actions.add(UxDocsSharingsQueryMeta.createAction(context, repositoryType, UxDocsEntryPath.fromOlapPath(path)));
            }
        }
        actions.add(UxDocsRenameQueryMeta.createAction(context, repositoryType, uxParentPath, path.getName().getName()));
        if (!path.isEmpty()) {
            actions.add(UxDocsMoveQueryMeta.createAction(context, repositoryType, uxParentPath, Collections.singletonList(path.getName().getName())));
            actions.add(UxDocsDeleteQueryMeta.createAction(context, repositoryType, uxParentPath, Collections.singletonList(path.getName().getName())));
        }
        if ((fixed = UxActionUtils.removeNulls(actions)) == null) {
            return new ArrayList<UxAction>();
        }
        return fixed;
    }

    private List<UxAction> setupActions(UxQueryContext context, UxDocsRepositoryType repositoryType, OlapDocsRepository repository, OlapPath path, List<String> names) {
        UxDocsEntryPath uxPath = UxDocsEntryPath.fromOlapPath(path);
        ArrayList<UxAction> actions = new ArrayList<UxAction>();
        actions.add(UxDocsMoveQueryMeta.createAction(context, repositoryType, uxPath, names));
        actions.add(UxDocsDeleteQueryMeta.createAction(context, repositoryType, uxPath, names));
        actions.add(UxDocsDownloadQueryMeta.createAction(context, null, repositoryType, uxPath, names));
        return actions;
    }
}

