/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.dashboards;

import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsDashboardsVersion;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.dashboards.UxDashboardsDeleteQueryMeta;
import crazydev.iccube.ux.admin.queries.dashboards.UxDashboardsRestoreBackupQueryMeta;
import crazydev.iccube.ux.admin.queries.dashboards.UxDashboardsTableQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.admin.queries.reporting.UxReportingHelper;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDashboardsTableQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxDashboardsTableQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (!UxReportingHelper.isReportingInDocs(queryContext)) {
            return UxReply.message(queryContext, "reportingExternal");
        }
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "version", "active", "path", "action");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        OlapDocsActualRepository repository = queryContext.getDocsRepository();
        OlapReportRepositoryRequestContext repReqCtxt = queryContext.createRepositoryContext(true);
        List<OlapDocsDashboardsVersion> versions = repository.getInstalledDashboardsVersions(repReqCtxt);
        versions.sort((o1, o2) -> {
            int cmp = -Boolean.compare(o1.active, o2.active);
            if (cmp != 0) {
                return cmp;
            }
            int vCmp = -o1.version.compareTo(o2.version);
            if (vCmp != 0) {
                return vCmp;
            }
            Long ts1 = o1.getTimestampMS();
            Long ts2 = o2.getTimestampMS();
            if (ts1 == null || ts2 == null) {
                return 0;
            }
            return -ts1.compareTo(ts2);
        });
        int sortingValue = 0;
        for (OlapDocsDashboardsVersion version : versions) {
            rows.add(UxDashboardsTableQuery.createRow(queryContext, version, sortingValue++));
        }
        UxTable table = UxTable.create(this.tableOptions, header, rows);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(table));
    }

    private static UxTableRow createRow(UxQueryContext context, OlapDocsDashboardsVersion version, int sortingValue) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(version.getVersionWithTimestamp()).withValue_(sortingValue));
        cells.add(new UxTableCell(version.active ? babylon.translate("yesL", new Serializable[0]) : babylon.translate("noL", new Serializable[0])));
        UxUseCase useCase = UxDocsQueryMeta.createUseCase(context, UxDocsRepositoryType.WEB_DOCS, OlapPath.createFromSimplePath((String)version.path));
        cells.add(new UxTableCell((Object)version.path, useCase));
        ArrayList<UxAction> actions = new ArrayList<UxAction>();
        if (version.active) {
            UxAction delete = UxDashboardsDeleteQueryMeta.createAction(context, version.getVersionWithTimestamp(), true, null);
            if (delete != null) {
                actions.add(delete);
            }
        } else {
            UxAction restoreTo;
            UxAction delete = UxDashboardsDeleteQueryMeta.createAction(context, version.getVersionWithTimestamp(), false, version.backup);
            UxAction uxAction = restoreTo = version.backup != null ? UxDashboardsRestoreBackupQueryMeta.createAction(context, version.getVersionWithTimestamp(), version.backup) : null;
            if (delete != null) {
                actions.add(delete);
            }
            if (restoreTo != null) {
                actions.add(restoreTo);
            }
        }
        if (!actions.isEmpty()) {
            cells.add(new UxTableCell(null, null, null, null, null, actions));
        } else {
            cells.add(new UxTableCell(""));
        }
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        UxUseCase uc = new UxUseCaseBuilder(queryContext, UxDashboardsTableQueryMeta.DashboardsTable).withId(UxAdminUseCaseName.DashboardsTable).build(true);
        reply.withUseCase(uc);
    }
}

