/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.configuration.file;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.configuration.file.UxServerConfFileType;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.file.UxFileReplyPayload;
import crazydev.iccube.ux.common.file.UxFileStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxServerConfFileQuery
extends UxAdminQuery {
    @Nullable
    private final String fileType;
    @Nullable
    private UxUseCase useCase;

    protected UxServerConfFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String fileType) {
        super(meta, requestId);
        this.fileType = fileType;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxServerConfFileType fileType_;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        if (CdStringUtils.isNullOrBlank((String)this.fileType)) {
            return UxReply.success(new UxFileReplyPayload(UxFileStatus.FILE_UNKNOWN, babylon.translate(UxFileStatus.FILE_UNKNOWN.tag(), new Serializable[]{"n/a"})));
        }
        try {
            fileType_ = UxServerConfFileType.valueOf(this.fileType);
        }
        catch (IllegalArgumentException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] " + this.meta.queryName().name() + " error"), (Throwable)ex);
            return UxReply.success(new UxFileReplyPayload(UxFileStatus.FILE_UNKNOWN, babylon.translate(UxFileStatus.FILE_UNKNOWN.tag(), new Serializable[]{this.fileType})));
        }
        switch (fileType_) {
            case Conf: {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfFile);
                return this.handleServerConfiguration(queryContext);
            }
            case ConfNotifs: {
                this.useCase = queryContext.getUseCase(UxAdminUseCaseName.ServerConfNotifsFile);
                return this.handleServerConfigurationNotification(queryContext);
            }
        }
        return UxReply.success(new UxFileReplyPayload(UxFileStatus.FILE_UNKNOWN, babylon.translate(UxFileStatus.FILE_UNKNOWN.tag(), new Serializable[]{this.fileType})));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.useCase != null) {
            reply.withUseCase(this.useCase);
        } else {
            reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.ServerConfFileUnknown));
        }
    }

    private UxReply handleServerConfiguration(UxQueryContext queryContext) {
        IcCubeServerConfiguration configuration = queryContext.getApplicationContext().getConfiguration();
        File file = configuration.getXmlFile();
        return this.handleFile(queryContext, file);
    }

    private UxReply handleServerConfigurationNotification(UxQueryContext queryContext) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        OlapEngineApplicationContext engineAppContext = appContext.getOlapEngineApplicationContext();
        OlapNotificationService service = engineAppContext.getNotificationService();
        File file = service.getConfigurationFile();
        return this.handleFile(queryContext, file);
    }

    private UxReply handleFile(UxQueryContext queryContext, @Nullable File file) {
        String mimeType = "application/octet-stream";
        if (file != null) {
            mimeType = queryContext.getMimeTypeByExtension(file.getName());
        }
        OlapFile file_ = null;
        if (file != null) {
            OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)queryContext.getVfs(), (File)file.getParentFile());
            file_ = fs.create(file.getName());
        }
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file_, file != null ? file_.getPath() : this.fileType, mimeType, false);
        return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper);
    }
}

