/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.completion;

import crazydev.common.collection.CdTruncatedList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.groupby.Aggregators;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertsQueryMeta;
import crazydev.iccube.ux.admin.queries.completion.UxCompletion;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionOption;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionOptionLabel;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionType;
import crazydev.iccube.ux.admin.queries.roles.UxRolesQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxLoadedSchemasQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOfflinesQueryMeta;
import crazydev.iccube.ux.admin.queries.users.UxUsersQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxTabularName;
import crazydev.iccube.ux.builder.model.UxTabularNames;
import crazydev.iccube.ux.builder.queries.datasource.switch_.UxSwitchDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.schema.UxSchemaDefsQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModelConverterHelper;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class UxCompleteQuery
extends UxAdminQuery {
    @Nullable
    private final String type;
    @Nullable
    private final List<String> info;
    @Nullable
    private final List<String> initialValue;
    @Nullable
    private final String input;

    protected UxCompleteQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String type, @Nullable List<String> info, @Nullable List<String> initialValue, @Nullable String input) {
        super(meta, requestId);
        this.type = type;
        this.info = info;
        this.initialValue = initialValue;
        this.input = input;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxCompletionType cType = null;
        if (this.type != null) {
            try {
                cType = UxCompletionType.valueOf(this.type);
            }
            catch (IllegalArgumentException ex) {
                OlapLoggers.UX_REQUEST.error((Object)("[UX] invalid completion type [" + this.type + "]"));
                cType = null;
            }
        }
        ArrayList<UxCompletionOption> options = new ArrayList<UxCompletionOption>();
        if (cType != null) {
            this.complete(queryContext, options, cType);
        }
        UxCompletion completion = new UxCompletion(options);
        return UxReply.actionSuccess(completion);
    }

    private boolean complete(UxQueryContext context, List<UxCompletionOption> options, UxCompletionType type) {
        try {
            switch (type) {
                case columnNames: {
                    UxSchemaDefsQueryMeta.SchemaDefs.assertAuthorized(context);
                    this.completeForColumnNames(context, options);
                    break;
                }
                case cubeNames: {
                    UxSchemaDefsQueryMeta.SchemaDefs.assertAuthorized(context);
                    this.completeForCubeNames(context, options, false);
                    break;
                }
                case cubeNamesEx: {
                    UxSchemaDefsQueryMeta.SchemaDefs.assertAuthorized(context);
                    this.completeForCubeNames(context, options, true);
                    break;
                }
                case dataTypedSourceNames: {
                    UxSchemaDefsQueryMeta.SchemaDefs.assertAuthorized(context);
                    this.completeForDataSourceNames(context, options);
                    break;
                }
                case deployedSchema: {
                    UxLoadedSchemasQueryMeta.LoadedSchemas.assertAuthorized(context);
                    this.completeForDeployedSchemas(context, options, true);
                    break;
                }
                case deployedSchemaDefFile: {
                    UxLoadedSchemasQueryMeta.LoadedSchemas.assertAuthorized(context);
                    this.completeForDeployedSchemas(context, options, false);
                    break;
                }
                case groupByAggregations: {
                    UxSchemaDefsQueryMeta.SchemaDefs.assertAuthorized(context);
                    this.completeForGroupByAggregation(context, options);
                    break;
                }
                case loadedSchema: {
                    this.completeForLoadedSchemas(context, options);
                    break;
                }
                case role: {
                    if (context.isCommunity() || !context.isRolesAvailable()) {
                        return false;
                    }
                    if (!(UxRolesQueryMeta.Roles.isAuthorized(context) || UxUsersQueryMeta.Users.isAuthorized(context) || UxAlertsQueryMeta.Alerts.isAuthorized(context))) {
                        return false;
                    }
                    this.completeForRoles(context, options);
                    break;
                }
                case schemaSnapshot: {
                    UxOfflinesQueryMeta.Offlines.assertAuthorized(context);
                    this.completeForSchemaSnapshots(context, options);
                    break;
                }
                case tableNames: {
                    UxSchemaDefsQueryMeta.SchemaDefs.assertAuthorized(context);
                    this.completeForTableNames(context, options);
                    break;
                }
                case tenant: {
                    if (!context.isWithMultiTenant()) {
                        return false;
                    }
                    this.completeForTenants(context, options);
                }
            }
        }
        catch (OlapRoleAuthorizationException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] completion authorization error", (Throwable)ex);
            return false;
        }
        this.filter(options);
        if (this.initialValue != null && !this.initialValue.isEmpty()) {
            HashSet<String> optionValues = new HashSet<String>();
            for (UxCompletionOption option : options) {
                optionValues.add(option.getValue());
            }
            for (String iValue : this.initialValue) {
                if (optionValues.contains(iValue)) continue;
                options.add(new UxCompletionOption(iValue));
                optionValues.add(iValue);
            }
        }
        options.sort((o1, o2) -> o1.getLabel().compareToIgnoreCase(o2.getLabel()));
        return true;
    }

    private void filter(List<UxCompletionOption> options) {
        if (CdStringUtils.isNullOrBlank((String)this.input)) {
            return;
        }
        String inputU = this.input.toUpperCase();
        ArrayList<UxCompletionOption> filtered = new ArrayList<UxCompletionOption>();
        for (UxCompletionOption option : options) {
            if (!option.getLabel().toUpperCase().contains(inputU)) continue;
            filtered.add(option);
        }
        options.clear();
        options.addAll(filtered);
    }

    private void completeForGroupByAggregation(UxQueryContext context, List<UxCompletionOption> options) {
        for (Aggregators.AggregateFunction value : Aggregators.AggregateFunction.values()) {
            options.add(new UxCompletionOption(value.name()));
        }
    }

    private void completeForRoles(UxQueryContext context, List<UxCompletionOption> options) {
        IcCubeServerApplicationContext appContext = context.getApplicationContext();
        IOlapPermissionsService service = appContext.getRolePermissionsService();
        List names = service.getAllRoleNamesForUX(true, true);
        for (String name : names) {
            options.add(new UxCompletionOption(name));
        }
    }

    private void completeForTenants(UxQueryContext context, List<UxCompletionOption> options) {
        IcCubeServerApplicationContext appContext = context.getApplicationContext();
        OlapTenantManager service = appContext.getTenantManager();
        List names = service.getTenantNamesForUX();
        OlapTenant tenant = context.asRuntimeContext().getDirectoriesResolved().getTenant();
        for (String name : names) {
            if (tenant != null && !tenant.getName().equals(name)) continue;
            options.add(new UxCompletionOption(name));
        }
    }

    private void completeForDeployedSchemas(UxQueryContext context, List<UxCompletionOption> options, boolean forName) {
        HashSet allNames = new HashSet();
        MutableInt count = new MutableInt(1000);
        OlapEngineComponent engine = context.getOlapEngineComponent();
        engine.foreachSchemaFactoryInfo(context.asRuntimeContext(), info -> {
            String schemaName = info.getName();
            if (forName && allNames.contains(schemaName)) {
                return true;
            }
            allNames.add(schemaName);
            count.decrement();
            if (count.intValue() < 0) {
                return false;
            }
            if (forName) {
                options.add(new UxCompletionOption(schemaName));
            } else {
                options.add(new UxCompletionOption(info.getFile().getName(), schemaName));
            }
            return true;
        });
        if (count.intValue() < 0) {
            return;
        }
        if (forName) {
            M_BackupManager backupManager = context.getBackupManager();
            backupManager.forEachBackupName(backup -> {
                if (allNames.contains(backup)) {
                    return;
                }
                allNames.add(backup);
                count.decrement();
                if (count.intValue() < 0) {
                    return;
                }
                options.add(new UxCompletionOption((String)backup));
            });
        }
    }

    private void completeForSchemaSnapshots(UxQueryContext context, List<UxCompletionOption> options) {
        OlapEngineComponent engine = context.getOlapEngineComponent();
        String factory = null;
        List names = new ArrayList();
        try {
            names = CdStringUtils.isNotNullAndNotBlank(factory) ? engine.getOfflineSnapshotNames(context.asRuntimeContext(), factory) : engine.getAllOfflineSnapshotNames(context.asRuntimeContext());
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] completion schema-snapshots error", (Throwable)ex);
        }
        UxBabylonService babylon = context.getUxBabylonService();
        for (String name : names) {
            String caption = UxModelConverterHelper.getSchemaSnapshotCaption(babylon.getLocale(), name);
            options.add(new UxCompletionOption(name, caption));
        }
    }

    private void completeForCubeNames(UxQueryContext context, List<UxCompletionOption> options, boolean withCubeUUID) {
        String schemaName = null;
        if (this.info != null && !this.info.isEmpty()) {
            schemaName = this.info.getFirst();
        }
        if (CdStringUtils.isNullOrBlank(schemaName)) {
            return;
        }
        UxSchemaId schemaId = new UxSchemaId(schemaName, null);
        try {
            UxBuilderSchemaService service = context.getPersistentSchemaService();
            service.readSchema(schemaId, -1, (lock, schema) -> {
                List<IOlapBuilderCubeDef> cubes = schema.getSortedCubes(lock);
                for (IOlapBuilderCubeDef cube : cubes) {
                    if (withCubeUUID) {
                        options.add(new UxCompletionOption(cube.getId(), cube.getName()));
                        continue;
                    }
                    options.add(new UxCompletionOption(cube.getName()));
                }
                return true;
            });
        }
        catch (UxBuilderSchemaServiceException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] completion schema error", (Throwable)ex);
        }
    }

    private void completeForTableNames(UxQueryContext context, List<UxCompletionOption> options) {
        String schemaName = null;
        if (this.info != null && !this.info.isEmpty()) {
            schemaName = this.info.getFirst();
        }
        if (CdStringUtils.isNullOrBlank(schemaName)) {
            return;
        }
        UxSchemaId schemaId = new UxSchemaId(schemaName, null);
        try {
            UxBuilderSchemaService service = context.getPersistentSchemaService();
            service.readSchema(schemaId, -1, (lock, schema) -> {
                UxTabularNames names = schema.getTabularNames(lock);
                for (UxTabularName name : names.names()) {
                    options.add(new UxCompletionOption(name.getUUID(), name.getCaption()));
                }
                return true;
            });
        }
        catch (UxBuilderSchemaServiceException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] completion schema error", (Throwable)ex);
        }
    }

    private void completeForDataSourceNames(UxQueryContext context, List<UxCompletionOption> options) {
        String dataSourceName;
        if (this.info == null || this.info.isEmpty()) {
            throw new CdShouldNotBeHereProgrammingException("invalid options");
        }
        String schemaName = this.info.getFirst();
        String string = dataSourceName = this.info.size() == 1 ? null : this.info.get(1);
        if (CdStringUtils.isNullOrBlank((String)schemaName) || CdStringUtils.isNullOrBlank((String)dataSourceName)) {
            return;
        }
        UxSchemaId schemaId = new UxSchemaId(schemaName, null);
        try {
            UxBuilderSchemaService service = context.getPersistentSchemaService();
            UxSwitchDataSourceQueryMeta.addMatchingDS(service, schemaId, dataSourceName, ds -> options.add(new UxCompletionOption(ds.getName())));
        }
        catch (UxBuilderSchemaServiceException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] completion schema error", (Throwable)ex);
        }
    }

    private void completeForColumnNames(UxQueryContext context, List<UxCompletionOption> options) {
        UxBabylonService babylon = context.getUxBabylonService();
        String schemaName = null;
        String uuid = null;
        if (this.info != null && this.info.size() > 1) {
            schemaName = this.info.get(0);
            uuid = this.info.get(1);
        }
        if (CdStringUtils.isNullOrBlank(schemaName) || CdStringUtils.isNullOrBlank(uuid)) {
            return;
        }
        UxSchemaId schemaId = new UxSchemaId(schemaName, null);
        String tableUUID = uuid;
        try {
            UxBuilderSchemaService service = context.getPersistentSchemaService();
            service.readSchema(schemaId, -1, (lock, schema) -> {
                List columns;
                IOlapBuilderTabularDataDef tabularData = schema.getTabularData(lock, tableUUID);
                if (tabularData instanceof IOlapBuilderDataViewDef) {
                    OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)false, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)((IOlapBuilderDataViewDef)tabularData));
                }
                if (tabularData != null && (columns = tabularData.getSortedSelectedColumnsUX()) != null) {
                    for (IOlapBuilderDataColumnDef column : columns) {
                        UxCompletionOptionLabel captionEx;
                        Object caption;
                        OlapBuilderInputType iType = column.getType();
                        if (iType != null) {
                            String cType = babylon.translateEnum(OlapBuilderInputType.class, iType.name());
                            caption = column.getName() + "<" + cType + ">";
                            captionEx = new UxCompletionOptionLabel(column.getName(), cType);
                        } else {
                            caption = column.getName();
                            captionEx = null;
                        }
                        options.add(new UxCompletionOption(column.getName(), (String)caption, captionEx));
                    }
                }
                return true;
            });
        }
        catch (UxBuilderSchemaServiceException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] completion schema error", (Throwable)ex);
        }
    }

    private void completeForLoadedSchemas(UxQueryContext context, List<UxCompletionOption> options) {
        int limit = 1000;
        OlapEngineComponent engine = context.getOlapEngineComponent();
        OlapRuntimeContext rContext = context.asRuntimeContext();
        OlapEngineRequestContext engineRequestContext = context.getOlapEngineRequestContext();
        OlapRoleApplicationPermissions appPerms = engineRequestContext.getApplicationPermissions();
        IOlapSchemasPermission schemasPerms = engineRequestContext.getSchemasPermissions();
        CdTruncatedList names = engine.getAllAuthorizedSchemaNames(rContext, appPerms, schemasPerms, 1000, this.input);
        for (String name : names) {
            options.add(new UxCompletionOption(name));
        }
    }
}

