/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidator;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveAlertQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private final UxModel model;

    public UxSaveAlertQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxModel model) {
        super(meta, requestId);
        this.model = model;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (this.model == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SCHEDULER_MISSING_ALERT_DEFINITION, (Serializable[])new Serializable[0]));
        }
        IcCubeSchedulerAlertJobDefinition serverModel = (IcCubeSchedulerAlertJobDefinition)queryContext.convertToServerModel(this.model);
        try {
            serverModel.setScheduledInfo(null);
            IcCubeSchedulerDefinitionValidator.validateDefinition(null, serverModel, true);
        }
        catch (OlapContextualBigException ex) {
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), ex.getErrors());
            return UxReply.validationErrors(validation);
        }
        IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
        try {
            int revNumber = this.model.getRevNumber();
            scheduler.saveAndScheduleJobDefinition(queryContext.asRuntimeContext(), queryContext.getUserName(), revNumber, serverModel);
            return UxReply.actionSuccess();
        }
        catch (IcCubeSchedulerDefinitionErrorException ex) {
            OlapLoggers.SCHEDULER.error((Object)("[ALERT] save alert [" + serverModel.getAlertName() + "] error"), (Throwable)((Object)ex));
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.SAVE_ALERT_ERROR, new Serializable[]{ex.getError().asMessage((CdBabylonService)queryContext.getOlapBabylonService())});
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
            return UxReply.validationErrors(validation);
        }
    }
}

