/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.common.exception.CdError;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.builder.model.UxBuilderEntityUniqueName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxRunNowAlertsQuery
extends UxAbstractSchedulerQuery {
    private final int revNumber;
    private final List<UxBuilderEntityUniqueName> names;

    protected UxRunNowAlertsQuery(UxQueryMeta meta, OlapRequestId requestId, int revNumber, @Nullable List<UxBuilderEntityUniqueName> names) {
        super(meta, requestId);
        this.revNumber = revNumber;
        this.names = names != null ? names : new ArrayList();
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        ArrayList<String> failedUUIDs = new ArrayList<String>();
        IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
        for (UxBuilderEntityUniqueName name : this.names) {
            String uuid = name.uuid;
            try {
                scheduler.runOutOfBand(queryContext.asRuntimeContext(), queryContext.getUserName(), uuid, null);
            }
            catch (IcCubeSchedulerDefinitionErrorException ex) {
                OlapLoggers.SCHEDULER.error((Object)"[ALERT] out-of-band alert [%s] error".formatted(uuid), (Throwable)((Object)ex));
                failedUUIDs.add(uuid);
            }
        }
        if (!failedUUIDs.isEmpty()) {
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.RUN_NOW_ALERTS_ERROR, new Serializable[0]);
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
            return UxReply.validationErrors(validation);
        }
        return UxReply.actionSuccess();
    }
}

