/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerValidJob;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxRunNowAlertQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private final String uuid;
    @Nullable
    private final String name;
    private final boolean sync;

    protected UxRunNowAlertQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid, @Nullable String name, boolean sync) {
        super(meta, requestId);
        this.uuid = uuid;
        this.name = name;
        this.sync = sync;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if ((this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) && (this.name == null || CdStringUtils.isNullOrBlank((String)this.name))) {
            return UxReply.actionSuccess();
        }
        try {
            IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
            IcCubeSchedulerJob scheduled = scheduler.runOutOfBand(queryContext.asRuntimeContext(), queryContext.getUserName(), this.uuid, this.name);
            if (this.sync && scheduled != null) {
                scheduled.waitForCompletion();
            }
            if (queryContext.isForRestApi()) {
                return UxReply.actionSuccess(new UxActionPerformed(scheduled instanceof IcCubeSchedulerValidJob, scheduled != null ? scheduled.getDefinition().getUuid() : null));
            }
            return UxReply.actionSuccess();
        }
        catch (IcCubeSchedulerDefinitionErrorException ex) {
            OlapLoggers.SCHEDULER.error((Object)"[ALERT] out-of-band alert [%s] error".formatted(this.uuid), (Throwable)((Object)ex));
            if (queryContext.isForRestApi()) {
                return UxReply.actionSuccess(new UxActionPerformed(false, ex.getError().asMessage((CdBabylonService)queryContext.getOlapBabylonService())));
            }
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.RUN_NOW_ALERT_ERROR, new Serializable[]{ex.getError().asMessage((CdBabylonService)queryContext.getOlapBabylonService())});
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
            return UxReply.validationErrors(validation);
        }
    }
}

