/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxEnableAlertQuery
extends UxAbstractSchedulerQuery {
    private final int revNumber;
    @Nullable
    private final String uuid;

    protected UxEnableAlertQuery(UxQueryMeta meta, OlapRequestId requestId, int revNumber, @Nullable String uuid) {
        super(meta, requestId);
        this.revNumber = revNumber;
        this.uuid = uuid;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
            return UxReply.actionSuccess();
        }
        try {
            IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
            scheduler.enableAndScheduleJobDefinition(queryContext.asRuntimeContext(), queryContext.getUserName(), this.revNumber, this.uuid);
            return UxReply.actionSuccess();
        }
        catch (IcCubeSchedulerDefinitionErrorException ex) {
            OlapLoggers.SCHEDULER.error((Object)"[ALERT] enable alert [%s] error".formatted(this.uuid), (Throwable)((Object)ex));
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.SAVE_ALERT_ERROR, new Serializable[]{ex.getError().asMessage((CdBabylonService)queryContext.getOlapBabylonService())});
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
            return UxReply.validationErrors(validation);
        }
        catch (OlapContextualBigException ex) {
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), ex.getErrors());
            return UxReply.validationErrors(validation);
        }
    }
}

