/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.common.collection.CdPair;
import crazydev.common.exception.CdError;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.builder.model.UxBuilderEntityUniqueName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDisableAlertsQuery
extends UxAbstractSchedulerQuery {
    private final int revNumber;
    private final List<UxBuilderEntityUniqueName> names;

    protected UxDisableAlertsQuery(UxQueryMeta meta, OlapRequestId requestId, int revNumber, @Nullable List<UxBuilderEntityUniqueName> names) {
        super(meta, requestId);
        this.revNumber = revNumber;
        this.names = names != null ? names : new ArrayList();
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (this.names.isEmpty()) {
            return UxReply.actionSuccess();
        }
        ArrayList<String> failedUUIDs = new ArrayList<String>();
        IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
        int revNb = this.revNumber;
        for (UxBuilderEntityUniqueName name : this.names) {
            String uuid = name.uuid;
            try {
                CdPair<Integer, IcCubeSchedulerJob> res = scheduler.disableAndScheduleJobDefinition(queryContext.asRuntimeContext(), queryContext.getUserName(), revNb, uuid);
                if (res == null) continue;
                revNb = (Integer)res.fst;
            }
            catch (OlapContextualBigException | IcCubeSchedulerDefinitionErrorException ex) {
                OlapLoggers.SCHEDULER.error((Object)"[ALERT] disable alert [%s] error".formatted(uuid), (Throwable)ex);
                failedUUIDs.add(uuid);
            }
        }
        if (!failedUUIDs.isEmpty()) {
            IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.SAVE_ALERTS_ERROR, new Serializable[0]);
            UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
            return UxReply.validationErrors(validation);
        }
        return UxReply.actionSuccess();
    }
}

