/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.alerts.UxAbstractAlertsScheduleQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertQuery;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertsQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxDeleteAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxDisableAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxDuplicateAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxEnableAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxRunNowAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxCronQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxAlertQueryMeta
extends UxAbstractAlertsScheduleQueryMeta {
    public static final UxAlertQueryMeta Alert = new UxAlertQueryMeta();

    protected UxAlertQueryMeta() {
        super(UxConsoleConstants.QueryName.Alert);
    }

    @Override
    @Nullable
    public UxUrl helpUrl() {
        return UxAlertsQueryMeta.Alerts.helpUrl();
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxCronQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String uuid = params.getStringParameter("uuid");
        return new UxAlertQuery((UxQueryMeta)this, params.getRequestId(), uuid);
    }

    public UxUrl createQueryUrl(String uuid) {
        return this.createQueryUrl().addParam("uuid", uuid);
    }

    public static UxUseCase createUseCase(UxQueryContext context, @Nullable String uuid, @Nullable String name, @Nullable String requestUuid) {
        IcCubeRequestStatusManager manager;
        IcCubeRequestStatus request;
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = Alert.createActions(context);
        if (requestUuid != null && (request = (manager = context.getRequestStatusManager()).getRequestStatus(requestUuid)) != null) {
            actions.add(UxRequestQueryMeta.createAction(context, babylon.translateActionCaption("ScheduleRequest", new Serializable[0]), request));
        }
        if (uuid != null) {
            OlapRuntimeContext rContext = context.asRuntimeContext();
            IcCubeScheduler scheduler = context.getScheduler(IcCubeSchedulerKind.ALERTS);
            int revNumber = scheduler.getCurrentRevNumber(rContext);
            actions.add(UxRunNowAlertQueryMeta.createAction(context, uuid, name));
            actions.add(UxDuplicateAlertQueryMeta.createAction(context, revNumber, uuid, name));
            actions.add(UxEnableAlertQueryMeta.createAction(context, revNumber, uuid));
            actions.add(UxDisableAlertQueryMeta.createAction(context, revNumber, uuid));
            actions.add(UxDeleteAlertQueryMeta.createAction(context, uuid, name));
        }
        return new UxUseCaseBuilder(context, Alert).withId(UxAdminUseCaseName.Alert, uuid).withUUID(uuid).withUrl(Alert.createQueryUrl(uuid)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Alerts), name != null ? name : uuid, UxAdminUseCaseRepository.asBookmark(Alert.createQueryUrl(uuid)))).withActions(actions).build(true);
    }
}

