/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.alerts;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.alerts.UxSaveAlertQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJob;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxAlertQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private final String uuid;
    @Nullable
    private IcCubeSchedulerAlertJobDefinition alert;
    @Nullable
    private String requestUuid;

    protected UxAlertQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ALERT_UNKNOWN, (Serializable[])new Serializable[]{""}));
        }
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.ALERTS);
        int revNumber = scheduler.getCurrentRevNumber(rContext);
        this.alert = (IcCubeSchedulerAlertJobDefinition)scheduler.getScheduleJobDefinition(rContext, this.uuid);
        if (this.alert == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ALERT_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        String alertUUID = this.uuid;
        UxScheduledJob job = UxScheduledJob.create(queryContext, scheduler.getScheduledJob(rContext, alertUUID));
        this.requestUuid = job.getLatestRequestUUID();
        this.alert.setScheduledInfo(job);
        UxModel model = queryContext.convertToUxModel(revNumber, this.alert);
        UxAction save = UxSaveAlertQueryMeta.createAction(queryContext, false, alertUUID);
        return UxReply.success(new UxModelReplyPayload(model, save));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxAlertQueryMeta.createUseCase(queryContext, this.uuid, this.alert != null ? this.alert.getAlertName() : null, this.requestUuid));
    }
}

