/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.xmla;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="xmlaComponentConfiguration")
public class IcCubeXmlaComponentConfiguration {
    @XmlElement(name="tcpPortNumber", required=false)
    private int _tcpPortNumber = -1;
    @XmlElement(name="tcpHostName", required=false)
    private String _tcpHostName = null;
    @XmlElement(name="httpUrl", required=true)
    private String httpUrl = "";
    @XmlElement(name="enableHttpCompression", required=false)
    private boolean enableHttpCompression = false;
    @XmlElement(name="filter", required=true)
    private List<String> httpFilters;

    public IcCubeXmlaComponentConfiguration() {
    }

    public IcCubeXmlaComponentConfiguration(int tcpPortNumber, String httpUrl, String httpFilter, boolean enableHttpCompression) {
        this.httpUrl = httpUrl;
        this.httpFilters = new ArrayList<String>();
        this.httpFilters.add(httpFilter);
        this.enableHttpCompression = enableHttpCompression;
    }

    public void onPreValidation() throws OlapConfigurationException {
    }

    public void validate() throws OlapConfigurationException {
        this.onPreValidation();
        if (this.httpUrl == null || CdStringUtils.isNullOrBlank((String)this.httpUrl)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"url"});
        }
        if (this.httpFilters == null || this.httpFilters.isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"XMLA authentication filter"});
        }
        for (String httpFilter : this.httpFilters) {
            if (!CdStringUtils.isNullOrBlank((String)httpFilter)) continue;
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"XMLA authentication filter"});
        }
    }

    public String getHttpUrl() {
        return this.httpUrl.trim();
    }

    public List<String> getHttpFilterConfiguration() {
        return this.httpFilters;
    }
}

