/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.validation;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.property.CdProperty;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerAbstractDefinitionValidator;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeSchedulerTriggerDefinitionValidator<MODEL extends IcCubeSchedulerTriggerDefinition>
extends IcCubeSchedulerAbstractDefinitionValidator<IcCubeSchedulerJobDefinition, MODEL> {
    @Override
    protected void doValidate(IcCubeSchedulerDefinitionValidationContext context, @Nullable IcCubeSchedulerJobDefinition owner, MODEL me) {
    }

    protected void validateHours(IcCubeSchedulerDefinitionValidationContext context, CdProperty property, int hours) {
        if (hours < 0 || hours > 23) {
            context.addError(property, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.HOURS_INVALID, new Serializable[]{Integer.valueOf(hours)});
        }
    }

    protected void validateMinutes(IcCubeSchedulerDefinitionValidationContext context, CdProperty property, int minutes) {
        if (minutes < 0 || minutes > 59) {
            context.addError(property, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.MINUTES_INVALID, new Serializable[]{Integer.valueOf(minutes)});
        }
    }
}

