/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.validation;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerCronTriggerDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerTriggerDefinitionValidator;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.spi.OperableTrigger;

public class IcCubeSchedulerCronTriggerDefinitionValidator
extends IcCubeSchedulerTriggerDefinitionValidator<IcCubeSchedulerCronTriggerDefinition> {
    @Override
    protected void doValidate(IcCubeSchedulerDefinitionValidationContext context, @Nullable IcCubeSchedulerJobDefinition owner, IcCubeSchedulerCronTriggerDefinition me) {
        super.doValidate(context, owner, me);
        String cronExpression = me.getExpression();
        this.validateNotNullField(context, IcCubeSchedulerCronTriggerDefinition.EXPRESSION, cronExpression);
        if (CdStringUtils.isNotNullAndNotBlank((String)cronExpression)) {
            try {
                CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
                TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity("ic3-quartz-trigger", "ic3").withSchedule((ScheduleBuilder)cronScheduleBuilder).forJob("ic3-quartz-job");
                CronTrigger cronTrigger = (CronTrigger)builder.build();
                OperableTrigger trigger = (OperableTrigger)cronTrigger;
                trigger.validate();
                me.setQuartzTrigger(trigger);
            }
            catch (SchedulerException ex) {
                context.addError(IcCubeSchedulerCronTriggerDefinition.EXPRESSION, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.CRON_EXPRESSION_INVALID, new Serializable[]{cronExpression, ex.getMessage()});
            }
            catch (RuntimeException ex) {
                String message = ex.getMessage();
                Throwable cause = ex.getCause();
                if (cause != null) {
                    message = cause.getMessage();
                }
                context.addError(IcCubeSchedulerCronTriggerDefinition.EXPRESSION, (CdErrorCode)IcCubeSchedulerDefinitionErrorCode.CRON_EXPRESSION_INVALID, new Serializable[]{cronExpression, message});
            }
        }
    }
}

