/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime.timegenerator;

import crazydev.iccube.olap.executor.OlapScheduledTimeGenerator;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDailyTriggerDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public class OlapDailyDaysOfMonthScheduledTimeGenerator
implements OlapScheduledTimeGenerator {
    private final boolean runOnStartup;
    private final int dayHour;
    private final int dayMinute;
    private final int[] sDaysOfMonthPOS;
    private final int[] sDaysOfMonthNEG;

    public OlapDailyDaysOfMonthScheduledTimeGenerator(IcCubeSchedulerDailyTriggerDefinition trigger) {
        this(trigger.isRunOnStartup(), trigger.getValidatedTimeHour(), trigger.getValidatedTimeMinute(), trigger.getValidatedDaysOfMonth());
    }

    public OlapDailyDaysOfMonthScheduledTimeGenerator(boolean runOnStartup, int dayHour, int dayMinute, List<Integer> daysOfMonth_) {
        int ii;
        ArrayList<Object> daysOfMonth;
        this.runOnStartup = runOnStartup;
        this.dayHour = dayHour;
        this.dayMinute = dayMinute;
        if (!daysOfMonth_.isEmpty()) {
            daysOfMonth = new ArrayList<Integer>(daysOfMonth_);
        } else {
            daysOfMonth = new ArrayList();
            for (int dd = 1; dd <= 31; ++dd) {
                daysOfMonth.add(dd);
            }
        }
        ArrayList<Integer> positives = new ArrayList<Integer>();
        ArrayList<Integer> negatives = new ArrayList<Integer>();
        Iterator iterator = daysOfMonth.iterator();
        while (iterator.hasNext()) {
            int dayOfMonth = (Integer)iterator.next();
            if (dayOfMonth == 0) {
                throw new RuntimeException("internal error: unexpected day of month value (0)");
            }
            if (dayOfMonth > 0) {
                positives.add(dayOfMonth - 1);
                continue;
            }
            negatives.add(-dayOfMonth - 1);
        }
        Collections.sort(positives);
        Collections.sort(negatives);
        this.sDaysOfMonthPOS = new int[positives.size()];
        this.sDaysOfMonthNEG = new int[negatives.size()];
        for (ii = 0; ii < positives.size(); ++ii) {
            this.sDaysOfMonthPOS[ii] = (Integer)positives.get(ii);
        }
        for (ii = 0; ii < negatives.size(); ++ii) {
            this.sDaysOfMonthNEG[ii] = (Integer)negatives.get(ii);
        }
    }

    public boolean isTerminated() {
        return false;
    }

    public long generateNextTimeMS(int runCount, boolean startup, long nowMS) {
        long scheduleMS = this.nextDailySchedule(nowMS);
        if (scheduleMS < nowMS) {
            throw new RuntimeException("internal error: inconsistent scheduler (daily w/ days of month - next time)");
        }
        if (startup && this.runOnStartup && !this.isToday(nowMS, scheduleMS)) {
            return nowMS;
        }
        return scheduleMS;
    }

    private long nextDailySchedule(long nowMS) {
        Calendar calendar = GregorianCalendar.getInstance();
        int count = 0;
        do {
            long[] sDaysOfMonth;
            for (long sDayOfMonth : sDaysOfMonth = this.generateSchedule(nowMS, count, calendar)) {
                if (sDayOfMonth < nowMS) continue;
                return sDayOfMonth;
            }
        } while (++count <= 12);
        throw new RuntimeException("internal error: inconsistent scheduler usage");
    }

    private long[] generateSchedule(long nowMS, int loop, Calendar calendar) {
        int ii;
        long[] scheduleMS = new long[this.sDaysOfMonthPOS.length + this.sDaysOfMonthNEG.length];
        int pos = 0;
        for (ii = 0; ii < this.sDaysOfMonthPOS.length; ++ii) {
            calendar.setTimeInMillis(nowMS);
            calendar.set(5, 1);
            calendar.set(11, this.dayHour);
            calendar.set(12, this.dayMinute);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, loop);
            calendar.add(5, this.sDaysOfMonthPOS[ii]);
            scheduleMS[pos++] = calendar.getTimeInMillis();
        }
        for (ii = 0; ii < this.sDaysOfMonthNEG.length; ++ii) {
            calendar.setTimeInMillis(nowMS);
            int days = calendar.getActualMaximum(5);
            calendar.set(5, days);
            calendar.set(11, this.dayHour);
            calendar.set(12, this.dayMinute);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, loop);
            calendar.add(5, -this.sDaysOfMonthNEG[ii]);
            scheduleMS[pos++] = calendar.getTimeInMillis();
        }
        Arrays.sort(scheduleMS);
        return scheduleMS;
    }

    private boolean isToday(long nowMS, long scheduleMS) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(nowMS);
        int nowDayOfYear = calendar.get(6);
        int nowYear = calendar.get(1);
        calendar.setTimeInMillis(scheduleMS);
        int scheduleDayOfYear = calendar.get(6);
        int scheduleYear = calendar.get(1);
        return nowDayOfYear == scheduleDayOfYear && nowYear == scheduleYear;
    }
}

