/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime.timegenerator;

import crazydev.iccube.olap.executor.OlapScheduledTimeGenerator;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerCronTriggerDefinition;
import java.util.Date;
import org.quartz.spi.OperableTrigger;

public class OlapCronScheduledTimeGenerator
implements OlapScheduledTimeGenerator {
    private final IcCubeSchedulerCronTriggerDefinition triggerDefinition;
    private final OperableTrigger trigger;
    private volatile boolean terminated;

    public OlapCronScheduledTimeGenerator(IcCubeSchedulerCronTriggerDefinition trigger) {
        this.triggerDefinition = trigger;
        this.trigger = trigger.getQuartzTrigger();
        if (this.trigger == null) {
            throw new RuntimeException("internal error: missing validated cron trigger for : " + trigger.getInfoForLogging());
        }
        this.terminated = false;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public long generateNextTimeMS(int runCount, boolean startup, long nowMS) {
        Date now = new Date(nowMS);
        Date next = this.trigger.getFireTimeAfter(now);
        if (next == null) {
            this.terminated = true;
        }
        return next != null ? next.getTime() : -1L;
    }
}

