/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime.businesslogic;

import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.gwt.base.shared.comm.GwtExceptionReply;
import crazydev.iccube.gwt.base.shared.comm.GwtReply;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtAbstractLoadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtFullReloadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadOfflineSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtOfflineSnapshot;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoError;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoParser;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerLoadSchemaJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunInfo;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerLoadSchemaJobRunInfo;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerLoadSchemaJobBusinessLogic
implements IcCubeSchedulerJobBusinessLogic<IcCubeSchedulerLoadSchemaJobDefinition> {
    private final OlapTenant tenant;
    private final IcCubeSchedulerLoadSchemaJobDefinition jobDefinition;
    private final File schemaFactoryFile;
    private final boolean fullLoad;
    private final boolean keepMdxResultCache;
    @Nullable
    private final String offlineSnapshot;
    private final boolean generateOfflineSnapshot;

    public IcCubeSchedulerLoadSchemaJobBusinessLogic(IcCubeEngine engine, @Nullable OlapTenant tenant, IcCubeSchedulerLoadSchemaJobDefinition jobDefinition) {
        this.tenant = tenant;
        this.jobDefinition = jobDefinition;
        String filename = jobDefinition.getSchemaFactoryFileName();
        File file = new File(filename);
        if (!file.isAbsolute()) {
            OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)engine.getOlapEngineApplicationContext(), (OlapTenant)tenant);
            file = new File(rContext.getDirectoriesResolved().getCubesDirectory(), file.getPath());
        }
        this.schemaFactoryFile = file;
        this.fullLoad = jobDefinition.isFullLoad();
        this.keepMdxResultCache = jobDefinition.isKeepMdxResultCache();
        this.offlineSnapshot = jobDefinition.getOfflineSnapshot();
        this.generateOfflineSnapshot = jobDefinition.isGenerateOfflineSnapshot();
    }

    @Override
    public IcCubeSchedulerKind kind() {
        return IcCubeSchedulerKind.SCHEMAS;
    }

    @Override
    public IcCubeSchedulerLoadSchemaJobDefinition getJobDefinition() {
        return this.jobDefinition;
    }

    @Override
    public boolean isLoadingSchema(File backups, File factory) {
        OlapSchemaFactoryInfo otherInfo;
        OlapSchemaFactoryInfo thisInfo;
        if (this.schemaFactoryFile.equals(factory)) {
            return true;
        }
        try {
            String backup = backups.getCanonicalPath();
            String path = factory.getCanonicalPath();
            if (!path.startsWith(backup)) {
                return false;
            }
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.warn((Object)"[builder] could not retrieve scheduling (backup) factory", (Throwable)ex);
            return false;
        }
        try {
            thisInfo = OlapSchemaFactoryInfoParser.parse((File)this.schemaFactoryFile);
        }
        catch (OlapSchemaFactoryInfoError | RuntimeException ex) {
            OlapLoggers.BUILDER.warn((Object)"[builder] could not retrieve scheduling (this) factory", ex);
            return false;
        }
        try {
            otherInfo = OlapSchemaFactoryInfoParser.parse((File)factory);
        }
        catch (OlapSchemaFactoryInfoError | RuntimeException ex) {
            OlapLoggers.BUILDER.warn((Object)"[builder] could not retrieve scheduling (other) factory", ex);
            return false;
        }
        String thisName = thisInfo.getName();
        String otherName = otherInfo.getName();
        return thisName.equals(otherName);
    }

    @Override
    public IcCubeSchedulerJobRunInfo run(IcCubeEngine engine) {
        GwtAbstractLoadSchemaQuery request;
        long startTimeMs = System.currentTimeMillis();
        if (this.offlineSnapshot == null) {
            request = this.generateOfflineSnapshot ? new GwtLoadOfflineSchemaQuery(true, this.schemaFactoryFile.getName(), this.schemaFactoryFile.getAbsolutePath(), GwtLoadOfflineSchemaQuery.Mode.WRITING, null) : (this.fullLoad ? new GwtFullReloadSchemaQuery(this.schemaFactoryFile.getName(), this.schemaFactoryFile.getAbsolutePath()) : new GwtLoadSchemaQuery(this.schemaFactoryFile.getName(), this.schemaFactoryFile.getAbsolutePath(), this.keepMdxResultCache));
        } else {
            GwtOfflineSnapshot snapshot = new GwtOfflineSnapshot(this.offlineSnapshot, this.offlineSnapshot, this.schemaFactoryFile.getName(), this.schemaFactoryFile.getAbsolutePath(), "n/a", -1L);
            request = new GwtLoadOfflineSchemaQuery(true, this.schemaFactoryFile.getName(), this.schemaFactoryFile.getAbsolutePath(), GwtLoadOfflineSchemaQuery.Mode.READING, snapshot);
        }
        GwtReply<? extends GwtInfo> reply = engine.submitAndWaitGwtRequest(request, this.tenant);
        IcCubeSchedulerJobRunInfo runInfo = this.setupRunInfo(engine, startTimeMs, request, reply);
        return runInfo;
    }

    private IcCubeSchedulerJobRunInfo setupRunInfo(IcCubeEngine engine, long startTimeMs, GwtAbstractLoadSchemaQuery request, GwtReply reply) {
        GwtSchemaLoadStatus status;
        boolean deactivated = false;
        if (reply instanceof GwtExceptionReply) {
            status = GwtSchemaLoadStatus.LOAD_ERROR;
        } else {
            Object response = reply.getPayload();
            if (response instanceof GwtSchemaLifeCycleReply) {
                OlapRuntimeContext rContext;
                OlapEngineComponent oEngine;
                OlapSchemaInformation loadedSchema;
                GwtSchemaLifeCycleReply responseLC = (GwtSchemaLifeCycleReply)response;
                status = responseLC.getStatus();
                if (status == GwtSchemaLoadStatus.INCREMENTAL_LOAD_ERROR && (loadedSchema = (oEngine = engine.getOlapEngineComponent()).getLoadedSchemaInformation(rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)engine.getOlapEngineApplicationContext(), (OlapTenant)this.tenant), responseLC.getSchema())) != null) {
                    deactivated = loadedSchema.isIncrLoadDeActivatedOnError();
                }
            } else {
                status = GwtSchemaLoadStatus.LOAD_ERROR;
            }
        }
        return new IcCubeSchedulerLoadSchemaJobRunInfo(startTimeMs, request.getClientUUID(), status, deactivated);
    }
}

