/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime.businesslogic;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.base.shared.comm.GwtCancelledReply;
import crazydev.iccube.gwt.base.shared.comm.GwtExceptionReply;
import crazydev.iccube.gwt.base.shared.comm.GwtReply;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoDefinition;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmosRepository;
import crazydev.iccube.gwt.shared.portlets.qeditor.command.GwtEvalAlertQuery;
import crazydev.iccube.gwt.shared.portlets.qeditor.command.GwtEvalAlertQueryResult;
import crazydev.iccube.notification.IOlapNotificationListener;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.principal.OlapInternalPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.request.report.GviPrintParams;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintReportBatchJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSize;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSizes;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerAlertJobRunInfo;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunInfo;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerAlertJobBusinessLogic
implements IcCubeSchedulerJobBusinessLogic<IcCubeSchedulerAlertJobDefinition> {
    private final IcCubeSchedulerAlertJobDefinition jobDefinition;
    private final OlapPrincipal principal;

    public IcCubeSchedulerAlertJobBusinessLogic(IcCubeEngine engine, @Nullable OlapTenant tenant, IcCubeSchedulerAlertJobDefinition jobDefinition) {
        this.jobDefinition = jobDefinition;
        String role = jobDefinition.getRoleName();
        Locale locale = jobDefinition.getLocale();
        this.principal = new OlapInternalPrincipal(tenant, "icCube", role == null ? "administrator" : role, locale);
    }

    @Override
    public IcCubeSchedulerKind kind() {
        return IcCubeSchedulerKind.ALERTS;
    }

    @Override
    public IcCubeSchedulerAlertJobDefinition getJobDefinition() {
        return this.jobDefinition;
    }

    @Override
    public boolean isLoadingSchema(File backups, File factory) {
        return false;
    }

    @Override
    public IcCubeSchedulerJobRunInfo run(IcCubeEngine engine) {
        IcCubeSchedulerAlertJobRunInfo res = this.evalAlertMdxExpression(engine);
        if (res.isOnError()) {
            this.alertMdxEvaluationOnErrorSafe(engine, res);
        } else if (res.isAlerted()) {
            this.alertMdxEvaluationOnSuccessSafe(engine, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IcCubeSchedulerAlertJobRunInfo evalAlertMdxExpression(IcCubeEngine engine) {
        long startTimeMs = System.currentTimeMillis();
        String schemaName = this.jobDefinition.getSchemaName();
        String alertName = this.jobDefinition.getAlertName();
        if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(this.kind().logName() + " starting [schema:" + schemaName + "] [alert:" + alertName + "] " + this.jobDefinition.getDescription()));
        }
        try {
            IcCubeSchedulerAlertJobRunInfo res;
            IcCubeSchedulerAlertJobRunInfo icCubeSchedulerAlertJobRunInfo = res = this.evalAlertMdxExpressionUnsafe(engine, startTimeMs);
            return icCubeSchedulerAlertJobRunInfo;
        }
        catch (RuntimeException ex) {
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] unexpected error"), (Throwable)ex);
            IcCubeSchedulerAlertJobRunInfo icCubeSchedulerAlertJobRunInfo = IcCubeSchedulerAlertJobRunInfo.failure(startTimeMs, "n/a", "unexpected error:" + ex.getMessage());
            return icCubeSchedulerAlertJobRunInfo;
        }
        finally {
            if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
                OlapLoggers.SCHEDULER.info((Object)(this.kind().logName() + " completed [schema:" + schemaName + "] [alert:" + alertName + "]"));
            }
        }
    }

    private IcCubeSchedulerAlertJobRunInfo evalAlertMdxExpressionUnsafe(IcCubeEngine engine, long startTimeMs) {
        Locale locale;
        String localeName;
        String schemaName = this.jobDefinition.getSchemaName();
        String alertName = this.jobDefinition.getAlertName();
        String alertStatement = this.jobDefinition.getAlertStatement();
        String alertCubeName = this.jobDefinition.getAlertCubeName();
        String roleName = this.jobDefinition.getRoleName();
        GwtEvalAlertQuery request = new GwtEvalAlertQuery(roleName, localeName = (locale = this.jobDefinition.getLocale()) != null ? locale.toString() : null, schemaName, alertName, alertStatement, alertCubeName);
        GwtReply<? extends GwtInfo> reply = engine.submitAndWaitGwtRequest(request, this.principal.getTenant());
        if (reply instanceof GwtCancelledReply) {
            OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] processing cancelled"));
            return IcCubeSchedulerAlertJobRunInfo.success(startTimeMs, request.getClientUUID(), false);
        }
        if (reply instanceof GwtExceptionReply) {
            GwtExceptionReply error = (GwtExceptionReply)reply;
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] processing error \n" + error.getInfo()));
            return IcCubeSchedulerAlertJobRunInfo.failure(startTimeMs, request.getClientUUID(), "Alert (" + this.jobDefinition.getAlertName() + ") processing error \n" + error.getInfo());
        }
        GwtInfo payload = reply.getPayload();
        if (payload instanceof GwtEvalAlertQueryResult) {
            GwtEvalAlertQueryResult result = (GwtEvalAlertQueryResult)payload;
            GwtEvalAlertQueryResult.Kind rKind = result.kind();
            switch (rKind) {
                case OK: {
                    return IcCubeSchedulerAlertJobRunInfo.success(startTimeMs, request.getClientUUID(), result.isAlerted());
                }
                case SCHEMA_NOT_LOADED: {
                    return IcCubeSchedulerAlertJobRunInfo.success(startTimeMs, request.getClientUUID(), false);
                }
                case MISSING_SCHEMA: {
                    return IcCubeSchedulerAlertJobRunInfo.failure(startTimeMs, request.getClientUUID(), "Schema unknown : " + this.jobDefinition.getSchemaName());
                }
                case MISSING_ALERT: {
                    return IcCubeSchedulerAlertJobRunInfo.failure(startTimeMs, request.getClientUUID(), "Alert unknown : " + this.jobDefinition.getAlertName());
                }
                case MISSING_CUBE: {
                    String err = result.getError();
                    if (CdStringUtils.isNullOrBlank((String)err)) {
                        err = "no detail available.";
                    }
                    return IcCubeSchedulerAlertJobRunInfo.failure(startTimeMs, request.getClientUUID(), "Cube error : " + err);
                }
            }
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] unexpected result (" + String.valueOf((Object)rKind) + ")"));
            return IcCubeSchedulerAlertJobRunInfo.failure(startTimeMs, request.getClientUUID(), "Unexpected result : " + String.valueOf((Object)rKind));
        }
        OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] unexpected result (" + (payload != null ? payload.getClass().getSimpleName() : "") + ")"));
        return IcCubeSchedulerAlertJobRunInfo.failure(startTimeMs, request.getClientUUID(), "Internal error: unexpected alert result.");
    }

    private void alertMdxEvaluationOnErrorSafe(IcCubeEngine engine, IcCubeSchedulerAlertJobRunInfo res) {
        String schemaName = this.jobDefinition.getSchemaName();
        String alertName = this.jobDefinition.getAlertName();
        if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation failed [schema:" + schemaName + "] [alert:" + alertName + "] "));
        }
        NotificationParams params = this.setupNotificationParamsOnError(res.getError());
        OlapNotificationService notificationService = engine.getNotificationService();
        notificationService.onAlert(null, true, params.toAddresses, params.subject, params.body, params.attachment, params.attachmentName);
    }

    private void alertMdxEvaluationOnSuccessSafe(IcCubeEngine engine, IcCubeSchedulerAlertJobRunInfo res) {
        String schemaName = this.jobDefinition.getSchemaName();
        String alertName = this.jobDefinition.getAlertName();
        if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert evaluation succeeded [schema:" + schemaName + "] [alert:" + alertName + "] [value:" + res.isAlerted() + "]"));
        }
        if (!this.jobDefinition.hasReportPdf()) {
            NotificationParams params = this.setupNotificationParamsOnSuccess(null, null);
            OlapNotificationService notificationService = engine.getNotificationService();
            notificationService.onAlert(null, false, params.toAddresses, params.subject, params.body, params.attachment, params.attachmentName);
            return;
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)this.jobDefinition.getV8ReportPdf())) {
            this.alertOnSuccessWithPdfSafeV8(engine, res);
        }
    }

    private void alertOnSuccessWithPdfSafeV8(IcCubeEngine engine, IcCubeSchedulerAlertJobRunInfo res) {
        String schemaName = this.jobDefinition.getSchemaName();
        String alertName = this.jobDefinition.getAlertName();
        String reportPdf = this.jobDefinition.getV8ReportPdf();
        if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert generate PDF [schema:" + schemaName + "] [alert:" + alertName + "] [value:" + res.isAlerted() + "] - " + reportPdf));
        }
        if (this.isReportMissingMF(engine, reportPdf)) {
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " [schema:" + schemaName + "] [alert:" + alertName + "] missing report (" + reportPdf + ")"));
            this.alertOnSuccessWithPdfErrorSafe(engine, res, "The report does not exist : " + reportPdf);
            return;
        }
        IcCubePrintService printService = engine.getPrintService();
        if (printService == null) {
            this.alertOnSuccessWithPdfErrorSafe(engine, res, "Report PDF generation failed (no print server available)");
            return;
        }
        try {
            OlapBabylonService babylon = new OlapBabylonService(this.jobDefinition.getLocale());
            IcCubeRequestStatusManager requests = engine.getRequestStatusManager();
            IcCubePrintReportBatchJob printJob = this.setupPrintJobMF(printService, res.getRequestUuid());
            IcCubePrintJobResult printResult = printService.execute(babylon, requests, printJob);
            if (printResult.isInError()) {
                String printError;
                if (printResult.getHttpErrorCode() == 429) {
                    // empty if block
                }
                this.alertOnSuccessWithPdfErrorSafe(engine, res, "Report PDF generation failed (" + ((printError = printResult.getError()) != null ? printError : "no additional information available") + ")");
                return;
            }
            Serializable attachement = printResult.getAttachmentContent();
            NotificationListener callback = new NotificationListener(schemaName, alertName, attachement);
            NotificationParams params = this.setupNotificationParamsOnSuccess(attachement, printResult.getAttachmentName());
            OlapNotificationService notificationService = engine.getNotificationService();
            notificationService.onAlert((IOlapNotificationListener)callback, false, params.toAddresses, params.subject, params.body, params.attachment, params.attachmentName);
        }
        catch (InterruptedException | RuntimeException ex) {
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert generate PDF error [schema:" + schemaName + "] [alert:" + alertName + "]"), (Throwable)ex);
            StringWriter str = new StringWriter();
            PrintWriter writer = new PrintWriter(str);
            ex.printStackTrace(writer);
            writer.flush();
            String stack = str.toString();
            this.alertOnSuccessWithPdfErrorSafe(engine, res, "Report PDF generation failed (" + ex.getMessage() + ") \n" + stack);
            return;
        }
    }

    private boolean isReportMissingMF(IcCubeEngine engine, String reportPath) {
        IOlapPermissionsService services = engine.getAuthorizationService();
        OlapRolePermissions role = services.getRolePermissions(this.principal.getRoleName());
        if (role == null) {
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " unexpected missing role [" + this.principal.getRoleName() + "]"));
            return true;
        }
        OlapRoleApplicationPermissions perms = role.getApplicationPermissions();
        try {
            perms.assertReportDashboardReaderEnabled();
            OlapDocsRequestContext repositoryContext = new OlapDocsRequestContext(this.principal, perms);
            IcCubeServerApplicationContext appContext = engine.getApplicationContext();
            OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)engine.getOlapEngineApplicationContext(), (OlapTenant)this.principal.getTenant());
            OlapDocsActualRepository docs = appContext.getDocsRepository(rContext);
            OlapPath namePath = docs.fromLogicalSimplePath(repositoryContext, reportPath);
            OlapDocsGizmosRepository gizmos = docs.asGizmosRepository(OlapDocsGizmoEntityType.DASHBOARD);
            OlapDocsGizmoDefinition ignored = gizmos.getGizmo(repositoryContext, namePath);
            return false;
        }
        catch (OlapRoleAuthorizationException ex) {
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " auth. error for role [" + this.principal.getRoleName() + "]"), (Throwable)ex);
            return true;
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.SCHEDULER.error((Object)(IcCubeSchedulerKind.ALERTS.logName() + " report [" + reportPath + "] definition error for role [" + this.principal.getRoleName() + "]"), (Throwable)((Object)ex));
            return true;
        }
    }

    private void alertOnSuccessWithPdfErrorSafe(IcCubeEngine engine, IcCubeSchedulerAlertJobRunInfo res, String error) {
        res.setPdfOnError();
        String schemaName = this.jobDefinition.getSchemaName();
        String alertName = this.jobDefinition.getAlertName();
        if (OlapLoggers.SCHEDULER.isInfoEnabled()) {
            OlapLoggers.SCHEDULER.info((Object)(IcCubeSchedulerKind.ALERTS.logName() + " alert generate PDF failed [schema:" + schemaName + "] [alert:" + alertName + "] "));
        }
        NotificationParams params = this.setupNotificationParamsOnError(error);
        OlapNotificationService notificationService = engine.getNotificationService();
        notificationService.onAlert(null, true, params.toAddresses, params.subject, params.body, params.attachment, params.attachmentName);
    }

    private IcCubePrintReportBatchJob setupPrintJobMF(IcCubePrintService printService, @Nullable String requestUuid) {
        IcCubePaperSize paperSize;
        IcCubePrintComponentConfiguration configuration = printService.getConfiguration();
        String pageSizeName = this.jobDefinition.getV8PageSize();
        String pageOrientation = this.jobDefinition.getV8PageOrientation();
        IcCubePaperSizes paperSizes = configuration.getPaperSizes();
        IcCubePaperSize icCubePaperSize = paperSize = paperSizes != null ? paperSizes.getPaperSize(pageSizeName) : null;
        if (paperSize == null) {
            OlapLoggers.PRINT.error((Object)("configuration error: missing paper size [" + pageSizeName + "]"));
            throw new RuntimeException("configuration error: missing paper size [" + pageSizeName + "]");
        }
        String appUrl = "-";
        String appLocalUrl = "dft";
        String appCustomizationUrl = "-";
        String reportPath = this.jobDefinition.getV8ReportPdf();
        int timeoutS = this.jobDefinition.getV8ReportPdfTimeout();
        Integer debugWaitingTimeS = null;
        double scale = 1.0;
        String pageSizeUnits = paperSize.getUnit();
        double pageWidth = paperSize.getWidthEx();
        double pageHeight = paperSize.getHeightEx();
        if (pageOrientation.equalsIgnoreCase("landscape")) {
            double w = pageWidth;
            pageWidth = pageHeight;
            pageHeight = w;
        }
        double marginTop = this.jobDefinition.getMarginTop(paperSize.getMarginTopEx());
        double marginRight = this.jobDefinition.getMarginRight(paperSize.getMarginRightEx());
        double marginLeft = this.jobDefinition.getMarginLeft(paperSize.getMarginLeftEx());
        double marginBottom = this.jobDefinition.getMarginBottom(paperSize.getMarginBottomEx());
        String fileName = this.jobDefinition.getV8FileName();
        HashMap<String, String> reportingOptions = new HashMap<String, String>();
        reportingOptions.put("pageSizeName", pageSizeName);
        reportingOptions.put("pageOrientation", pageOrientation);
        GviPrintParams printParams = new GviPrintParams("-", "dft", "-", reportPath, null, null, timeoutS, debugWaitingTimeS, 1.0, pageSizeUnits, pageWidth, pageHeight, marginTop, marginRight, marginLeft, marginBottom, fileName, reportingOptions);
        String widget = this.jobDefinition.getV8ReportWidget();
        String widgetExportType = this.jobDefinition.getV8ReportWidgetExportType();
        String widgetFileName = this.jobDefinition.getV8ReportWidgetFileName();
        AlertAttachmentType attachmentType = this.jobDefinition.getAttachmentType();
        return new IcCubePrintReportBatchJob(printService, requestUuid != null ? requestUuid : "n/a", this.principal, printParams, null, attachmentType, widget, widgetExportType, widgetFileName);
    }

    private NotificationParams setupNotificationParamsOnSuccess(@Nullable Serializable attachment, @Nullable String attachmentName) {
        InternetAddress[] toAddresses = this.jobDefinition.getParsedToAddresses();
        String subject = this.jobDefinition.getSubject();
        String body = this.jobDefinition.getBody();
        return new NotificationParams(toAddresses, subject, body, attachment, attachmentName);
    }

    private NotificationParams setupNotificationParamsOnError(@Nullable String error) {
        InternetAddress[] toAddresses = this.jobDefinition.getParsedToAddressesOnError();
        String subject = this.jobDefinition.getSubjectOnErrorX(error);
        String body = this.jobDefinition.getBodyOnErrorX(error);
        return new NotificationParams(toAddresses, subject, body, null, null);
    }

    static class NotificationParams {
        @Nullable
        final InternetAddress[] toAddresses;
        final String subject;
        final String body;
        @Nullable
        final Serializable attachment;
        @Nullable
        final String attachmentName;

        public NotificationParams(@Nullable InternetAddress[] toAddresses, String subject, String body, @Nullable Serializable attachment, @Nullable String attachmentName) {
            this.toAddresses = toAddresses;
            this.subject = subject;
            this.body = body;
            this.attachment = attachment;
            this.attachmentName = attachmentName;
        }
    }

    static class NotificationListener
    implements IOlapNotificationListener {
        private final String schemaName;
        private final String alertName;
        private final Serializable attachment;

        public NotificationListener(String schemaName, String alertName, Serializable attachment) {
            this.schemaName = schemaName;
            this.alertName = alertName;
            this.attachment = attachment;
        }

        public void onNotified() {
        }

        public void onFinally() {
            if (this.attachment != null && this.attachment instanceof File) {
                File file = (File)this.attachment;
                if (OlapLoggers.SCHEDULER.isDebugEnabled()) {
                    OlapLoggers.SCHEDULER.debug((Object)(IcCubeSchedulerKind.ALERTS.logName() + " deleting PDF for [schema:" + this.schemaName + "] [alert:" + this.alertName + "] - " + file.getAbsolutePath()));
                }
                boolean deleted = file.delete();
                if (OlapLoggers.SCHEDULER.isDebugEnabled()) {
                    OlapLoggers.SCHEDULER.debug((Object)(IcCubeSchedulerKind.ALERTS.logName() + " deleted (" + deleted + ") PDF for [schema:" + this.schemaName + "] [alert:" + this.alertName + "] - " + file.getAbsolutePath()));
                }
            }
        }
    }

    static class OlapDocsRequestContext
    implements IOlapDocsRequestContext {
        final OlapPrincipal principal;
        final OlapRoleApplicationPermissions perms;

        public OlapDocsRequestContext(OlapPrincipal principal, OlapRoleApplicationPermissions perms) {
            this.principal = principal;
            this.perms = perms;
        }

        @Override
        public boolean isWebDashboardsAutoInstall() {
            return false;
        }

        @Override
        public OlapPrincipal getUser() {
            return this.principal;
        }

        @Override
        public boolean isAdministrator() {
            return this.getUser().isAdministrator();
        }

        @Override
        public boolean isDocAdministrator() {
            return this.perms.isReportDocManagementAdministratorEnabled();
        }

        @Override
        public boolean isAppCreator() {
            return this.perms.isReportDashboardApplicationCreateEnabled();
        }
    }
}

