/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobLogicMode;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnable;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
public class IcCubeSchedulerValidJob
extends IcCubeSchedulerJob {
    private final IcCubeSchedulerJobRunnable runnable;
    private final ScheduledFuture<?> future;

    public IcCubeSchedulerValidJob(IcCubeSchedulerKind kind, IcCubeSchedulerJobRunnable runnable, ScheduledFuture<?> future) {
        super(kind);
        this.runnable = runnable;
        this.future = future;
    }

    @Override
    public void waitForCompletion() {
        if (this.future != null) {
            try {
                this.future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancel() {
        if (this.future == null) {
            return;
        }
        this.future.cancel(true);
    }

    @Override
    public boolean isDone() {
        if (this.future == null) {
            return false;
        }
        return this.future.isDone();
    }

    @Override
    public IcCubeSchedulerJobDefinition getDefinition() {
        IcCubeSchedulerJobDefinition definition = this.runnable.getJobDefinition();
        return definition;
    }

    @Override
    public boolean isEnabled() {
        IcCubeSchedulerJobDefinition definition = this.runnable.getJobDefinition();
        return definition.isEnabled();
    }

    @Override
    @Nullable
    public IcCubeSchedulerJobLogicMode getMode() {
        IcCubeSchedulerJobLogicMode outOfBand = super.getMode();
        if (outOfBand != null) {
            return outOfBand;
        }
        return this.runnable.getMode();
    }

    @Override
    public IcCubeSchedulerTriggerDefinition getTrigger() {
        IcCubeSchedulerJobDefinition definition = this.runnable.getJobDefinition();
        return definition.getTrigger();
    }

    @Override
    public boolean isBoundTo(ScheduledFuture<?> future) {
        return super.isBoundTo(future) || this.future == future;
    }

    @Override
    public String getScheduledInfoForLogging() {
        IcCubeSchedulerJobDefinition definition = this.runnable.getJobDefinition();
        return "(" + definition.getInfoForLogging() + ") " + definition.getTrigger().getInfoForLogging();
    }

    @Override
    public boolean isForDefinition(String definitionUuid) {
        IcCubeSchedulerJobBusinessLogic businessLogic = this.runnable.getBusinessLogic();
        return ((IcCubeSchedulerJobDefinition)businessLogic.getJobDefinition()).getUuid().equals(definitionUuid);
    }

    @Override
    public boolean isForLoadSchema(File backups, File factory) {
        IcCubeSchedulerJobBusinessLogic businessLogic = this.runnable.getBusinessLogic();
        return businessLogic.isLoadingSchema(backups, factory);
    }

    @Override
    public long getNextScheduledTimeMS() {
        if (this.future == null) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        long time = now + this.future.getDelay(TimeUnit.MILLISECONDS);
        return time;
    }

    @Override
    @Nullable
    public String getLatestRequestUuid() {
        return this.runnable.getLatestRequestUuid();
    }

    @Override
    public boolean isOnError() {
        return false;
    }

    @Override
    @Nullable
    public GwtSchemaLoadStatus getLatestLoadStatus() {
        return this.runnable.getLatestLoadStatus();
    }

    @Override
    public List<OlapContextualError> getErrors() {
        return Collections.emptyList();
    }
}

