/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunInfo;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnable;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnableException;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerLoadSchemaJobRunInfo
extends IcCubeSchedulerJobRunInfo {
    private final GwtSchemaLoadStatus status;
    private final boolean deactivated;

    public IcCubeSchedulerLoadSchemaJobRunInfo(long startTimeMs) {
        this(startTimeMs, null, GwtSchemaLoadStatus.LOADED);
    }

    public IcCubeSchedulerLoadSchemaJobRunInfo(long startTimeMs, @Nullable String requestUuid, GwtSchemaLoadStatus status) {
        this(startTimeMs, requestUuid, status, false);
    }

    public IcCubeSchedulerLoadSchemaJobRunInfo(long startTimeMs, @Nullable String requestUuid, GwtSchemaLoadStatus status, boolean deactivated) {
        super(startTimeMs, requestUuid);
        this.status = status;
        this.deactivated = deactivated;
    }

    public GwtSchemaLoadStatus getStatus() {
        return this.status;
    }

    @Override
    public void onBusinessLogicCompleted(IcCubeSchedulerJobRunnable runnable) {
        if (this.status == GwtSchemaLoadStatus.INCREMENTAL_LOAD_ERROR && !this.deactivated) {
            return;
        }
        IcCubeSchedulerJobDefinition jobDefinition = runnable.getJobDefinition();
        if (!(this.status != GwtSchemaLoadStatus.LOAD_ERROR && this.status != GwtSchemaLoadStatus.INCREMENTAL_LOAD_ERROR || jobDefinition.isContinueOnError())) {
            String message = "%s task completed on error [%s] : task details : %s".formatted(new Object[]{runnable.kind(), this.status.name(), jobDefinition.getInfoForLogging()});
            OlapLoggers.SCHEDULER.warn((Object)message);
            throw new IcCubeSchedulerJobRunnableException(runnable, message);
        }
        if (this.status == GwtSchemaLoadStatus.INCREMENTAL_LOAD_DEACTIVATED && !jobDefinition.isContinueOnIncrLoadDeActivated()) {
            String message = "%s task completed on error [%s] : task details : %s".formatted(new Object[]{runnable.kind(), this.status.name(), jobDefinition.getInfoForLogging()});
            OlapLoggers.SCHEDULER.warn((Object)message);
            throw new IcCubeSchedulerJobRunnableException(runnable, message);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " / " + String.valueOf((Object)this.status);
    }
}

