/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerLoadSchemaJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobLogicMode;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunInfo;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnableException;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerLoadSchemaJobRunInfo;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerJobRunnable
implements Runnable {
    public static final int MAX_HISTORICAL_RUN_COUNT = 32;
    private final IcCubeEngine engine;
    @Nullable
    private final OlapTenant tenant;
    private final IcCubeSchedulerJobBusinessLogic businessLogic;
    private final boolean runNOW;
    private final LinkedList<IcCubeSchedulerJobRunInfo> validRuns = new LinkedList();
    private volatile IcCubeSchedulerJobLogicMode mode;

    public IcCubeSchedulerJobRunnable(IcCubeEngine engine, @Nullable OlapTenant tenant, IcCubeSchedulerJobBusinessLogic businessLogic, boolean runNOW) {
        this.engine = engine;
        this.tenant = tenant;
        this.businessLogic = businessLogic;
        this.runNOW = runNOW;
        this.mode = IcCubeSchedulerJobLogicMode.IDLE;
    }

    public IcCubeSchedulerKind kind() {
        return this.businessLogic.kind();
    }

    @Nullable
    public OlapTenant getTenant() {
        return this.tenant;
    }

    public IcCubeSchedulerJobDefinition getJobDefinition() {
        return this.businessLogic.getJobDefinition();
    }

    public IcCubeSchedulerJobBusinessLogic getBusinessLogic() {
        return this.businessLogic;
    }

    public IcCubeSchedulerJobLogicMode getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.mode = IcCubeSchedulerJobLogicMode.PROCESSING;
        try {
            IcCubeSchedulerJobDefinition jobDefinition = this.getJobDefinition();
            try {
                OlapLoggers.SCHEDULER.info((Object)(this.kind().logName() + " running : " + jobDefinition.getInfoForLogging()));
                if (jobDefinition instanceof IcCubeSchedulerLoadSchemaJobDefinition) {
                    IcCubeSchedulerLoadSchemaJobDefinition load = (IcCubeSchedulerLoadSchemaJobDefinition)jobDefinition;
                    OlapLoggers.CHECKPOINTS.info((Object)"[ic3] %s running : %s".formatted(this.kind().logName(), jobDefinition.getInfoForLogging()));
                }
                IcCubeSchedulerJobRunInfo run = this.businessLogic.run(this.engine);
                LinkedList<IcCubeSchedulerJobRunInfo> linkedList = this.validRuns;
                synchronized (linkedList) {
                    this.validRuns.addFirst(run);
                    while (this.validRuns.size() > 32) {
                        this.validRuns.removeLast();
                    }
                }
                run.onBusinessLogicCompleted(this);
            }
            catch (RuntimeException unexpected) {
                if (unexpected instanceof IcCubeSchedulerJobRunnableException) {
                    String message = "%s task processing completed on error : task details : %s".formatted(this.kind().logName(), jobDefinition.getInfoForLogging());
                    OlapLoggers.SCHEDULER.warn((Object)message, (Throwable)unexpected);
                    throw unexpected;
                }
                String message = "%s task processing completed on unexpected error : task details : %s".formatted(this.kind().logName(), jobDefinition.getInfoForLogging());
                OlapLoggers.SCHEDULER.warn((Object)message, (Throwable)unexpected);
                throw new IcCubeSchedulerJobRunnableException(this, (Throwable)unexpected);
            }
        }
        finally {
            this.mode = IcCubeSchedulerJobLogicMode.IDLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLatestRequestUuid() {
        LinkedList<IcCubeSchedulerJobRunInfo> linkedList = this.validRuns;
        synchronized (linkedList) {
            if (this.validRuns.isEmpty()) {
                return null;
            }
            IcCubeSchedulerJobRunInfo run = this.validRuns.getFirst();
            return run.getRequestUuid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GwtSchemaLoadStatus getLatestLoadStatus() {
        LinkedList<IcCubeSchedulerJobRunInfo> linkedList = this.validRuns;
        synchronized (linkedList) {
            if (this.validRuns.isEmpty()) {
                return null;
            }
            IcCubeSchedulerJobRunInfo run = this.validRuns.getFirst();
            if (run instanceof IcCubeSchedulerLoadSchemaJobRunInfo) {
                IcCubeSchedulerLoadSchemaJobRunInfo runL = (IcCubeSchedulerLoadSchemaJobRunInfo)run;
                return runL.getStatus();
            }
            return null;
        }
    }

    public String toString() {
        return this.getJobDefinition().getInfoForLogging();
    }
}

