/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerLoadSchemaJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobBusinessLogicFactory;
import crazydev.iccube.server.scheduler.runtime.businesslogic.IcCubeSchedulerAlertJobBusinessLogic;
import crazydev.iccube.server.scheduler.runtime.businesslogic.IcCubeSchedulerLoadSchemaJobBusinessLogic;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeSchedulerJobBusinessLogics {
    private static final Map<Class<? extends IcCubeSchedulerJobDefinition>, IcCubeSchedulerJobBusinessLogicFactory> factories = new HashMap<Class<? extends IcCubeSchedulerJobDefinition>, IcCubeSchedulerJobBusinessLogicFactory>();

    static <T extends IcCubeSchedulerJobDefinition> void register(Class<T> clazz, IcCubeSchedulerJobBusinessLogicFactory<T> factory) {
        factories.put(clazz, factory);
    }

    public static IcCubeSchedulerJobBusinessLogic createBusinessLogic(IcCubeEngine engine, @Nullable OlapTenant tenant, IcCubeSchedulerJobDefinition jobDefinition) {
        if (jobDefinition instanceof IcCubeSchedulerJobBusinessLogic) {
            return (IcCubeSchedulerJobBusinessLogic)((Object)jobDefinition);
        }
        IcCubeSchedulerJobBusinessLogicFactory factory = factories.get(jobDefinition.getClass());
        if (factory == null) {
            throw new RuntimeException("internal error : missing scheduler factory for class [" + jobDefinition.getClass().getName() + "]");
        }
        IcCubeSchedulerJobBusinessLogic<IcCubeSchedulerJobDefinition> businessLogic = factory.create(engine, tenant, jobDefinition);
        return businessLogic;
    }

    static {
        IcCubeSchedulerJobBusinessLogics.register(IcCubeSchedulerAlertJobDefinition.class, IcCubeSchedulerAlertJobBusinessLogic::new);
        IcCubeSchedulerJobBusinessLogics.register(IcCubeSchedulerLoadSchemaJobDefinition.class, IcCubeSchedulerLoadSchemaJobBusinessLogic::new);
    }
}

