/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobLogicMode;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
public abstract class IcCubeSchedulerJob {
    protected final IcCubeSchedulerKind kind;
    @Nullable
    private volatile IcCubeSchedulerJob outOfBandJob;

    public IcCubeSchedulerJob(IcCubeSchedulerKind kind) {
        this.kind = kind;
    }

    public void waitForCompletion() {
    }

    public boolean isAttachedTo(IcCubeSchedulerJob outOfBand) {
        IcCubeSchedulerJobDefinition def = this.getDefinition();
        IcCubeSchedulerJobDefinition otherDef = outOfBand.getDefinition();
        return Objects.equals(def.getUuid(), otherDef.getUuid());
    }

    public void attachOutOfBandJob(IcCubeSchedulerJob outOfBand) {
        IcCubeSchedulerJob job = this.outOfBandJob;
        if (job != null) {
            try {
                OlapLoggers.SCHEDULER.info((Object)(this.kind.logName() + " out-of-band cancel for " + this.getScheduledInfoForLogging()));
                job.cancel();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        OlapLoggers.SCHEDULER.info((Object)(this.kind.logName() + " out-of-band attached for " + this.getScheduledInfoForLogging()));
        this.outOfBandJob = outOfBand;
    }

    public boolean isBoundTo(ScheduledFuture<?> future) {
        IcCubeSchedulerJob job = this.outOfBandJob;
        return job != null && job.isBoundTo(future);
    }

    public void onTaskDone(ScheduledFuture<?> future) {
        IcCubeSchedulerJob job = this.outOfBandJob;
        if (job != null) {
            OlapLoggers.SCHEDULER.info((Object)(this.kind.logName() + " out-of-band completed for " + this.getScheduledInfoForLogging()));
        }
        this.outOfBandJob = null;
    }

    public abstract void cancel();

    public abstract IcCubeSchedulerJobDefinition getDefinition();

    public abstract boolean isDone();

    public abstract boolean isEnabled();

    @Nullable
    public final IcCubeSchedulerJobLogicMode getOutOfBandMode() {
        IcCubeSchedulerJob job = this.outOfBandJob;
        if (job != null) {
            return job.getMode();
        }
        return null;
    }

    @Nullable
    public IcCubeSchedulerJobLogicMode getMode() {
        IcCubeSchedulerJob job = this.outOfBandJob;
        if (job != null) {
            return job.getMode();
        }
        return null;
    }

    public abstract IcCubeSchedulerTriggerDefinition getTrigger();

    public abstract String getScheduledInfoForLogging();

    public abstract boolean isForDefinition(String var1);

    public abstract boolean isForLoadSchema(File var1, File var2);

    public long getNextScheduledTimeMS() {
        return -1L;
    }

    @Nullable
    public abstract String getLatestRequestUuid();

    public abstract boolean isOnError();

    @Nullable
    public GwtSchemaLoadStatus getLatestLoadStatus() {
        return null;
    }

    public abstract List<OlapContextualError> getErrors();
}

