/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

class IcCubeSchedulerFileDefinitionHelper {
    private final IcCubeSchedulerKind kind;
    private final CdVFileSystem vfs;
    private final File tmpDirectory;
    private final File schedulerDirectory;

    IcCubeSchedulerFileDefinitionHelper(IcCubeSchedulerKind kind, CdVFileSystem vfs, File tmpDirectory, File schedulerDirectory) {
        this.kind = kind;
        this.vfs = vfs;
        this.tmpDirectory = tmpDirectory;
        this.schedulerDirectory = schedulerDirectory;
    }

    private static void setAllJobDefinitionsAsPersisted(IcCubeSchedulerDefinition definition) {
        List<IcCubeSchedulerJobDefinition> jobs = definition.getJobs();
        if (jobs != null) {
            for (IcCubeSchedulerJobDefinition job : jobs) {
                job.setPersisted(true);
            }
        }
    }

    @Nullable
    IcCubeSchedulerDefinition unmarshallDefinitionFromDirectory() throws IcCubeSchedulerDefinitionErrorException {
        File xmlFile = this.getXmlFile();
        OlapLoggers.SCHEDULER.info((Object)(this.kind.logName() + " definition file : " + xmlFile.getAbsolutePath()));
        if (!xmlFile.exists()) {
            OlapLoggers.SCHEDULER.warn((Object)(this.kind.logName() + " the definition file (" + xmlFile.getAbsolutePath() + ") does not exist."));
            return null;
        }
        if (!xmlFile.isFile()) {
            OlapLoggers.SCHEDULER.error((Object)(this.kind.logName() + " the definition file (" + xmlFile.getAbsolutePath() + ") is not a file."));
            throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.FILE_NOT_FILE, new Serializable[]{xmlFile.getAbsolutePath()});
        }
        try {
            IcCubeSchedulerDefinition definition = (IcCubeSchedulerDefinition)CdXmlUtils.unmarshall((String)"UTF-8", (File)xmlFile, (Class[])new Class[]{IcCubeSchedulerDefinition.class});
            definition.setXmlFile(xmlFile);
            IcCubeSchedulerFileDefinitionHelper.setAllJobDefinitionsAsPersisted(definition);
            return definition;
        }
        catch (JAXBException | IOException | RuntimeException ex) {
            OlapLoggers.SCHEDULER.error((Object)(this.kind.logName() + " definition file (" + xmlFile.getAbsolutePath() + ") error."), ex);
            throw new IcCubeSchedulerDefinitionErrorException(ex, IcCubeSchedulerDefinitionErrorCode.FILE_READ_ERROR, new Serializable[]{xmlFile.getAbsolutePath(), ex.getMessage()});
        }
    }

    void saveOrUpdateJobDefinition(String savedBy, IcCubeSchedulerJobDefinition<?> jobDefinition) throws IcCubeSchedulerDefinitionErrorException {
        IcCubeSchedulerDefinition definition = this.isXmlFileExists() ? this.unmarshallDefinitionFromDirectory() : new IcCubeSchedulerDefinition(-1);
        if (definition != null && definition.addOrReplaceJob(jobDefinition)) {
            String info = jobDefinition.getDescription();
            if (CdStringUtils.isNullOrBlank((String)info)) {
                info = jobDefinition.getUuid();
            }
            this.marshallAndSaveDefinition(savedBy, "add-or-update " + info, definition);
        }
    }

    void deleteJobDefinition(String savedBy, String uuid) throws IcCubeSchedulerDefinitionErrorException {
        String info;
        IcCubeSchedulerDefinition definition = this.isXmlFileExists() ? this.unmarshallDefinitionFromDirectory() : null;
        if (definition != null && (info = definition.deleteJob(uuid)) != null) {
            this.marshallAndSaveDefinition(savedBy, "delete " + info, definition);
        }
    }

    void importDefinition(InputStream xmlFile) throws IcCubeSchedulerDefinitionErrorException {
        try {
            File file = this.getXmlFile();
            this.vfs.saveFile(file, xmlFile);
        }
        catch (IOException ex) {
            OlapLoggers.SCHEDULER.error((Object)(this.kind.logName() + " import definition error"), (Throwable)ex);
            throw new IcCubeSchedulerDefinitionErrorException(ex, IcCubeSchedulerDefinitionErrorCode.FILE_IMPORT_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    private void marshallAndSaveDefinition(String savedBy, String operation, IcCubeSchedulerDefinition definition) {
        File xmlFile = this.getXmlFile();
        StringWriter writer = new StringWriter();
        try {
            CdXmlUtils.marshall((Writer)writer, (Object)definition, (Class[])new Class[]{IcCubeSchedulerDefinition.class});
        }
        catch (JAXBException ex) {
            OlapLoggers.SCHEDULER.error((Object)(this.kind.logName() + " marshall & save definition error"), (Throwable)ex);
            throw new IcCubeSchedulerDefinitionErrorException(ex, IcCubeSchedulerDefinitionErrorCode.FILE_SAVE_ERROR, new Serializable[]{xmlFile.getAbsolutePath(), CdXmlUtils.getJAXBMessage((JAXBException)ex)});
        }
        String definitionAsString = writer.getBuffer().toString();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(definitionAsString.getBytes("UTF-8"));
            CdVFileRevManagerKind fileKind = this.kind == IcCubeSchedulerKind.ALERTS ? CdVFileRevManagerKind.SCHEDULER_ALERT : CdVFileRevManagerKind.SCHEDULER_LOAD;
            CdVFileRevActionOperation action = new CdVFileRevActionOperation(savedBy, operation);
            this.vfs.saveOrUpdateWithRevision(new CdVFileRevHelperConf(fileKind, this.tmpDirectory, this.schedulerDirectory), xmlFile, (InputStream)in, (CdVFileRevAction)action);
            IcCubeSchedulerFileDefinitionHelper.setAllJobDefinitionsAsPersisted(definition);
        }
        catch (IOException ex) {
            try {
                OlapLoggers.SCHEDULER.error((Object)(this.kind.logName() + " marshall & save definition error"), (Throwable)ex);
                throw new IcCubeSchedulerDefinitionErrorException(ex, IcCubeSchedulerDefinitionErrorCode.FILE_SAVE_ERROR, new Serializable[]{xmlFile.getAbsolutePath(), ex.getMessage()});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private boolean isXmlFileExists() {
        File xmlFile = this.getXmlFile();
        return xmlFile.exists();
    }

    private File getXmlFile() {
        return new File(this.schedulerDirectory, this.kind.fullFileName());
    }
}

