/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunInfo;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnable;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnableException;
import org.jetbrains.annotations.Nullable;

public class IcCubeSchedulerAlertJobRunInfo
extends IcCubeSchedulerJobRunInfo {
    private final Kind kind;
    private final boolean alerted;
    @Nullable
    private final String error;
    private volatile boolean pdfOnError;

    private IcCubeSchedulerAlertJobRunInfo(long startTimeMs, String requestUuid, Kind kind, boolean alerted, @Nullable String error) {
        super(startTimeMs, requestUuid);
        this.kind = kind;
        this.alerted = alerted;
        this.error = error;
        this.pdfOnError = false;
    }

    public static IcCubeSchedulerAlertJobRunInfo success(long startTimeMs, String requiredUuid, boolean alerted) {
        return new IcCubeSchedulerAlertJobRunInfo(startTimeMs, requiredUuid, Kind.OK, alerted, null);
    }

    public static IcCubeSchedulerAlertJobRunInfo failure(long startTimeMs, String requiredUuid, String error) {
        return new IcCubeSchedulerAlertJobRunInfo(startTimeMs, requiredUuid, Kind.KO, false, error);
    }

    public boolean isOnError() {
        return Kind.OK != this.kind;
    }

    @Nullable
    public String getError() {
        return this.error;
    }

    public boolean isAlerted() {
        return this.alerted;
    }

    public void setPdfOnError() {
        this.pdfOnError = true;
    }

    private boolean isOnPdfError() {
        return this.pdfOnError;
    }

    @Override
    public void onBusinessLogicCompleted(IcCubeSchedulerJobRunnable runnable) {
        IcCubeSchedulerJobDefinition jobDefinition = runnable.getJobDefinition();
        if ((this.isOnError() || this.isOnPdfError()) && !jobDefinition.isContinueOnError()) {
            String message = "%s task completed on %s : task details : %s".formatted(new Object[]{runnable.kind(), this.isOnPdfError() ? "PDF error" : "error", jobDefinition.getInfoForLogging()});
            OlapLoggers.SCHEDULER.warn((Object)message);
            throw new IcCubeSchedulerJobRunnableException(runnable, message);
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static enum Kind {
        OK,
        KO;

    }
}

