/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.runtime;

import crazydev.common.collection.CdPair;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.executor.OlapScheduledThreadPoolExecutorService;
import crazydev.iccube.olap.executor.OlapScheduledTimeGenerator;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerContinuousTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerCronTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDailyHoursTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDailyTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerDisabledTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerFixedRateTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerOnDataChangedTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerOnceTriggerDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionError;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerGuts;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerInvalidJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobRunnable;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerOnDataChangedJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerValidJob;
import crazydev.iccube.server.scheduler.runtime.timegenerator.OlapContinuousExcludingPeriodScheduledTimeGenerator;
import crazydev.iccube.server.scheduler.runtime.timegenerator.OlapCronScheduledTimeGenerator;
import crazydev.iccube.server.scheduler.runtime.timegenerator.OlapDailyDaysOfMonthScheduledTimeGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class IcCubeScheduler {
    private final IcCubeSchedulerKind kind;
    private final IcCubeEngine engine;
    private final Map<String, IcCubeSchedulerGuts> sGuts = new ConcurrentHashMap<String, IcCubeSchedulerGuts>();

    public IcCubeScheduler(IcCubeSchedulerKind kind, IcCubeEngine engine) {
        this.kind = kind;
        this.engine = engine;
        if (engine != null) {
            OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)engine.getOlapEngineApplicationContext());
            this.sGuts.put("$IC3_NO_TENANT_KEY$", new IcCubeSchedulerGuts(this, engine, rContext.getDirectoriesResolved(), kind));
        } else {
            this.sGuts.put("$IC3_NO_TENANT_KEY$", new IcCubeSchedulerGuts(this, engine, null, kind));
        }
    }

    public IcCubeSchedulerKind getKind() {
        return this.kind;
    }

    private IcCubeSchedulerGuts getOrCreateGuts(OlapRuntimeContext context) {
        OlapTenant tenant = context.getTenant();
        if (tenant == null) {
            IcCubeSchedulerGuts guts = this.sGuts.get("$IC3_NO_TENANT_KEY$");
            if (guts == null) {
                throw new RuntimeException("internal error: scheduler not properly setup.");
            }
            return guts;
        }
        IcCubeSchedulerGuts guts = this.sGuts.computeIfAbsent(tenant.getName(), tenantName -> new IcCubeSchedulerGuts(this, this.engine, context.getDirectoriesResolved(), this.kind));
        return guts;
    }

    void reset() {
        IcCubeSchedulerGuts guts = this.sGuts.get("$IC3_NO_TENANT_KEY$");
        guts.reset();
    }

    public void applyDefinitionOnStartup(OlapRuntimeContext context) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        guts.applyDefinition(true);
    }

    void applyDefinition(IcCubeSchedulerDefinition definition) {
        IcCubeSchedulerGuts guts = this.sGuts.get("$IC3_NO_TENANT_KEY$");
        guts.applyDefinition(definition);
    }

    public void importAndScheduleDefinitionX(OlapRuntimeContext context, @Nullable Integer callerRevNumber, InputStream xmlFile) throws IcCubeSchedulerDefinitionErrorException {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        guts.importAndScheduleDefinition(callerRevNumber, xmlFile);
    }

    @Nullable
    public CdPair<Integer, IcCubeSchedulerJob> saveAndScheduleJobDefinition(OlapRuntimeContext context, String savedBy, int callerRevNumber, IcCubeSchedulerJobDefinition jobDefinition) throws IcCubeSchedulerDefinitionErrorException {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.saveAndScheduleJobDefinition(savedBy, callerRevNumber, jobDefinition);
    }

    @Nullable
    public String duplicateAndScheduleJobDefinition(OlapRuntimeContext context, String savedBy, int callerRevNumber, String uuid, String newName) throws IcCubeSchedulerDefinitionErrorException {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.duplicateAndScheduleJobDefinition(savedBy, callerRevNumber, uuid, newName);
    }

    @Nullable
    public CdPair<Integer, IcCubeSchedulerJob> enableAndScheduleJobDefinition(OlapRuntimeContext context, String savedBy, int callerRevNumber, String uuid) throws IcCubeSchedulerDefinitionErrorException, OlapContextualBigException {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.enableAndScheduleJobDefinition(savedBy, callerRevNumber, uuid);
    }

    @Nullable
    public CdPair<Integer, IcCubeSchedulerJob> disableAndScheduleJobDefinition(OlapRuntimeContext context, String savedBy, int callerRevNumber, String uuid) throws IcCubeSchedulerDefinitionErrorException, OlapContextualBigException {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.disableAndScheduleJobDefinition(savedBy, callerRevNumber, uuid);
    }

    public void deleteJobDefinition(OlapRuntimeContext context, String savedBy, @Nullable Integer callerRevNumber, String uuid) throws IcCubeSchedulerDefinitionErrorException {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        guts.deleteJobDefinition(savedBy, callerRevNumber, uuid);
    }

    @Nullable
    public IcCubeSchedulerJob runOutOfBand(OlapRuntimeContext context, String savedBy, @Nullable String uuid, @Nullable String name) throws IcCubeSchedulerDefinitionErrorException {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.runOutOfBand(savedBy, uuid, name);
    }

    void cancelAllJobs(OlapRuntimeContext context) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        guts.cancelAllJobs();
    }

    void cancelJob(IcCubeSchedulerJob scheduledJob) {
        IcCubeSchedulerGuts guts = this.sGuts.get("$IC3_NO_TENANT_KEY$");
        guts.cancelJob(scheduledJob);
    }

    public void shutdownNow() {
        OlapLoggers.SCHEDULER.info((Object)(this.kind.logName() + " shutdown requested"));
        for (IcCubeSchedulerGuts guts : this.sGuts.values()) {
            guts.shutdownNow();
        }
        OlapLoggers.SCHEDULER.info((Object)(this.kind.logName() + " bye"));
    }

    public int getCurrentRevNumber(OlapRuntimeContext context) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getCurrentRevNumber();
    }

    public int getActiveJobCount(OlapRuntimeContext context) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getActiveJobCount();
    }

    @Nullable
    public List<OlapContextualError> getApplyDefinitionErrors(OlapRuntimeContext context) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getApplyDefinitionErrors();
    }

    public List<IcCubeSchedulerJobDefinition> getScheduleJobDefinitions(OlapRuntimeContext context) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getScheduleJobDefinitions();
    }

    @Nullable
    public IcCubeSchedulerJobDefinition getScheduleJobDefinition(OlapRuntimeContext context, String uuid) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getScheduleJobDefinition(uuid);
    }

    @Nullable
    public IcCubeSchedulerJob getScheduledJob(OlapRuntimeContext context, IcCubeSchedulerJobDefinition definition) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getScheduledJob(definition);
    }

    @Nullable
    public IcCubeSchedulerJob getScheduledJob(OlapRuntimeContext context, String definitionUuid) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getScheduledJob(definitionUuid);
    }

    @Nullable
    public IcCubeSchedulerJob getActiveScheduledJobForLoadSchema(OlapRuntimeContext context, File factory) {
        IcCubeSchedulerGuts guts = this.getOrCreateGuts(context);
        return guts.getActiveScheduledJobForLoadSchema(factory);
    }

    static class DisabledTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerDisabledTriggerDefinition> {
        DisabledTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerDisabledTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            return new IcCubeSchedulerValidJob(scheduler.kind, job, null);
        }
    }

    static class DailyPeriodTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerDailyHoursTriggerDefinition> {
        DailyPeriodTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerDailyHoursTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            final boolean triggerStartup = trigger.isRunOnStartup();
            final int triggerStartTimeHour = trigger.getStartTimeHour();
            final int triggerEndTimeHour = trigger.getEndTimeHour();
            OlapScheduledTimeGenerator generator = new OlapScheduledTimeGenerator(){
                {
                    Objects.requireNonNull(this$0);
                }

                public boolean isTerminated() {
                    return false;
                }

                public long generateNextTimeMS(int runCount, boolean startup, long nowMS) {
                    boolean runOnStartup = triggerStartup;
                    Calendar calendar = GregorianCalendar.getInstance();
                    calendar.set(11, triggerStartTimeHour);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    long todayStartHourMS = calendar.getTimeInMillis();
                    calendar.set(11, triggerEndTimeHour);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    long todayEndHourMS = calendar.getTimeInMillis();
                    if (startup && runOnStartup) {
                        return nowMS;
                    }
                    if (nowMS <= todayStartHourMS) {
                        return todayStartHourMS;
                    }
                    if (nowMS <= todayEndHourMS) {
                        long nextHourMS = todayStartHourMS;
                        while (nextHourMS < todayEndHourMS) {
                            if (nowMS > (nextHourMS += TimeUnit.HOURS.toMillis(1L))) continue;
                            return nextHourMS;
                        }
                        return todayEndHourMS;
                    }
                    long tomorrowStartHourMS = todayStartHourMS + TimeUnit.DAYS.toMillis(1L);
                    return tomorrowStartHourMS;
                }
            };
            ScheduledFuture future = executorService.scheduleWithTimeGenerator((Runnable)job, generator);
            return new IcCubeSchedulerValidJob(scheduler.kind, job, future);
        }
    }

    static class ContinuousTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerContinuousTriggerDefinition> {
        ContinuousTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerContinuousTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            IcCubeSchedulerContinuousTriggerDefinition.Period excluding = trigger.getValidatedExcluding();
            if (excluding != null) {
                ScheduledFuture future = executorService.scheduleWithTimeGenerator((Runnable)job, (OlapScheduledTimeGenerator)new OlapContinuousExcludingPeriodScheduledTimeGenerator(trigger));
                return new IcCubeSchedulerValidJob(scheduler.kind, job, future);
            }
            long initialDelay = !onReActivation ? trigger.getTimeUnit().toMillis(trigger.getInitialDelay()) : 0L;
            TimeUnit unit = TimeUnit.MILLISECONDS;
            ScheduledFuture future = executorService.scheduleWithFixedDelay((Runnable)job, initialDelay, 1L, unit);
            return new IcCubeSchedulerValidJob(scheduler.kind, job, future);
        }
    }

    static class DailyTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerDailyTriggerDefinition> {
        DailyTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerDailyTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            List<Integer> daysOfMonth = trigger.getValidatedDaysOfMonth();
            ScheduledFuture future = executorService.scheduleWithTimeGenerator((Runnable)job, (OlapScheduledTimeGenerator)new OlapDailyDaysOfMonthScheduledTimeGenerator(trigger));
            return new IcCubeSchedulerValidJob(scheduler.kind, job, future);
        }
    }

    static class FixedRateTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerFixedRateTriggerDefinition> {
        FixedRateTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerFixedRateTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            long initialDelay = !onReActivation ? (long)trigger.getInitialDelay() : (long)trigger.getPeriod();
            long period = trigger.getPeriod();
            TimeUnit unit = trigger.getTimeUnit();
            ScheduledFuture future = executorService.scheduleAtFixedRate((Runnable)job, initialDelay, period, unit);
            return new IcCubeSchedulerValidJob(scheduler.kind, job, future);
        }
    }

    static class OnceTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerOnceTriggerDefinition> {
        OnceTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerOnceTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            long delay = trigger.getDelay();
            TimeUnit unit = trigger.getTimeUnit();
            ScheduledFuture future = executorService.schedule((Runnable)job, delay, unit);
            return new IcCubeSchedulerValidJob(scheduler.kind, job, future);
        }
    }

    static class CronTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerCronTriggerDefinition> {
        CronTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerCronTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            ScheduledFuture future = executorService.scheduleWithTimeGenerator((Runnable)job, (OlapScheduledTimeGenerator)new OlapCronScheduledTimeGenerator(trigger));
            return new IcCubeSchedulerValidJob(scheduler.kind, job, future);
        }
    }

    static class OnDataChangedTriggerScheduler
    extends TriggerScheduler<IcCubeSchedulerOnDataChangedTriggerDefinition> {
        OnDataChangedTriggerScheduler() {
        }

        @Override
        IcCubeSchedulerJob schedule(IcCubeScheduler scheduler, OlapScheduledThreadPoolExecutorService executorService, IcCubeSchedulerOnDataChangedTriggerDefinition trigger, IcCubeSchedulerJobRunnable job, boolean onReActivation) {
            IcCubeSchedulerJobDefinition definition = job.getJobDefinition();
            String schema = definition.getSchemaForOnDataChanged();
            if (schema == null) {
                OlapLoggers.SCHEDULER.error((Object)(scheduler.kind.logName() + " on-data-changed missing schema [" + definition.getDescription() + "] job: " + job.getJobDefinition().getInfoForLogging()));
                IcCubeSchedulerDefinitionError error = new IcCubeSchedulerDefinitionError(IcCubeSchedulerDefinitionErrorCode.ON_DATA_CHANGED_MISSING_SCHEMA, new Serializable[]{definition.getContextVisualId()});
                return new IcCubeSchedulerInvalidJob(scheduler.kind, definition, error);
            }
            return new IcCubeSchedulerOnDataChangedJob(scheduler.kind, scheduler.engine.getOlapEngineComponent(), executorService, trigger, job);
        }
    }

    static abstract class TriggerScheduler<T extends IcCubeSchedulerTriggerDefinition> {
        TriggerScheduler() {
        }

        abstract IcCubeSchedulerJob schedule(IcCubeScheduler var1, OlapScheduledThreadPoolExecutorService var2, T var3, IcCubeSchedulerJobRunnable var4, boolean var5);
    }
}

