/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.definition.trigger;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.trigger.IcCubeSchedulerTriggerDefinition;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorCode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerContinuousTriggerDefinitionValidator;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

@XmlRootElement(name="continuous")
public class IcCubeSchedulerContinuousTriggerDefinition
extends IcCubeSchedulerTriggerDefinition<IcCubeSchedulerContinuousTriggerDefinition> {
    public static final String XML_TAG = "continuous";
    public static final CdProperty INITIAL_DELAY = new CdReadWriteProperty(IcCubeSchedulerContinuousTriggerDefinition.class, "initialDelay", CdProperty.Access.FIELD);
    public static final CdProperty TIME_UNIT = new CdReadWriteProperty(IcCubeSchedulerContinuousTriggerDefinition.class, "timeUnit", CdProperty.Access.FIELD);
    public static final CdProperty EXCLUDING = new CdReadWriteProperty(IcCubeSchedulerContinuousTriggerDefinition.class, "excluding", CdProperty.Access.FIELD);
    @XmlElement(name="initialDelay", required=true)
    private int initialDelay;
    @XmlElement(name="timeUnit", required=true)
    private TimeUnit timeUnit;
    @XmlElement(name="excluding", required=false)
    private String excluding;

    public IcCubeSchedulerContinuousTriggerDefinition() {
    }

    public IcCubeSchedulerContinuousTriggerDefinition(int initialDelay, TimeUnit timeUnit) {
        this(initialDelay, timeUnit, null);
    }

    public IcCubeSchedulerContinuousTriggerDefinition(int initialDelay, TimeUnit timeUnit, @Nullable String excluding) {
        this.initialDelay = initialDelay;
        this.timeUnit = timeUnit;
        this.excluding = excluding;
    }

    @Override
    public IcCubeSchedulerTriggerDefinition duplicate() {
        return new IcCubeSchedulerContinuousTriggerDefinition(this.initialDelay, this.timeUnit, this.excluding);
    }

    @Override
    public boolean isUnbounded() {
        return true;
    }

    public IcCubeSchedulerContinuousTriggerDefinition setupForEmptyModel() {
        this.timeUnit = TimeUnit.DAYS;
        return this;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getExcluding() {
        return this.excluding;
    }

    @Nullable
    public Period getValidatedExcluding() {
        if (CdStringUtils.isNullOrBlank((String)this.excluding)) {
            return null;
        }
        Period period = Period.parse(this.excluding);
        return period;
    }

    @Override
    public String getInfoForLogging() {
        return "continuous [initial-delay:" + this.initialDelay + "][time-unit:" + String.valueOf((Object)this.timeUnit) + "]";
    }

    public OlapValidator<IcCubeSchedulerDefinitionValidationContext, IcCubeSchedulerJobDefinition, IcCubeSchedulerContinuousTriggerDefinition> getValidator() {
        return new IcCubeSchedulerContinuousTriggerDefinitionValidator();
    }

    public String getContextVisualId() {
        return XML_TAG;
    }

    public static class Period {
        public final LocalDateTime from;
        public final LocalDateTime to;

        public Period(LocalDateTime to, LocalDateTime from) {
            this.to = to;
            this.from = from;
        }

        @Nullable
        public static Period parse(String period) {
            LocalDateTime to;
            if (!(period = period.trim()).startsWith("[") || !period.endsWith("]")) {
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.EXCLUDING_PERIOD_INVALID, new Serializable[]{period, "not an interval - expecting [HH:mm,HH:mm]"});
            }
            String[] bounds = (period = period.substring(1, period.length() - 1)).split(",");
            if (bounds == null || bounds.length != 2) {
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.EXCLUDING_PERIOD_INVALID, new Serializable[]{period, "not an interval - expecting [HH:mm,HH:mm]"});
            }
            LocalDateTime from = Period.parseTime(period, bounds[0]);
            if (from.isAfter((ReadablePartial)(to = Period.parseTime(period, bounds[1])))) {
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.EXCLUDING_PERIOD_INVALID, new Serializable[]{period, "from is after to"});
            }
            return new Period(from, to);
        }

        private static LocalDateTime parseTime(String period, String time) {
            String[] parts = (time = time.trim()).split(":");
            if (parts == null || parts.length != 2) {
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.EXCLUDING_PERIOD_INVALID, new Serializable[]{period, "not a time - expecting HH:mm"});
            }
            try {
                String hours = parts[0];
                int hour = Integer.valueOf(hours);
                if (hour < 0 || hour > 23) {
                    throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.EXCLUDING_PERIOD_INVALID, new Serializable[]{period, "invalid hour - expecting a value between 0 and 23"});
                }
                String minutes = parts[1];
                int minute = Integer.valueOf(minutes);
                if (minute < 0 || minute > 59) {
                    throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.EXCLUDING_PERIOD_INVALID, new Serializable[]{period, "invalid minute - expecting a value between 0 and 59"});
                }
                return new LocalDateTime(1969, 7, 1, hour, minute);
            }
            catch (NumberFormatException ex) {
                throw new IcCubeSchedulerDefinitionErrorException(IcCubeSchedulerDefinitionErrorCode.EXCLUDING_PERIOD_INVALID, new Serializable[]{period, "invalid time - " + ex.getMessage()});
            }
        }
    }
}

