/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.definition;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerAlertJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerLoadSchemaJobDefinition;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jobs")
public class IcCubeSchedulerJobDefinitions {
    @XmlElementRefs(value={@XmlElementRef(type=IcCubeSchedulerAlertJobDefinition.class), @XmlElementRef(type=IcCubeSchedulerLoadSchemaJobDefinition.class)})
    private List<IcCubeSchedulerJobDefinition> jobs = new ArrayList<IcCubeSchedulerJobDefinition>();

    public List<IcCubeSchedulerJobDefinition> getJobs() {
        return this.jobs;
    }

    public void addJob(IcCubeSchedulerJobDefinition job) {
        this.jobs.add(job);
    }

    @Nullable
    public String deleteJob(String uuid) {
        if (this.jobs != null) {
            Iterator<IcCubeSchedulerJobDefinition> allJobs = this.jobs.iterator();
            while (allJobs.hasNext()) {
                IcCubeSchedulerJobDefinition job = allJobs.next();
                if (!job.getUuid().equals(uuid)) continue;
                allJobs.remove();
                String info = job.getDescription();
                if (CdStringUtils.isNullOrBlank((String)info)) {
                    info = uuid;
                }
                return info;
            }
        }
        return null;
    }

    public boolean addOrReplaceJob(IcCubeSchedulerJobDefinition job) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<IcCubeSchedulerJobDefinition>();
        }
        int pos = -1;
        for (int idx = 0; idx < this.jobs.size(); ++idx) {
            if (!job.getUuid().equals(this.jobs.get(idx).getUuid())) continue;
            pos = idx;
            break;
        }
        if (pos != -1) {
            this.jobs.set(pos, job);
        } else {
            this.jobs.add(job);
        }
        return true;
    }
}

