/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.scheduler.definition;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.repository.CdXmlBean;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinitions;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationContext;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidationEnabled;
import crazydev.iccube.server.scheduler.validation.IcCubeSchedulerDefinitionValidator;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="scheduler")
public class IcCubeSchedulerDefinition
implements IcCubeSchedulerDefinitionValidationEnabled<IcCubeSchedulerDefinitionValidationEnabled, IcCubeSchedulerDefinition>,
CdXmlBean {
    public static final String FILE_ENCODING = "UTF-8";
    public static final CdProperty JOBS = new CdReadWriteProperty(IcCubeSchedulerDefinition.class, "jobs", CdProperty.Access.FIELD);
    @XmlTransient
    @Nullable
    protected File xmlFile;
    @XmlAttribute(name="revisionNumber", required=true)
    private int revisionNumber = -1;
    @XmlElement(name="threadCount", required=true)
    private int threadCount = -1;
    @XmlElement(name="jobs", required=true)
    private IcCubeSchedulerJobDefinitions jobs = new IcCubeSchedulerJobDefinitions();

    public IcCubeSchedulerDefinition() {
    }

    public IcCubeSchedulerDefinition(int threadCount) {
        this.threadCount = threadCount;
    }

    @Nullable
    public File getXmlFile() {
        return this.xmlFile;
    }

    @XmlTransient
    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String getName() {
        return "icCube-scheduler";
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getActualThreadCount() {
        return this.threadCount == -1 ? CdSystemUtils.availableProcessors() : this.threadCount;
    }

    public List<IcCubeSchedulerJobDefinition> getJobs() {
        return this.jobs.getJobs();
    }

    public void addJob(IcCubeSchedulerJobDefinition job) {
        this.jobs.addJob(job);
    }

    public void addJobs(IcCubeSchedulerJobDefinition[] jobs) {
        for (IcCubeSchedulerJobDefinition job : jobs) {
            this.addJob(job);
        }
    }

    @Nullable
    public String deleteJob(String uuid) {
        if (this.jobs == null) {
            return null;
        }
        return this.jobs.deleteJob(uuid);
    }

    public boolean addOrReplaceJob(IcCubeSchedulerJobDefinition job) {
        return this.jobs != null && this.jobs.addOrReplaceJob(job);
    }

    public OlapValidator<IcCubeSchedulerDefinitionValidationContext, IcCubeSchedulerDefinitionValidationEnabled, IcCubeSchedulerDefinition> getValidator() {
        return new IcCubeSchedulerDefinitionValidator();
    }

    public String getContextVisualId() {
        return this.xmlFile == null ? "null" : this.xmlFile.getName();
    }
}

