/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.task;

import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestTracker;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import crazydev.iccube.request.task.IcCubeTask;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.request.common.IcCubeServerRequest;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeServerTask<REQUEST extends IcCubeServerRequest, REQUEST_CONTEXT extends IcCubeServerRequestContext>
extends IcCubeTask<REQUEST> {
    protected final REQUEST_CONTEXT requestContext;
    private final Object executeLOCK = new Object();
    private final AtomicBoolean executeStarted = new AtomicBoolean(false);
    private final AtomicBoolean executedDone = new AtomicBoolean(false);
    private final AtomicBoolean futureCancelled = new AtomicBoolean(false);

    protected IcCubeServerTask(REQUEST_CONTEXT requestContext, REQUEST request, String uid, @Nullable IcCubeSchemaAccessLock lock) {
        super(request, uid, lock);
        this.requestContext = requestContext;
    }

    public void markAsBusy() {
        if (this.requestContext != null) {
            IcCubeRequestStatusManager manager = ((IcCubeServerRequestContext)this.requestContext).getRequestStatusManager();
            manager.onRequestTaskBusy((IcCubeTask)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitAndWait(IcCubeServerTaskExecutor taskExecutor) {
        OlapEngineRequestContext olapEngineRequestContext = ((IcCubeServerRequestContext)this.requestContext).getOlapEngineRequestContext();
        OlapRequestId requestId = olapEngineRequestContext.getRequestId();
        OlapChattyRequest chattyRequest = ((IcCubeServerRequest)this.request).isChattyRequest();
        OlapRequestVerbosity verbosity = ((IcCubeServerRequest)this.request).getVerbosity();
        OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
        OlapRequestTracker.onSubmitTaskStarted((OlapRequestInfo)requestInfo, (IcCubeTask)this);
        try {
            Object reply = ((IcCubeServerRequestContext)this.requestContext).getRequestReply();
            if (!reply.hasErrors() && !((IcCubeServerRequestContext)this.requestContext).isCancelling()) {
                this.submitAndWaitForFutureCompletion(taskExecutor);
            }
            Object object = this.executeLOCK;
            synchronized (object) {
                if (this.executeStarted.get()) {
                    while (!this.executedDone.get()) {
                        try {
                            this.executeLOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!this.executeStarted.get() && this.canRunUnsafeExecute()) {
                    throw new RuntimeException("internal error: task inconsistency");
                }
            }
            IcCubeRequestStatusManager statusManager = ((IcCubeServerRequestContext)this.requestContext).getRequestStatusManager();
            statusManager.onRequestTaskDone((IcCubeTask)this);
        }
        finally {
            OlapRequestTracker.onSubmitTaskDone((OlapRequestInfo)requestInfo, (IcCubeTask)this);
        }
    }

    private void submitAndWaitForFutureCompletion(IcCubeServerTaskExecutor taskExecutor) {
        try {
            Future completion = taskExecutor.submit(this);
            completion.get();
        }
        catch (RejectedExecutionException rejected) {
            this.onRequestTaskException(new RuntimeException("icCube resource exhausted (retry later)", rejected));
        }
        catch (CancellationException cancelled) {
            Logger logger = ((IcCubeServerRequestContext)this.requestContext).getLogger();
            logger.error((Object)(((IcCubeServerRequestContext)this.requestContext).getLoggerInfo() + "(uuid:" + ((IcCubeServerRequestContext)this.requestContext).getRequestClientUUID() + ") : task cancelled"), (Throwable)cancelled);
        }
        catch (InterruptedException interrupted) {
            Logger logger = ((IcCubeServerRequestContext)this.requestContext).getLogger();
            logger.error((Object)(((IcCubeServerRequestContext)this.requestContext).getLoggerInfo() + " : task interrupted"), (Throwable)interrupted);
            String uuid = this.getRequestClientUUID();
            IcCubeRequestStatusManager requestStatusManager = ((IcCubeServerRequestContext)this.requestContext).getRequestStatusManager();
            requestStatusManager.cancelRequestOnInterruptedException(uuid);
        }
        catch (ExecutionException execution) {
            this.onRequestTaskException(execution);
        }
        catch (RuntimeException unexpected) {
            this.onRequestTaskException(unexpected);
        }
    }

    private boolean canRunUnsafeExecute() {
        Object reply = ((IcCubeServerRequestContext)this.requestContext).getRequestReply();
        return !reply.hasErrors() && !((IcCubeServerRequestContext)this.requestContext).isCancelling() && !this.futureCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        Object object = this.executeLOCK;
        synchronized (object) {
            block11: {
                OlapEngineRequestContext olapEngineRequestContext = ((IcCubeServerRequestContext)this.requestContext).getOlapEngineRequestContext();
                OlapRequestId requestId = olapEngineRequestContext.getRequestId();
                OlapChattyRequest chattyRequest = ((IcCubeServerRequest)this.request).isChattyRequest();
                OlapRequestVerbosity verbosity = ((IcCubeServerRequest)this.request).getVerbosity();
                OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
                try {
                    OlapRequestTracker.onExecuteTaskStart((OlapRequestInfo)requestInfo, (IcCubeTask)this);
                    this.executeStarted.set(true);
                    if (!this.canRunUnsafeExecute()) break block11;
                    IcCubeSchemaAccessLock lock = this.getLock();
                    olapEngineRequestContext.setSchemaAccessLock(lock);
                    try {
                        this.unsafeExecute();
                    }
                    finally {
                        olapEngineRequestContext.clearAccessReadWriteLock(lock);
                    }
                }
                catch (Exception ex) {
                    this.onRequestTaskException(ex);
                }
                finally {
                    this.executedDone.set(true);
                    this.executeLOCK.notifyAll();
                    OlapRequestTracker.onExecuteTaskDone((OlapRequestInfo)requestInfo, (IcCubeTask)this);
                }
            }
        }
    }

    protected abstract void unsafeExecute() throws Exception;

    public void onCancelFuture() {
        this.futureCancelled.set(true);
    }

    private void onRequestTaskException(Exception exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof OutOfMemoryError) {
            this.notifyOutOfMemory((OutOfMemoryError)cause);
        }
        IcCubeRequestStatusManager statusManager = ((IcCubeServerRequestContext)this.requestContext).getRequestStatusManager();
        Object reply = ((IcCubeServerRequestContext)this.requestContext).getRequestReply();
        reply.reportTaskException(statusManager, exception);
    }

    private void notifyOutOfMemory(OutOfMemoryError error) {
        OlapLoggers.SERVER.error((Object)"out-of-memory", (Throwable)error);
        OlapNotificationService notificationService = ((IcCubeServerRequestContext)this.requestContext).getNotificationService();
        notificationService.onInternalError("out-of-memory (review the configuration and restart the server)", (Throwable)error);
    }

    public IOlapContextLoggers getLoggers() {
        return ((IcCubeServerRequestContext)this.requestContext).getOlapEngineRequestContext().getLoggers();
    }
}

