/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.request.xmla;

import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.OlapBuilderUnloadEntityContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatusPhase;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingLock;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingToken;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.request.IcCubeRequestCategory;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.request.request.common.IcCubeServerRequest;
import crazydev.iccube.server.request.request.xmla.IcCubeXmlaServerRequestContext;
import crazydev.iccube.server.request.request.xmla.IcCubeXmlaServerRequestReply;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaQueryKind;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaLoadSchemaFromXmlStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaMdxStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaRestoreSchemaStatementCommandQuery;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import crazydev.xmla.server.iccube.server.message.XmlaQueryHandlerDispatcher;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaManagementApiQueryHandler;
import crazydev.xmla.server.iccube.server.message.common.XmlaMdxResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubeXmlaServerRequest
extends IcCubeServerRequest<IcCubeXmlaServerRequest, IcCubeXmlaServerRequestReply, IcCubeXmlaServerRequestContext> {
    private final HttpServletRequest httpRequest;
    private final HttpServletResponse httpResponse;
    private final XmlaQuery xmlaQuery;
    private boolean isFullLoadSchema;
    @Nullable
    private File schemaFactoryFile;
    @Nullable
    private OlapSchemaLoadingLock schemaLoadingLock;
    @Nullable
    private OlapSchemaLoadingToken schemaLoadingToken;
    private IcCubeSchemaAccessLockMode schemaAccessLockMode;

    public IcCubeXmlaServerRequest(OlapRequestId requestId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, XmlaQuery xmlaQuery) {
        super(requestId);
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.xmlaQuery = xmlaQuery;
    }

    @Nullable
    public String getMdxForCancelReport() {
        return this.xmlaQuery.getMdxForCancelReport();
    }

    @Nullable
    public String getSchema() {
        return this.xmlaQuery.getSchema();
    }

    @Override
    protected boolean isLoadPartitions() {
        return this.xmlaQuery.isLoadPartitions();
    }

    @Override
    protected boolean isLoadMeasureGroups() {
        return this.xmlaQuery.isLoadMeasureGroup();
    }

    @Override
    public boolean isSchemaLifeCycle() {
        return this.xmlaQuery.isSchemaLifeCycle();
    }

    @Override
    protected String getSchemaLifeCycleName() {
        return this.xmlaQuery.getSchemaLifeCycleName();
    }

    @Override
    @Nullable
    protected OlapSchemaLifeCycleStatus getSchemaLifeCycleStatus(IcCubeXmlaServerRequestContext requestContext) {
        IcCubeXmlaServerRequestReply reply = requestContext.getRequestReply();
        return reply.getSchemaLifeCycleStatus();
    }

    @Override
    @Nullable
    protected OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase(IcCubeXmlaServerRequestContext requestContext) {
        IcCubeXmlaServerRequestReply reply = requestContext.getRequestReply();
        return reply.getSchemaLifeCycleStatusPhase();
    }

    public boolean isUiMonitored() {
        return this.xmlaQuery.isMonitored();
    }

    public IcCubeRequestCategory getCategory() {
        return IcCubeRequestCategory.XMLA;
    }

    public IcCubeRequestKind getKind() {
        XmlaQueryKind kind = this.xmlaQuery.getKind();
        switch (kind) {
            case LOAD: {
                return IcCubeRequestKind.LOAD;
            }
            case MDX: {
                return IcCubeRequestKind.MDX;
            }
        }
        return IcCubeRequestKind.OTHER;
    }

    public String getInternalTypeName() {
        return this.xmlaQuery.getClass().getSimpleName();
    }

    public String getTrackingInfo() {
        return this.xmlaQuery.getTrackingInfo();
    }

    public String getUserFriendlyTypeName() {
        return this.xmlaQuery.getUserFriendlyTypeName();
    }

    public Logger getLogger() {
        return OlapLoggers.XMLA_REQUEST;
    }

    public String getLoggerInfo() {
        return "XMLA request [...]";
    }

    @Nullable
    public String getXmlaSessionId() {
        return this.xmlaQuery.getSessionId();
    }

    public XmlaQuery getXmlaQuery() {
        return this.xmlaQuery;
    }

    public boolean isExecutionModePrepare() {
        return this.xmlaQuery instanceof XmlaExecuteQuery && this.xmlaQuery.isExecutionModePrepare();
    }

    @Override
    protected boolean unsafeSetupTaskSchedulingInfo(IcCubeXmlaServerRequestContext requestContext) throws Exception {
        if (OlapLoggers.XMLA_REQUEST.isDebugEnabled()) {
            OlapLoggers.XMLA_REQUEST.debug((Object)("[XMLA] request [" + this.xmlaQuery.getClass().getSimpleName() + "] [session-id:" + this.xmlaQuery.getSessionId() + "]"));
        }
        if (this.xmlaQuery.isMdxStatement()) {
            XmlaMdxStatementCommandQuery executeMdxQuery = (XmlaMdxStatementCommandQuery)this.xmlaQuery;
            return this.unsafeSetupTaskSchedulingInfoForMdx(requestContext, executeMdxQuery);
        }
        if (this.xmlaQuery.isLoadSchema()) {
            IOlapBuilderSchemaDefFactory factory;
            if (this.isExecutionModePrepare()) {
                return true;
            }
            OlapEngineRequestContext engineRequestContext = requestContext.getOlapEngineRequestContext();
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            try {
                if (OlapLoggers.XMLA_REQUEST.isInfoEnabled()) {
                    OlapLoggers.XMLA_REQUEST.info((Object)("[XMLA] acquiring load-token for schema [" + this.xmlaQuery.getSchema() + "]"));
                }
                OlapRequestId requestId = engineRequestContext.getRequestId();
                OlapChattyRequest chattyRequest = null;
                OlapRequestVerbosity verbosity = null;
                OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
                this.schemaLoadingToken = olapEngine.getSchemaLoadToken(engineRequestContext, requestInfo, this.xmlaQuery.getSchema());
                if (OlapLoggers.XMLA_REQUEST.isInfoEnabled()) {
                    OlapLoggers.XMLA_REQUEST.info((Object)("[XMLA] acquired load-token for schema [" + this.xmlaQuery.getSchema() + "]"));
                }
            }
            catch (InterruptedException ex) {
                String schema = this.xmlaQuery.getSchema();
                XmlaExecuteQuery xmlaExecuteQuery = (XmlaExecuteQuery)this.xmlaQuery;
                OlapLoggers.XMLA_REQUEST.warn((Object)("[XMLA] load schema [" + schema + "] cancelled while waiting for a token"));
                OlapSchemaLifeCycleStatus xmlaStatus = new OlapSchemaLifeCycleStatus(schema, OlapSchemaLoadStatus.WAITING_LOADING_CANCELLED);
                XmlaMdxResponse response = XmlaManagementApiQueryHandler.createSchemaLifeCycleXmlaResponse((XmlaQueryContext)requestContext.getXmlaQueryContext(), (XmlaExecuteQuery)xmlaExecuteQuery, (OlapSchemaLifeCycleStatus)xmlaStatus, null);
                IcCubeXmlaServerRequestReply reply = requestContext.getRequestReply();
                reply.reportResponse((XmlaResponse)response);
                return false;
            }
            String schemaDefinition = this.xmlaQuery.getSchemaDefinition();
            if (schemaDefinition == null) {
                String querySchemaFactoryFileName = this.xmlaQuery.getSchemaFactoryFileName();
                if (querySchemaFactoryFileName == null) {
                    if (this.xmlaQuery instanceof XmlaRestoreSchemaStatementCommandQuery) {
                        XmlaRestoreSchemaStatementCommandQuery restoreQuery = (XmlaRestoreSchemaStatementCommandQuery)this.xmlaQuery;
                        this.schemaFactoryFile = engineRequestContext.getOrCreateSchemaFactoryForRestore(restoreQuery.getSchema(), restoreQuery.getTimestamp());
                    } else if (this.schemaFactoryFile == null) {
                        this.schemaFactoryFile = engineRequestContext.getOrCreateSchemaFactoryForLoad(this.xmlaQuery.getSchema());
                    }
                } else {
                    runtimeContext = requestContext.asRuntimeContext();
                    OlapDirectoriesResolved directories = runtimeContext.getDirectoriesResolved();
                    this.schemaFactoryFile = new File(directories.getCubesDirectory(), querySchemaFactoryFileName);
                }
                if (this.schemaFactoryFile == null) {
                    throw new RuntimeException("unknown schema (missing schema XML definition file)");
                }
                IcCubeRequestStatusManager statusManager = requestContext.getRequestStatusManager();
                statusManager.onRequestAttachedToSchemaDefFactory(this.getClientUUID(), this.schemaFactoryFile);
                XmlaQueryContext xmlaQueryContext = requestContext.getXmlaQueryContext();
                xmlaQueryContext.setSchemaFactoryFile(this.schemaFactoryFile);
                factory = engineRequestContext.getOrCreateSchemaFactoryForLoad(this.schemaFactoryFile);
            } else {
                String schemaName = this.xmlaQuery.getSchema();
                runtimeContext = requestContext.asRuntimeContext();
                OlapDirectoriesResolved directories = runtimeContext.getDirectoriesResolved();
                File cubes = directories.getCubesDirectory();
                String writeTo = null;
                if (this.xmlaQuery instanceof XmlaLoadSchemaFromXmlStatementCommandQuery) {
                    writeTo = ((XmlaLoadSchemaFromXmlStatementCommandQuery)this.xmlaQuery).getWriteTo();
                }
                this.schemaFactoryFile = CdStringUtils.isNotNullAndNotBlank(writeTo) ? new File(cubes, writeTo + ".icc-schema") : new File(cubes, schemaName + " (from XML definition)");
                IcCubeRequestStatusManager statusManager = requestContext.getRequestStatusManager();
                statusManager.onRequestAttachedToSchemaDefFactory(this.getClientUUID(), this.schemaFactoryFile);
                XmlaQueryContext xmlaQueryContext = requestContext.getXmlaQueryContext();
                xmlaQueryContext.setSchemaFactoryFile(this.schemaFactoryFile);
                factory = this.unsafeSetupSchemaFactoryFromDefinition(requestContext, this.schemaFactoryFile, schemaName, schemaDefinition);
                if (CdStringUtils.isNotNullAndNotBlank((String)writeTo)) {
                    this.unsafeSaveSchemaFactoryFromDefinition(requestContext, this.schemaFactoryFile, schemaName, schemaDefinition);
                }
                engineRequestContext.setSchemaFactoryForLoad(factory);
            }
            boolean isDuplicatedLoadSchema = this.isDuplicatedLoadSchema(requestContext, factory);
            if (!isDuplicatedLoadSchema) {
                this.isFullLoadSchema = this.isFullLoadSchema(requestContext, factory);
            }
            return !isDuplicatedLoadSchema;
        }
        if (this.isExecutionModePrepare()) {
            return true;
        }
        this.schemaAccessLockMode = this.xmlaQuery.isSchemaWrite() ? IcCubeSchemaAccessLockMode.WRITE : IcCubeSchemaAccessLockMode.READ;
        return true;
    }

    private void unsafeSaveSchemaFactoryFromDefinition(IcCubeXmlaServerRequestContext requestContext, File fakeFactoryFile, String schemaName, String schemaDefinition) {
        try {
            FileOutputStream file = new FileOutputStream(fakeFactoryFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)file, "UTF-8"));
            writer.write(schemaDefinition);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("could not save schema definition [" + schemaName + "] into [" + fakeFactoryFile.getAbsolutePath() + "]"), (Throwable)ex);
            throw new OlapBuilderErrorException((Throwable)ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage(), "none"});
        }
    }

    private IOlapBuilderSchemaDefFactory unsafeSetupSchemaFactoryFromDefinition(IcCubeXmlaServerRequestContext requestContext, File fakeFactoryFile, String schemaName, String schemaDefinition) {
        try {
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            OlapBuilderMetaInformationRepository builderMetaInformationRepository = olapEngine.getBuilderMetaInformationRepository();
            Class[] classes = builderMetaInformationRepository.getPersistentClasses();
            StringReader input = new StringReader(schemaDefinition);
            IOlapBuilderSchemaDefFactory factory = (IOlapBuilderSchemaDefFactory)CdXmlUtils.unmarshall((File)fakeFactoryFile, (Reader)input, (Class[])classes);
            if (!factory.getSchemaName().equals(schemaName)) {
                OlapLoggers.BUILDER.error((Object)("invalid schema name [" + schemaName + "] [factory-schema-name:" + factory.getSchemaName() + "]"));
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.SCHEMA_NAME_INVALID, new Serializable[]{schemaName + " [factory-schema-name:" + factory.getSchemaName() + "]"});
            }
            factory.setXmlFile(fakeFactoryFile);
            factory.setXmlDefinition(schemaDefinition);
            return factory;
        }
        catch (JAXBException ex) {
            String error = "invalid schema factory definition [" + schemaName + "]";
            OlapLoggers.BUILDER.error((Object)error, (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{error});
        }
    }

    private boolean unsafeSetupTaskSchedulingInfoForMdx(IcCubeXmlaServerRequestContext requestContext, XmlaMdxStatementCommandQuery executeMdxQuery) {
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        List olapProperties = XmlaServerProxy.createIcCubeProperties((List)executeMdxQuery.getProperties());
        OlapEngineMdxHelper mdxHelper = OlapEngineMdxHelper.create((OlapEngineRequestContext)olapEngineRequestContext, null, (List)olapProperties);
        String schema = executeMdxQuery.getSchema();
        String mdx = executeMdxQuery.getStatement();
        String mdxHash = UUID.randomUUID().toString();
        Object compilationInfo = mdx.toLowerCase().startsWith("//script") ? mdxHelper.compileMdxScript(schema, "xmla", mdx, mdxHash) : mdxHelper.compileMdxStatement(schema, mdx, mdxHash);
        requestContext.setMdxCompilationInfo((ICompilationInfo)compilationInfo);
        IExecuteStatementInstr statementInstr = compilationInfo.getInstr();
        this.schemaAccessLockMode = statementInstr != null ? statementInstr.getSchemaAccessLockMode() : IcCubeSchemaAccessLockMode.NONE;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicatedLoadSchema(IcCubeXmlaServerRequestContext requestContext, IOlapBuilderSchemaDefFactory factory) {
        XmlaExecuteQuery xmlaExecuteQuery = (XmlaExecuteQuery)this.xmlaQuery;
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        String schema = this.xmlaQuery.getSchema();
        String snapshot = this.xmlaQuery.getOfflineSnapshot();
        OlapSchemaInformation schemaInformation = new OlapSchemaInformation(this.getClientUUID(), factory.getSchemaGroup(), schema, this.schemaFactoryFile, factory, factory.incrementalLoadActive(), snapshot);
        if (OlapLoggers.XMLA_REQUEST.isInfoEnabled()) {
            OlapLoggers.XMLA_REQUEST.info((Object)("XMLA request : checking duplicated-loading for schema [" + schema + "]"));
        }
        try {
            block9: {
                do {
                    this.schemaLoadingLock = olapEngine.onSchemaLoadingStarted(olapEngineRequestContext, schemaInformation);
                    if (this.schemaLoadingLock.getStatus() == 0) break block9;
                    requestContext.getOlapEngineRequestContext().onProgressEvent("waitingOnDuplicatedLoading", new Serializable[0]);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!requestContext.isCancelling());
                OlapLoggers.XMLA_REQUEST.warn((Object)("XMLA request : schema [" + schema + "] cancelled while waiting because of duplicated loading"));
                OlapSchemaLifeCycleStatus xmlaStatus = new OlapSchemaLifeCycleStatus(schema, OlapSchemaLoadStatus.DUPLICATED_LOADING_CANCELLED);
                XmlaMdxResponse response = XmlaManagementApiQueryHandler.createSchemaLifeCycleXmlaResponse((XmlaQueryContext)requestContext.getXmlaQueryContext(), (XmlaExecuteQuery)xmlaExecuteQuery, (OlapSchemaLifeCycleStatus)xmlaStatus, null);
                IcCubeXmlaServerRequestReply reply = requestContext.getRequestReply();
                reply.reportResponse((XmlaResponse)response);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (OlapLoggers.XMLA_REQUEST.isInfoEnabled()) {
                OlapLoggers.XMLA_REQUEST.info((Object)("XMLA request : duplicated-loading check for schema [" + schema + "] done"));
            }
        }
    }

    private boolean isFullLoadSchema(IcCubeXmlaServerRequestContext requestContext, IOlapBuilderSchemaDefFactory schemaFactory) {
        if (this.xmlaQuery.isFullLoadSchema()) {
            return true;
        }
        if (this.xmlaQuery.isLoadSchemaWithOffline()) {
            return true;
        }
        if (this.xmlaQuery.isLoadPartitions() || this.xmlaQuery.isLoadMeasureGroup()) {
            return false;
        }
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        String schema = this.xmlaQuery.getSchema();
        OlapEngineRequestContext elevated = olapEngineRequestContext.elevateForBuilder();
        OlapRoleApplicationPermissions applicationPermissions = elevated.getApplicationPermissions();
        IOlapSchemasPermission schemasPermissions = elevated.getSchemasPermissions();
        OlapRuntimeContext rContext = requestContext.asRuntimeContext();
        boolean hasSchema = olapEngine.hasAuthorizedSchema(rContext, applicationPermissions, schemasPermissions, schema);
        boolean fullLoad = !hasSchema || !schemaFactory.incrementalLoadActive();
        return fullLoad;
    }

    @Override
    protected void setupTasks(List<IcCubeServerTask> tasks, IcCubeXmlaServerRequestContext requestContext) {
        if (this.xmlaQuery.isMdxStatement()) {
            tasks.add(new SingleTask(requestContext, this));
        } else if (this.xmlaQuery.isUnloadPartitions()) {
            if (this.isExecutionModePrepare()) {
                tasks.add(new PrepareTask(requestContext, this));
            } else {
                tasks.add(new UnloadPartitionsReadTask(requestContext, this));
                tasks.add(new UnloadPartitionsWriteTask(requestContext, this));
            }
        } else if (this.xmlaQuery.isLoadPartitions()) {
            if (this.isExecutionModePrepare()) {
                tasks.add(new PrepareTask(requestContext, this));
            } else {
                tasks.add(new LoadPartitionsReadTask(requestContext, this));
                tasks.add(new LoadPartitionsWriteTask(requestContext, this));
            }
        } else if (this.xmlaQuery.isLoadMeasureGroup()) {
            if (this.isExecutionModePrepare()) {
                tasks.add(new PrepareTask(requestContext, this));
            } else {
                tasks.add(new LoadMeasureGroupsReadTask(requestContext, this));
                tasks.add(new LoadMeasureGroupsWriteTask(requestContext, this));
            }
        } else if (this.xmlaQuery.isLoadSchema()) {
            if (this.isExecutionModePrepare()) {
                tasks.add(new PrepareTask(requestContext, this));
            } else {
                if (this.isFullLoadSchema) {
                    tasks.add(new FullLoadReadTask(requestContext, this));
                } else {
                    tasks.add(new IncrLoadReadTask(requestContext, this));
                }
                tasks.add(new LoadWriteTask(requestContext, this));
            }
        } else if (this.xmlaQuery.isUnloadSchema()) {
            if (this.isExecutionModePrepare()) {
                tasks.add(new PrepareTask(requestContext, this));
            } else {
                tasks.add(new UnloadReadTask(requestContext, this));
                tasks.add(new UnloadWriteTask(requestContext, this));
            }
        } else if (this.xmlaQuery.isApplyPermissions()) {
            if (this.isExecutionModePrepare()) {
                tasks.add(new PrepareTask(requestContext, this));
            } else {
                tasks.add(new ApplyPermissionsTask(requestContext, this));
            }
        } else if (this.isExecutionModePrepare()) {
            tasks.add(new PrepareTask(requestContext, this));
        } else {
            tasks.add(new SingleTask(requestContext, this));
        }
    }

    @Override
    public void onFinallyForSchemaLifeCycleRequest(IcCubeXmlaServerRequestContext requestContext) {
        super.onFinallyForSchemaLifeCycleRequest(requestContext);
        boolean isLoadSchema = this.xmlaQuery.isLoadSchema();
        if (isLoadSchema && this.schemaLoadingToken != null) {
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
            OlapRequestId requestId = olapEngineRequestContext.getRequestId();
            OlapChattyRequest chattyRequest = null;
            OlapRequestVerbosity verbosity = null;
            OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
            olapEngine.releaseSchemaLoadToken(olapEngineRequestContext, requestInfo, this.schemaLoadingToken);
        }
        if (isLoadSchema && this.schemaLoadingLock != null) {
            this.onFinallyForSchemaLoaded(requestContext, this.schemaLoadingLock);
        }
    }

    static class SingleTask
    extends Task {
        protected SingleTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)request.schemaAccessLockMode));
        }
    }

    static class PrepareTask
    extends Task {
        protected PrepareTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-PREPARE", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.NONE));
        }

        @Override
        public void unsafeExecute() throws Exception {
            super.unsafeExecute();
        }
    }

    static class UnloadPartitionsReadTask
    extends Task {
        protected UnloadPartitionsReadTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-UNLOAD-PARTITIONS-PHASE-I", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.READ));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            OlapBuilderUnloadEntityContext eContext = olapEngineRequestContext.getOrCreateUnloadEntityContext(OlapBuilderContextMode.UNLOAD_PARTITIONS);
            eContext.setCurrentTask(1);
            super.unsafeExecute();
        }
    }

    static class UnloadPartitionsWriteTask
    extends Task {
        protected UnloadPartitionsWriteTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-UNLOAD-PARTITIONS-PHASE-II", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.II;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            OlapBuilderUnloadEntityContext eContext = olapEngineRequestContext.getOrCreateUnloadEntityContext(OlapBuilderContextMode.UNLOAD_PARTITIONS);
            eContext.setCurrentTask(2);
            super.unsafeExecute();
        }
    }

    static class LoadPartitionsReadTask
    extends Task {
        protected LoadPartitionsReadTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-PARTITIONS-PHASE-I", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.READ));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            OlapBuilderLoadEntityContext eContext = olapEngineRequestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_PARTITIONS);
            eContext.setCurrentTask(1);
            super.unsafeExecute();
        }
    }

    static class LoadPartitionsWriteTask
    extends Task {
        protected LoadPartitionsWriteTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-PARTITIONS-PHASE-II", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.II;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            OlapBuilderLoadEntityContext eContext = olapEngineRequestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_PARTITIONS);
            eContext.setCurrentTask(2);
            super.unsafeExecute();
        }
    }

    static class LoadMeasureGroupsReadTask
    extends Task {
        protected LoadMeasureGroupsReadTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-MEASURE-GROUPS-PHASE-I", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.READ));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            OlapBuilderLoadEntityContext eContext = olapEngineRequestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_MEASURE_GROUPS);
            eContext.setCurrentTask(1);
            super.unsafeExecute();
        }
    }

    static class LoadMeasureGroupsWriteTask
    extends Task {
        protected LoadMeasureGroupsWriteTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-MEASURE-GROUPS-PHASE-II", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.II;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            OlapBuilderLoadEntityContext eContext = olapEngineRequestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_MEASURE_GROUPS);
            eContext.setCurrentTask(2);
            super.unsafeExecute();
        }
    }

    static class FullLoadReadTask
    extends Task {
        protected FullLoadReadTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-SCHEMA-PHASE-I (full)", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.NONE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(0);
            super.unsafeExecute();
        }
    }

    static class IncrLoadReadTask
    extends Task {
        protected IncrLoadReadTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-SCHEMA-PHASE-I (incr.)", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.READ));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(0);
            super.unsafeExecute();
        }
    }

    static class LoadWriteTask
    extends Task {
        protected LoadWriteTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-SCHEMA-PHASE-II", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.II;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(1);
            super.unsafeExecute();
        }
    }

    static class UnloadReadTask
    extends Task {
        protected UnloadReadTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-UNLOAD-SCHEMA-PHASE-I", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.NONE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(0);
            super.unsafeExecute();
        }
    }

    static class UnloadWriteTask
    extends Task {
        protected UnloadWriteTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-UNLOAD-SCHEMA-PHASE-II", IcCubeSchemaAccessLock.create((String)request.xmlaQuery.getSchema(), (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.II;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeXmlaServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(1);
            super.unsafeExecute();
        }
    }

    static class ApplyPermissionsTask
    extends Task {
        protected ApplyPermissionsTask(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
            super(requestContext, request, "XMLA-PERMS", IcCubeSchemaAccessLock.create((boolean)true, null, (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }
    }

    static abstract class Task
    extends IcCubeServerTask<IcCubeXmlaServerRequest, IcCubeXmlaServerRequestContext> {
        protected Task(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request, String uid, @Nullable IcCubeSchemaAccessLock lock) {
            super(requestContext, request, uid, lock);
        }

        @Override
        public void unsafeExecute() throws Exception {
            XmlaResponse response = XmlaQueryHandlerDispatcher.handle((XmlaQueryContext)((IcCubeXmlaServerRequestContext)this.requestContext).getXmlaQueryContext(), (XmlaQuery)((IcCubeXmlaServerRequest)this.request).xmlaQuery);
            IcCubeXmlaServerRequestReply reply = ((IcCubeXmlaServerRequestContext)this.requestContext).getRequestReply();
            reply.reportResponse(this, response);
        }
    }
}

