/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.request.gwt;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQueryKind;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.server.requesthandler.common.GwtAbstractOlapEngineQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.common.GwtQueryHandlerDispatcher;
import crazydev.iccube.gwt.server.requesthandler.monitoring.schemas.GwtLoadBigBrotherSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.common.command.GwtAbstractMdxQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtLoadOfflineSchemaQuery;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLifeCycleReply;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatusPhase;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingLock;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingToken;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.request.IcCubeRequestCategory;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.request.request.common.IcCubeServerRequest;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestReply;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubeGwtServerRequest
extends IcCubeServerRequest<IcCubeGwtServerRequest, IcCubeGwtServerRequestReply, IcCubeGwtServerRequestContext> {
    private final GwtQuery gwtQuery;
    private boolean allSchema;
    @Nullable
    private String schema;
    private boolean isLoadSchema;
    private boolean isFullLoadSchema;
    @Nullable
    private OlapSchemaLoadingLock schemaLoadingLock;
    @Nullable
    private OlapSchemaLoadingToken schemaLoadingToken;
    private IcCubeSchemaAccessLockMode schemaAccessLockMode;

    public IcCubeGwtServerRequest(OlapRequestId requestId, GwtQuery gwtQuery) {
        super(requestId);
        this.gwtQuery = gwtQuery;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    @Nullable
    public String getMdxForCancelReport() {
        return this.gwtQuery.getMdxForCancelReport();
    }

    @Nullable
    private String onRequestSchemaResolved(IcCubeRequestStatusManager manager, @Nullable String schema) {
        manager.onRequestSchemaResolved(this.getClientUUID(), schema);
        return schema;
    }

    @Override
    public boolean isSchemaLifeCycle() {
        return this.gwtQuery.isSchemaLifeCycle();
    }

    @Override
    protected String getSchemaLifeCycleName() {
        if (this.schema != null) {
            return this.schema;
        }
        return this.gwtQuery.getSchemaLifeCycleName();
    }

    @Override
    @Nullable
    protected OlapSchemaLifeCycleStatus getSchemaLifeCycleStatus(IcCubeGwtServerRequestContext requestContext) {
        IcCubeGwtServerRequestReply reply = requestContext.getRequestReply();
        return reply.getSchemaLifeCycleStatus();
    }

    @Override
    protected OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase(IcCubeGwtServerRequestContext requestContext) {
        IcCubeGwtServerRequestReply reply = requestContext.getRequestReply();
        return reply.getSchemaLifeCycleStatusPhase();
    }

    public boolean isUiMonitored() {
        return this.gwtQuery.isMonitored();
    }

    public boolean isLoadMonitoring() {
        return this.gwtQuery.isLoadMonitoring();
    }

    @Nullable
    public OlapChattyRequest isChattyRequest() {
        return IcCubeGwtServerRequest.isChattyRequest(this.gwtQuery);
    }

    @Nullable
    public static OlapChattyRequest isChattyRequest(GwtQuery query) {
        if (query.isLoadMonitoring()) {
            return OlapChattyRequest.loadMonitoringSchema;
        }
        return null;
    }

    @Nullable
    public OlapRequestVerbosity getVerbosity() {
        return IcCubeGwtServerRequest.getVerbosity(this.gwtQuery);
    }

    @Nullable
    public static OlapRequestVerbosity getVerbosity(GwtQuery query) {
        return null;
    }

    public IcCubeRequestCategory getCategory() {
        return IcCubeRequestCategory.GWT;
    }

    public IcCubeRequestKind getKind() {
        GwtQueryKind kind = this.gwtQuery.getKind();
        switch (kind) {
            case LOAD: {
                return IcCubeRequestKind.LOAD;
            }
            case MDX: {
                return IcCubeRequestKind.MDX;
            }
        }
        return IcCubeRequestKind.OTHER;
    }

    public String getInternalTypeName() {
        return this.gwtQuery.getClass().getSimpleName();
    }

    public String getTrackingInfo() {
        String className = this.gwtQuery.getClass().getSimpleName();
        return this.gwtQuery.getTrackingInfo(className);
    }

    public String getUserFriendlyTypeName() {
        return this.gwtQuery.getUserFriendlyTypeName();
    }

    public Logger getLogger() {
        return OlapLoggers.GWT_REQUEST;
    }

    public String getLoggerInfo() {
        return "GWT request [" + this.gwtQuery.getClass().getSimpleName() + "]";
    }

    public GwtQuery getGwtQuery() {
        return this.gwtQuery;
    }

    @Override
    protected boolean unsafeSetupTaskSchedulingInfo(IcCubeGwtServerRequestContext requestContext) throws Exception {
        String schemaFactoryFile = this.gwtQuery.getSchemaFactoryFile();
        if (schemaFactoryFile != null) {
            boolean isDuplicatedLoadSchema;
            IOlapBuilderSchemaDefFactory factory;
            File factoryFile = new File(schemaFactoryFile);
            IcCubeRequestStatusManager statusManager = requestContext.getRequestStatusManager();
            statusManager.onRequestAttachedToSchemaDefFactory(this.getClientUUID(), factoryFile);
            OlapEngineRequestContext engineRequestContext = requestContext.getOlapEngineRequestContext();
            if (this.gwtQuery instanceof GwtLoadBigBrotherSchemaQuery) {
                factory = ((GwtLoadBigBrotherSchemaQuery)this.gwtQuery).getBigBrotherSchemaFactory();
                engineRequestContext.setSchemaFactoryForLoad(factory);
            } else {
                factory = engineRequestContext.getOrCreateSchemaFactoryForLoad(factoryFile);
            }
            this.schema = this.onRequestSchemaResolved(requestContext.getRequestStatusManager(), factory.getSchemaName());
            this.isLoadSchema = this.gwtQuery.isLoadSchema();
            if (this.isLoadSchema) {
                OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
                Logger logger = engineRequestContext.getLoggers().gwtRequest();
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("[GWT] acquiring load-token for schema [" + this.schema + "]"));
                    }
                    OlapRequestId requestId = engineRequestContext.getRequestId();
                    OlapChattyRequest chattyRequest = IcCubeGwtServerRequest.isChattyRequest(this.gwtQuery);
                    OlapRequestVerbosity verbosity = IcCubeGwtServerRequest.getVerbosity(this.gwtQuery);
                    OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
                    this.schemaLoadingToken = olapEngine.getSchemaLoadToken(engineRequestContext, requestInfo, this.schema);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("[GWT] acquired load-token for schema [" + this.schema + "]"));
                    }
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)("[GWT] load schema [" + this.schema + "] cancelled while waiting for a token"));
                    GwtSchemaLoadStatus uiStatus = GwtAbstractOlapEngineQueryHandler.createUiStatus(OlapSchemaLoadStatus.WAITING_LOADING_CANCELLED);
                    GwtSchemaLifeCycleReply response = new GwtSchemaLifeCycleReply(this.schema, uiStatus);
                    IcCubeGwtServerRequestReply reply = requestContext.getRequestReply();
                    reply.reportResponse(response);
                    return false;
                }
            }
            if (!(isDuplicatedLoadSchema = this.isDuplicatedLoadSchema(requestContext, factory))) {
                this.isFullLoadSchema = this.isFullLoadSchema(requestContext, factory);
            }
            return !isDuplicatedLoadSchema;
        }
        if (this.gwtQuery instanceof GwtAbstractMdxQuery) {
            GwtAbstractMdxQuery executeMdxQuery = (GwtAbstractMdxQuery)this.gwtQuery;
            return this.unsafeSetupTaskSchedulingInfoForMdx(requestContext, executeMdxQuery);
        }
        this.schema = this.onRequestSchemaResolved(requestContext.getRequestStatusManager(), this.gwtQuery.getSchema());
        this.schemaAccessLockMode = this.gwtQuery.isSchemaWrite() ? IcCubeSchemaAccessLockMode.WRITE : IcCubeSchemaAccessLockMode.READ;
        this.allSchema = this.gwtQuery.isAllSchema();
        return true;
    }

    private boolean unsafeSetupTaskSchedulingInfoForMdx(IcCubeGwtServerRequestContext requestContext, GwtAbstractMdxQuery executeMdxQuery) {
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapInstrExecListener listener = null;
        OlapEngineMdxHelper mdxHelper = OlapEngineMdxHelper.create((OlapEngineRequestContext)olapEngineRequestContext, listener, null);
        this.schema = this.onRequestSchemaResolved(requestContext.getRequestStatusManager(), executeMdxQuery.getSchema());
        String name = executeMdxQuery.getName();
        String mdx = executeMdxQuery.getQuery();
        String mdxHash = executeMdxQuery.getQueryId();
        OlapEngineMdxScriptCompilationInfo compilationInfo = mdxHelper.compileMdxScript(this.schema, name, mdx, mdxHash);
        requestContext.setMdxCompilationInfo(compilationInfo);
        OlapScriptInstr scriptInstr = compilationInfo.getScriptInstr();
        this.schemaAccessLockMode = scriptInstr != null ? scriptInstr.getSchemaAccessLockMode() : IcCubeSchemaAccessLockMode.NONE;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicatedLoadSchema(IcCubeGwtServerRequestContext requestContext, IOlapBuilderSchemaDefFactory factory) {
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        Logger logger = olapEngineRequestContext.getLoggers().gwtRequest();
        OlapSchemaInformation schemaInformation = new OlapSchemaInformation(this.getClientUUID(), factory.getSchemaGroup(), this.schema, new File(this.gwtQuery.getSchemaFactoryFile()), factory, factory.incrementalLoadActive(), this.gwtQuery.getSchemaOfflineSnapshot());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("GWT request : checking duplicated-loading for schema [" + this.schema + "]"));
        }
        try {
            block9: {
                do {
                    this.schemaLoadingLock = olapEngine.onSchemaLoadingStarted(olapEngineRequestContext, schemaInformation);
                    if (this.schemaLoadingLock.getStatus() == 0) break block9;
                    requestContext.getOlapEngineRequestContext().onProgressEvent("waitingOnDuplicatedLoading", new Serializable[0]);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!requestContext.isCancelling());
                logger.warn((Object)("GWT request : schema [" + this.schema + "] cancelled while waiting because of duplicated loading"));
                GwtSchemaLoadStatus uiStatus = GwtAbstractOlapEngineQueryHandler.createUiStatus(OlapSchemaLoadStatus.DUPLICATED_LOADING_CANCELLED);
                GwtSchemaLifeCycleReply response = new GwtSchemaLifeCycleReply(this.schema, uiStatus);
                IcCubeGwtServerRequestReply reply = requestContext.getRequestReply();
                reply.reportResponse(response);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("GWT request : duplicated-loading check for schema [" + this.schema + "] done"));
            }
        }
    }

    private boolean isFullLoadSchema(IcCubeGwtServerRequestContext requestContext, IOlapBuilderSchemaDefFactory schemaFactory) {
        IOlapSchemasPermission schemasPermissions;
        OlapRolePermissions elevated;
        OlapRoleApplicationPermissions applicationPermissions;
        OlapRuntimeContext rContext;
        if (this.gwtQuery.isFullLoadSchema()) {
            return true;
        }
        if (this.gwtQuery instanceof GwtLoadOfflineSchemaQuery) {
            return true;
        }
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        boolean hasSchema = olapEngine.hasAuthorizedSchema(rContext = requestContext.asRuntimeContext(), applicationPermissions = (elevated = olapEngineRequestContext.elevateForBuilderPermissions()).getApplicationPermissions(), schemasPermissions = elevated.getSchemasPermissions(), this.schema);
        boolean fullLoad = !hasSchema || !schemaFactory.incrementalLoadActive();
        return fullLoad;
    }

    @Override
    protected void setupTasks(List<IcCubeServerTask> tasks, IcCubeGwtServerRequestContext requestContext) {
        if (this.isLoadSchema) {
            if (this.isFullLoadSchema) {
                tasks.add(new FullLoadReadTask(requestContext, this));
            } else {
                tasks.add(new IncrLoadReadTask(requestContext, this));
            }
            tasks.add(new LoadWriteTask(requestContext, this));
        } else if (this.gwtQuery.isUnloadSchema()) {
            tasks.add(new UnloadReadTask(requestContext, this));
            tasks.add(new UnloadWriteTask(requestContext, this));
        } else {
            tasks.add(new SingleTask(requestContext, this));
        }
    }

    @Override
    public void onFinallyForSchemaLifeCycleRequest(IcCubeGwtServerRequestContext requestContext) {
        super.onFinallyForSchemaLifeCycleRequest(requestContext);
        if (this.isLoadSchema && this.schemaLoadingToken != null) {
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
            OlapRequestId requestId = olapEngineRequestContext.getRequestId();
            OlapChattyRequest chattyRequest = IcCubeGwtServerRequest.isChattyRequest(this.gwtQuery);
            OlapRequestVerbosity verbosity = IcCubeGwtServerRequest.getVerbosity(this.gwtQuery);
            OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
            olapEngine.releaseSchemaLoadToken(olapEngineRequestContext, requestInfo, this.schemaLoadingToken);
        }
        if (this.isLoadSchema && this.schemaLoadingLock != null) {
            this.onFinallyForSchemaLoaded(requestContext, this.schemaLoadingLock);
        }
    }

    static class FullLoadReadTask
    extends Task {
        protected FullLoadReadTask(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request) {
            super(requestContext, request, "GWT-SCHEMA-PHASE-I (full)", IcCubeSchemaAccessLock.create((String)request.schema, (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.NONE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeGwtServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(0);
            super.unsafeExecute();
        }
    }

    static class IncrLoadReadTask
    extends Task {
        protected IncrLoadReadTask(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request) {
            super(requestContext, request, "GWT-SCHEMA-PHASE-I (incr.)", IcCubeSchemaAccessLock.create((String)request.schema, (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.READ));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeGwtServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(0);
            super.unsafeExecute();
        }
    }

    static class LoadWriteTask
    extends Task {
        protected LoadWriteTask(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request) {
            super(requestContext, request, "GWT-SCHEMA-PHASE-II", IcCubeSchemaAccessLock.create((String)request.schema, (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.II;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeGwtServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(1);
            super.unsafeExecute();
        }
    }

    static class UnloadReadTask
    extends Task {
        protected UnloadReadTask(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request) {
            super(requestContext, request, "GWT-UNLOAD-SCHEMA-PHASE-I", IcCubeSchemaAccessLock.create((String)request.schema, (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.NONE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.I;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeGwtServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(0);
            super.unsafeExecute();
        }
    }

    static class UnloadWriteTask
    extends Task {
        protected UnloadWriteTask(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request) {
            super(requestContext, request, "GWT-UNLOAD-SCHEMA-PHASE-II", IcCubeSchemaAccessLock.create((String)request.schema, (IcCubeSchemaAccessLockMode)IcCubeSchemaAccessLockMode.WRITE));
        }

        public OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase() {
            return OlapSchemaLifeCycleStatusPhase.II;
        }

        @Override
        public void unsafeExecute() throws Exception {
            OlapEngineRequestContext olapEngineRequestContext = ((IcCubeGwtServerRequestContext)this.requestContext).getOlapEngineRequestContext();
            olapEngineRequestContext.setLoadSchemaTask(1);
            super.unsafeExecute();
        }
    }

    static class SingleTask
    extends Task {
        protected SingleTask(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request) {
            super(requestContext, request, "GWT", IcCubeSchemaAccessLock.create((boolean)request.allSchema, (String)request.schema, (IcCubeSchemaAccessLockMode)request.schemaAccessLockMode));
        }
    }

    static abstract class Task
    extends IcCubeServerTask<IcCubeGwtServerRequest, IcCubeGwtServerRequestContext> {
        protected Task(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request, String uid, @Nullable IcCubeSchemaAccessLock lock) {
            super(requestContext, request, uid, lock);
        }

        @Override
        public void unsafeExecute() throws Exception {
            GwtQuery gwtQuery = ((IcCubeGwtServerRequest)this.request).getGwtQuery();
            Object response = GwtQueryHandlerDispatcher.dispatchQuery((IcCubeGwtServerRequestContext)this.requestContext, gwtQuery);
            IcCubeGwtServerRequestReply reply = ((IcCubeGwtServerRequestContext)this.requestContext).getRequestReply();
            reply.reportResponse(this, (GwtInfo)response);
        }
    }
}

