/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.request.gvi;

import crazydev.common.lz4.CdLz4;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.server.gvi.request.parser.GviQueryParser;
import crazydev.iccube.server.request.processor.print.IcCubePrintState;
import crazydev.iccube.ux.processor.UxServerRequestJsonParams;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.IO;
import org.jetbrains.annotations.Nullable;

public class IcCubeGviServerRequestParams {
    private static final String GZ = "_ic3_gz_";
    private static final String GZ_LEN = "_ic3_gz_len_";
    private final Map<String, String> jettyParams;
    private final Map<String, String> params = new HashMap<String, String>();
    private final Set<String> compressedParamNames = new HashSet<String>();
    @Nullable
    private final OlapChattyRequest chattyRequest;
    @Nullable
    private final OlapRequestVerbosity verbosity;

    public IcCubeGviServerRequestParams(HttpServletRequest request) {
        this(IcCubeGviServerRequestParams.asSingleValues(request));
    }

    public IcCubeGviServerRequestParams(Map<String, String> jettyParams) {
        this.jettyParams = jettyParams;
        for (Map.Entry<String, String> entry : jettyParams.entrySet()) {
            String pName = entry.getKey();
            String pValue = entry.getValue();
            this.decompressParameter(pName, pValue);
        }
        String action = this.getParamValue("action");
        this.chattyRequest = IcCubeGviServerRequestParams.isChattyRequest(action);
        String verbosity = this.getParamValue(OlapRequestVerbosity.VERBOSITY());
        this.verbosity = OlapRequestVerbosity.fromParam((String)verbosity);
    }

    @Nullable
    public static OlapChattyRequest isChattyRequest(String action) {
        return null;
    }

    private static Map<String, String> asSingleValues(HttpServletRequest request) {
        if (request == null) {
            return new HashMap<String, String>();
        }
        Map jettyParams = request.getParameterMap();
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry entry : jettyParams.entrySet()) {
            String string = (String)entry.getKey();
            String[] pValues = (String[])entry.getValue();
            if (pValues == null || pValues.length <= 0) continue;
            params.put(string, pValues[0]);
        }
        Map<String, ?> jsonParams = UxServerRequestJsonParams.create(request);
        for (Map.Entry<String, ?> entry : jsonParams.entrySet()) {
            String name = entry.getKey();
            Object values = entry.getValue();
            if (values instanceof String) {
                params.put(name, (String)values);
                continue;
            }
            if ((name.startsWith(GZ_LEN) || name.equals("timestamp")) && values instanceof Number) {
                params.put(name, String.valueOf(((Number)values).intValue()));
                continue;
            }
            params.put(name, values.toString());
        }
        String contentType = request.getContentType();
        if (contentType != null && MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpField.getValueParameters((String)contentType, null))) {
            try {
                Collection collection = request.getParts();
                for (Part part : collection) {
                    if (!"_ic3_gz_reportState".equals(part.getName())) continue;
                    InputStream is = part.getInputStream();
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        IO.copy((InputStream)is, (OutputStream)os);
                        String content = os.toString(StandardCharsets.UTF_8);
                        params.put("_ic3_gz_reportState", content);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (ServletException | IOException throwable) {
                throw new RuntimeException("unexpected error while processing the _ic3_gz_reportState parameter", throwable);
            }
        }
        return params;
    }

    @Nullable
    public IcCubePrintState getPrintState() {
        return new IcCubePrintState(this.params.get("reportState"));
    }

    @Nullable
    public OlapChattyRequest isChattyRequest() {
        return this.chattyRequest;
    }

    @Nullable
    public OlapRequestVerbosity getVerbosity() {
        return this.verbosity;
    }

    public Set<String> getParamNames() {
        return this.params.keySet();
    }

    public void addParamValue(String name, String value) {
        this.params.put(name, value);
    }

    public String getParamValue(String name) {
        return this.params.get(name);
    }

    public void log() {
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            GviQueryParser.logHttpParameter(this.chattyRequest, this.verbosity, key, value);
        }
    }

    private void decompressParameter(String name, String value) {
        int decompressedLen;
        if (name.startsWith(GZ_LEN)) {
            return;
        }
        if (!name.startsWith(GZ)) {
            this.addParamValue(name, value);
            return;
        }
        String paramName = name.substring(GZ.length());
        this.compressedParamNames.add(paramName);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            this.addParamValue(paramName, value);
            return;
        }
        String decompressedLenValue = this.jettyParams.get(GZ_LEN + paramName);
        if (decompressedLenValue == null) {
            throw new RuntimeException("internal error : missing GVI parameter [_ic3_gz_len_" + paramName + "]");
        }
        try {
            decompressedLen = Integer.parseInt(decompressedLenValue);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("internal error : unexpected GVI parameter [_ic3_gz_len_" + paramName + "] integer value [" + decompressedLenValue + "]", ex);
        }
        byte[] compressedUTF8 = Base64.decodeBase64((String)value);
        byte[] decompressedUTF8 = CdLz4.decompress((byte[])compressedUTF8, (int)decompressedLen);
        try {
            String decompressed = new String(decompressedUTF8, "UTF-8");
            this.addParamValue(paramName, decompressed);
        }
        catch (UnsupportedEncodingException unlikely) {
            throw new RuntimeException("internal error : UTF-8 not supported", unlikely);
        }
    }
}

