/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.request.gvi;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.gvi.GviConstants;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.version.CdVersion;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatusPhase;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.request.IcCubeRequestCategory;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.request.IcCubeRequestType;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.gvi.request.common.GviQueryContext;
import crazydev.iccube.server.gvi.request.common.GviQueryKind;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.executemdx.GviExecuteMdxQuery;
import crazydev.iccube.server.gvi.request.parser.GviQueryParser;
import crazydev.iccube.server.gvi.request.parser.GviQueryParserException;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintServletHttpRequest;
import crazydev.iccube.server.request.request.common.IcCubeServerRequest;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestContext;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestParams;
import crazydev.iccube.server.request.request.gvi.IcCubeGviServerRequestReply;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubeGviServerRequest
extends IcCubeServerRequest<IcCubeGviServerRequest, IcCubeGviServerRequestReply, IcCubeGviServerRequestContext> {
    @Nullable
    private final HttpServletRequest httpRequest;
    @Nullable
    private final HttpServletResponse httpResponse;
    private final IcCubeGviServerRequestParams gviQueryParams;
    private final GviQuery gviQuery;
    private IcCubeSchemaAccessLockMode schemaAccessLockMode;

    public IcCubeGviServerRequest(OlapRequestId requestId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws GviQueryParserException {
        super(requestId);
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.gviQueryParams = new IcCubeGviServerRequestParams(httpRequest);
        this.gviQuery = this.setupGviQuery(requestId);
    }

    public IcCubeGviServerRequest(OlapRequestId requestId, IcCubeGviServerRequestParams queryParams, GviQuery query) {
        super(requestId);
        this.httpRequest = null;
        this.httpResponse = null;
        this.gviQueryParams = queryParams;
        this.gviQuery = query;
    }

    public HttpServletResponse getHttpResponse() {
        if (this.httpResponse == null) {
            throw new RuntimeException("internal error : missing HTTP response");
        }
        return this.httpResponse;
    }

    protected GviQuery setupGviQuery(OlapRequestId requestId) throws GviQueryParserException {
        String uuid = requestId.getClientUUID();
        this.gviQueryParams.addParamValue(GviConstants.Param.uuid.name(), uuid);
        this.gviQueryParams.log();
        return GviQueryParser.parseQuery(this.gviQueryParams);
    }

    public boolean isWithoutCSRFTokenValidation() {
        return this.httpRequest instanceof IcCubePrintServletHttpRequest;
    }

    @Nullable
    public String getCSRFSessionToken() {
        OlapPrincipal principal;
        if (this.httpRequest == null) {
            return null;
        }
        if (this.httpRequest instanceof IcCubePrintServletHttpRequest) {
            IcCubePrintServletHttpRequest printRequest = (IcCubePrintServletHttpRequest)this.httpRequest;
            IcCubePrintJob job = printRequest.getPrintingJob();
            String token = job.getCSRFToken();
            return token;
        }
        HttpSession session = this.httpRequest.getSession(false);
        if (session != null && (principal = (OlapPrincipal)session.getAttribute("icCube.principal")) != null) {
            String token = principal.getCSRFToken();
            return token;
        }
        return null;
    }

    @Nullable
    public String getCSRFHeaderToken() {
        if (this.httpRequest == null) {
            return null;
        }
        String token = this.httpRequest.getHeader("X-CSRF-TOKEN");
        if (CdStringUtils.isNullOrBlank((String)token)) {
            token = this.gviQueryParams.getParamValue("X-CSRF-TOKEN");
        }
        return token;
    }

    public String toStringForCSRFError() {
        return this.gviQuery.getInternalTypeName() + ": " + (this.httpRequest != null ? this.httpRequest.toString() : "");
    }

    @Nullable
    public OlapChattyRequest isChattyRequest() {
        return this.gviQueryParams.isChattyRequest();
    }

    @Nullable
    public OlapRequestVerbosity getVerbosity() {
        return this.gviQueryParams.getVerbosity();
    }

    public IcCubeRequestType getRequestType() {
        return this.gviQuery.getRequestType();
    }

    @Nullable
    public Boolean getBooleanProperty(String name) {
        if (GviConstants.Param.noAutoCancel.name().equals(name)) {
            return this.gviQuery.isNoAutoCancel();
        }
        return null;
    }

    @Nullable
    public Long getLongProperty(String name) {
        if (GviConstants.Param.timestamp.name().equals(name)) {
            return this.gviQuery.getTimestamp();
        }
        return null;
    }

    @Nullable
    public String getProperty(String name) {
        if (GviConstants.Param.windowUId.name().equals(name)) {
            return this.gviQuery.getWindowUid();
        }
        if (GviConstants.Param.widgetUId.name().equals(name)) {
            return this.gviQuery.getWidgetUid();
        }
        return null;
    }

    @Nullable
    public String getSchema() {
        return this.gviQuery.getSchema();
    }

    @Nullable
    public String getMdxForCancelReport() {
        return this.gviQuery.getMdxForCancelReport();
    }

    @Nullable
    public String getLocale() {
        if (this.httpRequest == null) {
            return null;
        }
        String locale = GviQueryParser.getHttpParam(this.gviQueryParams, GviConstants.Param.locale);
        if (CdStringUtils.isNullOrBlank((String)locale)) {
            return null;
        }
        return locale;
    }

    @Override
    @Nullable
    public String getPrintJobUUID() {
        if (this.httpRequest instanceof IcCubePrintServletHttpRequest) {
            IcCubePrintServletHttpRequest pRequest = (IcCubePrintServletHttpRequest)this.httpRequest;
            IcCubePrintJob job = pRequest.getPrintingJob();
            return job.getUuid();
        }
        return null;
    }

    public boolean isUiMonitored() {
        return this.gviQuery.isMonitored();
    }

    public IcCubeRequestCategory getCategory() {
        return IcCubeRequestCategory.GVI;
    }

    public IcCubeRequestKind getKind() {
        GviQueryKind kind = this.gviQuery.getKind();
        switch (kind) {
            case LOAD: {
                return IcCubeRequestKind.LOAD;
            }
            case MDX: {
                return IcCubeRequestKind.MDX;
            }
            case SQL: {
                return IcCubeRequestKind.SQL;
            }
        }
        return IcCubeRequestKind.OTHER;
    }

    public String getInternalTypeName() {
        return this.gviQuery.getClass().getSimpleName();
    }

    public String getTrackingInfo() {
        return this.gviQuery.getTrackingInfo();
    }

    public String getUserFriendlyTypeName() {
        return this.gviQuery.getUserFriendlyTypeName();
    }

    public Logger getLogger() {
        return OlapLoggers.GVI_REQUEST;
    }

    public String getLoggerInfo() {
        return "GVI request [...]";
    }

    public GviQuery getExistingGviQuery() {
        if (this.gviQuery == null) {
            throw new CdProgrammingException("internal error: missing GVI query");
        }
        return this.gviQuery;
    }

    @Nullable
    public CdVersion getRequestVersion() {
        return this.gviQuery != null ? this.gviQuery.getVersion() : null;
    }

    @Override
    public boolean isSchemaLifeCycle() {
        return false;
    }

    @Override
    protected String getSchemaLifeCycleName() {
        return null;
    }

    @Override
    protected OlapSchemaLifeCycleStatus getSchemaLifeCycleStatus(IcCubeGviServerRequestContext requestContext) {
        return null;
    }

    @Override
    protected OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase(IcCubeGviServerRequestContext requestContext) {
        return null;
    }

    @Nullable
    private String getSchemaFromExistingQuery() {
        GviQuery gviQuery = this.getExistingGviQuery();
        String schema = gviQuery.getSchema();
        return schema;
    }

    public void setupMdxRequestProperties(OlapEngineRequestContext requestContext) {
        if (this.gviQuery != null) {
            Integer tidyMaxRowCount;
            boolean forTidyEvaluation;
            boolean newDefaults = this.gviQuery.getVersion() != null;
            GviQuery gviQuery = this.gviQuery;
            if (gviQuery instanceof GviExecuteMdxQuery) {
                GviExecuteMdxQuery executeMdxQuery = (GviExecuteMdxQuery)gviQuery;
                forTidyEvaluation = true;
                tidyMaxRowCount = executeMdxQuery.getTidyMaxRowCount();
            } else {
                forTidyEvaluation = false;
                tidyMaxRowCount = null;
            }
            requestContext.setupMdxRequestProperties(newDefaults, newDefaults ? OlapIntrinsicCellProperties.DEFAULT_EX : null, forTidyEvaluation, tidyMaxRowCount, this.gviQuery.getCellCountMax(), this.gviQuery.getTimeoutS(), null);
        }
    }

    @Override
    protected boolean unsafeSetupTaskSchedulingInfo(IcCubeGviServerRequestContext requestContext) throws Exception {
        requestContext.assertGviApplicationAuthorized(this.gviQuery);
        if (OlapLoggers.GVI_REQUEST.isDebugEnabled() && OlapLoggers.isDebugEnabled((OlapChattyRequest)this.isChattyRequest(), (OlapRequestVerbosity)this.getVerbosity())) {
            OlapLoggers.GVI_REQUEST.debug((Object)("[GVI] request [" + this.gviQuery.getClass().getSimpleName() + "]"));
        }
        if (!(this.gviQuery instanceof GviExecuteMdxQuery)) {
            if (this.gviQuery.isSchemaWrite()) {
                this.schemaAccessLockMode = IcCubeSchemaAccessLockMode.WRITE;
                return true;
            }
            String schema = this.gviQuery.getSchema();
            if (schema != null) {
                this.schemaAccessLockMode = IcCubeSchemaAccessLockMode.READ;
                return true;
            }
            this.schemaAccessLockMode = IcCubeSchemaAccessLockMode.NONE;
            return true;
        }
        GviExecuteMdxQuery executeMdxQuery = (GviExecuteMdxQuery)this.gviQuery;
        return this.unsafeSetupTaskSchedulingInfoForMdx(requestContext, executeMdxQuery);
    }

    private boolean unsafeSetupTaskSchedulingInfoForMdx(IcCubeGviServerRequestContext requestContext, GviExecuteMdxQuery executeMdxQuery) {
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapMdxDebugNodeCollector listener = null;
        if (executeMdxQuery.isForDebug()) {
            listener = new OlapMdxDebugNodeCollector();
        }
        String schema = executeMdxQuery.getSchema();
        String mdx = executeMdxQuery.getMdx();
        String mdxHash = UUID.randomUUID().toString();
        String[] initialSelection = executeMdxQuery.getInitialSelection();
        OlapEngineMdxHelper mdxHelper = OlapEngineMdxHelper.create((OlapEngineRequestContext)olapEngineRequestContext, (OlapInstrExecListener)listener, null);
        Object compilationInfo = executeMdxQuery.isForScript() ? mdxHelper.compileMdxScript(schema, "script", mdx, mdxHash) : mdxHelper.compileMdxStatement(schema, mdx, mdxHash, initialSelection);
        requestContext.setMdxCompilationInfo((ICompilationInfo)compilationInfo);
        IExecuteStatementInstr statementInstr = compilationInfo.getInstr();
        this.schemaAccessLockMode = statementInstr != null ? statementInstr.getSchemaAccessLockMode() : IcCubeSchemaAccessLockMode.NONE;
        return true;
    }

    @Override
    protected void setupTasks(List<IcCubeServerTask> tasks, IcCubeGviServerRequestContext requestContext) {
        tasks.add(new SingleTask(requestContext, this));
    }

    static class SingleTask
    extends IcCubeServerTask<IcCubeGviServerRequest, IcCubeGviServerRequestContext> {
        protected SingleTask(IcCubeGviServerRequestContext requestContext, IcCubeGviServerRequest request) {
            super(requestContext, request, "GVI", IcCubeSchemaAccessLock.create((String)request.getSchemaFromExistingQuery(), (IcCubeSchemaAccessLockMode)request.schemaAccessLockMode));
        }

        @Override
        public void unsafeExecute() throws Exception {
            ((IcCubeGviServerRequestContext)this.requestContext).assertGviApplicationAuthorized(((IcCubeGviServerRequest)this.request).gviQuery);
            IcCubeGviServerRequest request = (IcCubeGviServerRequest)((Object)((IcCubeGviServerRequestContext)this.requestContext).getRequest());
            GviQuery gviQuery = request.getExistingGviQuery();
            GviQueryContext gviRequestContext = new GviQueryContext((IcCubeGviServerRequestContext)this.requestContext);
            GviResponse response = gviQuery.execute(gviRequestContext);
            IcCubeGviServerRequestReply reply = ((IcCubeGviServerRequestContext)this.requestContext).getRequestReply();
            reply.reportResponse(this, response);
        }
    }
}

