/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.request.common;

import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationApplicationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.ux.meta.UxBuilderMetaInfo;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfos;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.request.IcCubeRequestReply;
import crazydev.iccube.request.status.IcCubeActiveRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.configuration.IcCubeServerProperties;
import crazydev.iccube.server.configuration.ai.IcCubeAIConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.gvi.request.common.GviQuery;
import crazydev.iccube.server.loggers.OlapLoggerLevelManager;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.request.common.IcCubeServerRequest;
import crazydev.iccube.tenants.OlapTenantManager;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubeServerRequestContext<REQUEST extends IcCubeServerRequest, REPLY extends IcCubeRequestReply>
implements IOlapCancellingContext {
    protected final IcCubeServerSessionContext sessionContext;
    protected final REQUEST request;
    protected final OlapRolePermissions permissions;
    protected final OlapEngineRequestContext olapEngineRequestContext;
    @Nullable
    private volatile IcCubeActiveRequestStatus activeRequestStatus;

    protected IcCubeServerRequestContext(IcCubeServerSessionContext sessionContext, REQUEST request) {
        this(sessionContext, request, sessionContext.getUserPermissions(request.getRequestId()), null);
    }

    protected IcCubeServerRequestContext(IcCubeServerSessionContext sessionContext, REQUEST request, OlapRolePermissions permissions, @Nullable Locale locale) {
        this.sessionContext = sessionContext;
        this.sessionContext.onTouched();
        this.request = request;
        this.permissions = permissions;
        this.olapEngineRequestContext = new OlapEngineRequestContext(sessionContext.getOlapEngineSessionContext(), request.getRequestId(), permissions, locale, false);
    }

    protected IcCubeServerRequestContext(IcCubeServerSessionContext sessionContext, REQUEST request, @Nullable Locale locale) {
        this(sessionContext, request, locale, CdXmlaCaller.Generic, false);
    }

    protected IcCubeServerRequestContext(IcCubeServerSessionContext sessionContext, REQUEST request, @Nullable Locale locale, CdXmlaCaller caller, boolean prepareExecutionMode) {
        this.sessionContext = sessionContext;
        this.sessionContext.onTouched();
        this.request = request;
        this.permissions = sessionContext.getUserPermissions(request.getRequestId());
        this.olapEngineRequestContext = new OlapEngineRequestContext(sessionContext.getOlapEngineSessionContext(), request.getRequestId(), this.permissions, locale, caller, prepareExecutionMode, false);
    }

    protected IcCubeServerRequestContext(IcCubeServerSessionContext sessionContext, REQUEST request, OlapEngineRequestContext olapEngineRequestContext) {
        this.sessionContext = sessionContext;
        this.sessionContext.onTouched();
        this.request = request;
        this.permissions = olapEngineRequestContext.getCurrentPermissions();
        this.olapEngineRequestContext = olapEngineRequestContext;
    }

    public boolean isInCluster() {
        return this.olapEngineRequestContext.isInCluster();
    }

    public Logger getLogger() {
        return this.request.getLogger();
    }

    public String getLoggerInfo() {
        return this.request.getLoggerInfo();
    }

    @Nullable
    public String getUserTenantName() {
        OlapTenant tenant = this.getUserTenant();
        return tenant != null ? tenant.getName() : null;
    }

    public String getUserRoleName() {
        return this.sessionContext.getUserRoleName();
    }

    @Nullable
    public OlapTenant getUserTenant() {
        return this.olapEngineRequestContext.getUserTenant();
    }

    public void resetUserTenant(@Nullable OlapTenant tenant) {
        this.olapEngineRequestContext.resetUserTenant(tenant);
    }

    public String getUserName() {
        return this.sessionContext.getUserName();
    }

    public REQUEST getRequest() {
        return this.request;
    }

    public OlapRequestId getRequestId() {
        return this.request.getRequestId();
    }

    public String getRequestClientUUID() {
        return this.request.getClientUUID();
    }

    public String getIc3RequestId() {
        OlapRequestId id = this.getRequestId();
        return String.valueOf(id.getId());
    }

    public long getIc3ElapsedMS() {
        Date start = this.request.getStartDate();
        long startMS = start.getTime();
        long elapsedMS = System.currentTimeMillis() - startMS;
        return elapsedMS;
    }

    public abstract REPLY getRequestReply();

    @Nullable
    public REPLY getRequestReplyForCompletionStatus() {
        try {
            return this.getRequestReply();
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    @Nullable
    private IcCubeActiveRequestStatus resolveActiveRequestStatus() {
        IcCubeRequestStatusManager statusManager;
        if (this.activeRequestStatus == null && (statusManager = this.getRequestStatusManager()) != null) {
            this.activeRequestStatus = statusManager.getActiveRequestStatus_(this.getRequestClientUUID());
        }
        return this.activeRequestStatus;
    }

    public boolean isCancelling() {
        IcCubeActiveRequestStatus status = this.resolveActiveRequestStatus();
        if (status != null) {
            return status.isCancelling();
        }
        return false;
    }

    public void assertNotCancelling(String message) {
        IcCubeActiveRequestStatus status = this.resolveActiveRequestStatus();
        if (status != null) {
            status.assertNotCancelling(message);
        }
    }

    public OlapBabylonService getBabylonService() {
        return this.olapEngineRequestContext.getBabylonService();
    }

    public IcCubeRequestStatusManager getRequestStatusManager() {
        return this.sessionContext.getRequestStatusManager();
    }

    public OlapTenantManager getTenantManager() {
        return this.getApplicationContext().getTenantManager();
    }

    public IcCubeServerSessionContext getSessionContext() {
        return this.sessionContext;
    }

    public IcCubeServerApplicationContext getApplicationContext() {
        return this.sessionContext.getApplicationContext();
    }

    public OlapEngineRequestContext getOlapEngineRequestContext() {
        return this.olapEngineRequestContext;
    }

    public OlapEngineComponent getOlapEngineComponent() {
        IcCubeServerApplicationContext applicationContext = this.sessionContext.getApplicationContext();
        return applicationContext.getOlapEngineComponent();
    }

    public Locale getOlapEngineLocale() {
        IcCubeServerApplicationContext applicationContext = this.sessionContext.getApplicationContext();
        return applicationContext.getOlapEngineLocale();
    }

    public boolean canEditOwnsRole(@Nullable String uuid) {
        String userName;
        if (this.isAdministrator()) {
            return true;
        }
        IcCubeServerProperties props = this.getServerProperties();
        boolean disableEditOwnsRole = props.isDisableEditOwnsRole();
        if (!disableEditOwnsRole) {
            return true;
        }
        if (uuid == null) {
            return false;
        }
        IOlapAuthenticationService auth = this.getApplicationContext().getAuthenticationService();
        OlapUserDefinition userDefinition = auth.getUserDefinitionByName(userName = this.getUserName());
        if (userDefinition == null) {
            return false;
        }
        IOlapPermissionsService perms = this.getRolePermissionsService();
        List roleNames = userDefinition.getRoles();
        if (roleNames == null || roleNames.isEmpty()) {
            return false;
        }
        for (String roleName : roleNames) {
            OlapRolePermissions role = perms.getRolePermissions(roleName);
            if (role == null) {
                return false;
            }
            String roleUUID = role.getDefinition().getUUID();
            if (roleUUID == null) {
                return false;
            }
            if (!roleUUID.equals(uuid)) continue;
            return false;
        }
        return true;
    }

    public IOlapPermissionsService getRolePermissionsService() {
        return this.sessionContext.getRolePermissionsService();
    }

    @Nullable
    public IcCubePrintService getPrintService() {
        return this.sessionContext.getPrintService();
    }

    @Nullable
    public IcCubePrintComponentConfiguration getPrintConfiguration() {
        return this.sessionContext.getPrintConfiguration();
    }

    public OlapNotificationService getNotificationService() {
        OlapEngineApplicationContext engineApplicationContext = this.olapEngineRequestContext.getApplicationContext();
        return engineApplicationContext.getNotificationService();
    }

    public IcCubeServerProperties getServerProperties() {
        return this.sessionContext.getServerProperties();
    }

    public UxBuilderMetaInfo getBuilderMetaInfo() {
        OlapBuilderMetaInformationRepository repository = this.getOlapEngineComponent().getBuilderMetaInformationRepository();
        return repository.getUxMetaInfo();
    }

    public OlapCacheManager getCacheManager() {
        return this.sessionContext.getCacheManager();
    }

    public OlapEngineSchemaDefFactoryHelper getDeployedSchemaDefFactoryHelper() {
        return this.sessionContext.getDeployedSchemaDefFactoryHelper(this.asRuntimeContext());
    }

    public OlapLoggerLevelManager getLoggerLevelManager() {
        return this.sessionContext.getLoggerLevelManager();
    }

    @Nullable
    public OlapFileSystem getLogRoot() {
        return this.sessionContext.getLogRoot();
    }

    public OlapRolePermissions getCurrentPermissions() {
        return this.permissions;
    }

    @Nullable
    public OlapRoleFlatDocsProfile getCurrentUserDocsPermissions() {
        OlapRoleFlatDocsProfile perms = this.permissions.getDocsPermissions();
        return perms;
    }

    public boolean isSuperAdministrator() {
        OlapDirectoriesResolved directories = this.asRuntimeContext().getDirectoriesResolved();
        return this.isAdministrator() && directories.getTenant() == null;
    }

    public boolean isAdministrator() {
        return this.sessionContext.isAdministrator();
    }

    public boolean isAnonymous() {
        return this.sessionContext.isAnonymous();
    }

    public boolean isDocEditor() {
        OlapRoleApplicationPermissions applicationPermissions = this.permissions.getApplicationPermissions();
        return applicationPermissions.isReportDocManagementEditorEnabled();
    }

    public boolean isDocAdministrator() {
        OlapRoleApplicationPermissions applicationPermissions = this.permissions.getApplicationPermissions();
        return applicationPermissions.isReportDocManagementAdministratorEnabled();
    }

    public boolean isReportAppCreator() {
        OlapRoleApplicationPermissions applicationPermissions = this.permissions.getApplicationPermissions();
        return applicationPermissions.isReportDashboardApplicationCreateEnabled();
    }

    public boolean isGviApplicationAuthorized() {
        OlapRoleApplicationPermissions applicationPermissions = this.permissions.getApplicationPermissions();
        return applicationPermissions.isGviEnabled();
    }

    public void assertGviApplicationAuthorized(GviQuery gviQuery) throws OlapRoleAuthorizationException {
        OlapRoleApplicationPermissions applicationPermissions = this.permissions.getApplicationPermissions();
        try {
            applicationPermissions.assertGviEnabled();
        }
        catch (OlapRoleAuthorizationApplicationException ex) {
            if (!gviQuery.isForMdxConsole()) {
                throw ex;
            }
            applicationPermissions.assertMdxIdeEnabled();
        }
    }

    public boolean isUxApplicationAuthorized() {
        OlapRoleApplicationPermissions applicationPermissions = this.permissions.getApplicationPermissions();
        return applicationPermissions.isUxEnabled();
    }

    public void assertUxApplicationAuthorized() throws OlapRoleAuthorizationException {
        OlapRoleApplicationPermissions applicationPermissions = this.permissions.getApplicationPermissions();
        applicationPermissions.assertUxEnabled();
    }

    public boolean isSessionLess() {
        return this.olapEngineRequestContext.isSessionLess();
    }

    public boolean isCreateOfflineOnly() {
        return ((IcCubeServerRequest)((Object)this.request)).isCreateOfflineOnly();
    }

    public boolean isAccessRightsLicensed() {
        return this.olapEngineRequestContext.isAccessRightsLicensed();
    }

    public boolean isGviLicensed() {
        return this.olapEngineRequestContext.isGviLicensed();
    }

    public boolean isMmapFactsLicensed() {
        return this.olapEngineRequestContext.isMmapFactsLicensed();
    }

    public boolean isRealTimeLicensed() {
        return this.olapEngineRequestContext.isRealTimeLicensed();
    }

    public boolean isIncrLoadLicensed() {
        return this.olapEngineRequestContext.isIncrLoadLicensed();
    }

    public boolean isOfflineCubeLicensed() {
        return this.olapEngineRequestContext.isOfflineCubeLicensed();
    }

    public boolean isSchedulerLicensed() {
        return this.olapEngineRequestContext.isSchedulerLicensed();
    }

    public boolean isPerspectivesLicensed() {
        return this.olapEngineRequestContext.isPerspectivesLicensed();
    }

    public boolean isTablePartitioningLicensed() {
        return this.olapEngineRequestContext.isTablePartitioningLicensed();
    }

    public boolean isFactsPartitioningLicensed() {
        return this.olapEngineRequestContext.isFactsPartitioningLicensed();
    }

    public boolean isAllDataSourcesLicensed() {
        return this.olapEngineRequestContext.isAllDataSourcesLicensed();
    }

    public boolean isReportServerLicensed() {
        return this.olapEngineRequestContext.isReportServerLicensed();
    }

    public boolean isPrintServerLicensed() {
        return this.olapEngineRequestContext.isPrintServerLicensed();
    }

    public boolean isBackupLicensed() {
        return this.olapEngineRequestContext.isBackupLicensed();
    }

    public boolean isCommunity() {
        return this.olapEngineRequestContext.isCommunity();
    }

    public boolean isMissing() {
        return this.olapEngineRequestContext.isMissing();
    }

    public String getPoweredBy() {
        return this.olapEngineRequestContext.getPoweredBy();
    }

    public final OlapRequestNamesContext getNameContext() {
        return this.olapEngineRequestContext.getNameContext();
    }

    public Locale getLocale() {
        return this.olapEngineRequestContext.getLocale();
    }

    public Locale getLocaleForFormattingNumeric(Locale locale) {
        return this.olapEngineRequestContext.getLocaleForFormattingNumeric(locale);
    }

    @Nullable
    public OlapMdxResultCacheInfos getRebuildMdxResultCacheInfos() {
        return this.olapEngineRequestContext.getRebuildMdxResultCacheInfos();
    }

    public boolean isJavaMdxNativesActivated() {
        return this.olapEngineRequestContext.isJavaMdxNativesActivated();
    }

    public OlapRuntimeContext asRuntimeContext() {
        return this.olapEngineRequestContext.asRuntimeContext();
    }

    @Nullable
    public <T> T getServletContextAttribute(String name) {
        IcCubeServerApplicationContext appContext = this.getApplicationContext();
        return appContext.getServletContextAttribute(name);
    }

    public IcCubeAIConfiguration getAIConfiguration() {
        IcCubeServerApplicationContext appContext = this.getApplicationContext();
        return appContext.getAIConfiguration();
    }
}

