/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.xmla;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.locale.CdLanguageIdentifierHelper;
import crazydev.common.soap.CdDefaultSoapEnvelope;
import crazydev.common.soap.CdSoapEnvelope;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.processor.common.IcCubeRequestProcessor;
import crazydev.iccube.server.request.request.xmla.IcCubeXmlaServerRequest;
import crazydev.iccube.server.request.request.xmla.IcCubeXmlaServerRequestContext;
import crazydev.iccube.server.request.request.xmla.IcCubeXmlaServerRequestReply;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaQueryParser;
import crazydev.xmla.model.message.property.XmlaLocaleIdentifierProperty;
import crazydev.xmla.model.message.session.XmlaBeginSessionQuery;
import crazydev.xmla.model.proxy.XmlaInvocationTargetProxyException;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.engine.XmlaQuerySessionContext;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxyException;
import crazydev.xmla.server.iccube.server.message.XmlaEmptyResponse;
import crazydev.xmla.server.iccube.server.message.XmlaFault;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.session.XmlaEndSessionQueryHandler;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.xml.soap.SOAPException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IcCubeXmlaRequestProcessor
extends IcCubeRequestProcessor<XmlaResponse, IcCubeXmlaServerRequest, IcCubeXmlaServerRequestReply, IcCubeXmlaServerRequestContext> {
    public IcCubeXmlaRequestProcessor(IcCubeServerTaskExecutor taskExecutor, IcCubeRequestStatusManager statusManager) {
        super(taskExecutor, statusManager);
    }

    private IcCubeXmlaServerRequestContext setupRequestContext(HttpServletRequest httpRequest, IcCubeXmlaServerRequest request, CdXmlaCaller caller) {
        IcCubeServerSessionContext sessionContext = IcCubeServerSessionContext.getOrCreateSessionContext(httpRequest);
        IcCubeServerApplicationContext applicationContext = sessionContext.getApplicationContext();
        XmlaServerProxy xmlaEngine = applicationContext.getXmlaServerProxy();
        XmlaQuery xmlaQuery = request.getXmlaQuery();
        XmlaQuerySessionContext xmlaQuerySessionContext = this.getOrCreateXmlaQuerySessionContext(httpRequest, sessionContext.getSessionId(), xmlaQuery, xmlaEngine);
        XmlaQueryContext xmlaQueryContext = new XmlaQueryContext(xmlaQuerySessionContext, applicationContext.getRolePermissionsService(), applicationContext.getXmlaServerProxy(), httpRequest.getParameterMap(), caller);
        Locale locale = null;
        XmlaLocaleIdentifierProperty xmlaLocale = xmlaQuery.getLocaleIdentifierProperty();
        if (xmlaLocale != null) {
            OlapEngineApplicationContext olapEngineApplicationContext = applicationContext.getOlapEngineApplicationContext();
            Locale olapEngineLocale = olapEngineApplicationContext.getOlapEngineComponent().getLocale();
            CdLanguageIdentifier languageIdentifier = (CdLanguageIdentifier)xmlaLocale.getValue();
            locale = CdLanguageIdentifierHelper.toJavaLocale((Locale)olapEngineLocale, (CdLanguageIdentifier)languageIdentifier);
        }
        IcCubeXmlaServerRequestContext requestContext = new IcCubeXmlaServerRequestContext(sessionContext, xmlaQueryContext, request, locale);
        xmlaQueryContext.setOlapEngineRequestContext(requestContext.getOlapEngineRequestContext());
        return requestContext;
    }

    @Nullable
    private XmlaQuerySessionContext getOrCreateXmlaQuerySessionContext(HttpServletRequest httpRequest, String sessionId, XmlaQuery xmlaQuery, XmlaServerProxy xmlaEngine) {
        String xmlaSessionId = xmlaQuery.getSessionId();
        if (xmlaSessionId != null) {
            XmlaQuerySessionContext xmlaSessionContext = xmlaEngine.getSession(xmlaSessionId);
            if (xmlaSessionContext == null && !xmlaQuery.isEndSession()) {
                OlapLoggers.XMLA_REQUEST.warn((Object)("XMLA Session : ignoring unknown (previously ended?) session : " + xmlaSessionId));
                return null;
            }
            return xmlaSessionContext;
        }
        if (xmlaQuery.hasBeginSessionHeader()) {
            HttpSession httpSession = httpRequest.getSession(false);
            XmlaQuerySessionContext xmlaSessionContext = xmlaEngine.createSession(httpSession, sessionId);
            if (!(xmlaQuery instanceof XmlaBeginSessionQuery) && httpSession != null) {
                if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                    OlapLoggers.SESSIONS.info((Object)("[session] XMLA session bound to HTTP session [ session-context:" + xmlaSessionContext.getSessionId() + " / http-session:" + httpSession.getId() + " ]"));
                }
                httpSession.setAttribute("icCubeServer.xmlaSessionContext", (Object)xmlaSessionContext.getSessionId());
                xmlaQuery.setSessionIdOnBeginSession(xmlaSessionContext.getSessionId());
            }
            return xmlaSessionContext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXmlaRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        byte[] httpContent;
        CdXmlaCaller caller = CdXmlaCaller.fromHttpURI((String)httpRequest.getRequestURI());
        if (OlapLoggers.XMLA_REQUEST.isDebugEnabled()) {
            OlapLoggers.XMLA_REQUEST.debug((Object)("XMLA caller : " + String.valueOf(caller)));
        }
        if ((httpContent = this.extractHttpContent(httpRequest)).length == 0) {
            if (CdXmlaCaller.JaspersoftStudioProfessional.equals((Object)caller)) {
                httpResponse.sendError(500, "Cannot process empty /xmla");
                return;
            }
            httpResponse.setCharacterEncoding("UTF-8");
            httpResponse.setContentType("text/plain; charset=UTF-8");
            ServletOutputStream out = httpResponse.getOutputStream();
            out.print("icCube XMLA : invalid XMLA request (i.e., empty request)");
            out.flush();
            return;
        }
        String xmlaSessionId = null;
        try {
            XmlaQuery xmlaQuery = this.setupXmlaQuery(httpContent);
            xmlaSessionId = xmlaQuery.getSessionId();
            OlapRequestId requestId = OlapRequestId.getThreadRequestId((String)xmlaQuery.getClientUUID());
            IcCubeXmlaServerRequest request = new IcCubeXmlaServerRequest(requestId, httpRequest, httpResponse, xmlaQuery);
            IcCubeXmlaServerRequestContext requestContext = this.setupRequestContext(httpRequest, request, caller);
            xmlaQuery.fixMissingCatalog(() -> {
                XmlaQueryContext xmlaQueryContext = requestContext.getXmlaQueryContext();
                XmlaServerProxy proxy = xmlaQueryContext.getXmlaEngine();
                return proxy.getFirstAuthorizedSchemaName(xmlaQueryContext);
            });
            XmlaResponse response = (XmlaResponse)this.processXyzRequest(requestContext, request);
            if (xmlaQuery.hasEndSessionHeader()) {
                IcCubeServerApplicationContext applicationContext = requestContext.getApplicationContext();
                XmlaServerProxy xmlaEngine = applicationContext.getXmlaServerProxy();
                XmlaEndSessionQueryHandler.closeSession((XmlaServerProxy)xmlaEngine, (String)xmlaQuery.getSessionId());
            }
            this.writeResponse(caller, httpResponse, response);
        }
        catch (SOAPException soap) {
            OlapLoggers.XMLA_REQUEST.error((Object)"XMLA request : SOAP syntax error", (Throwable)soap);
            throw new IOException("XMLA request: SOAP syntax error", soap);
        }
        catch (RuntimeException unexpected) {
            OlapLoggers.XMLA_REQUEST.error((Object)"XMLA request : unexpected processing error", (Throwable)unexpected);
            OlapBabylonService babylonService = OlapBabylonService.ENGLISH;
            XmlaFault response = new XmlaFault(xmlaSessionId, (CdBabylonService)babylonService, "unexpected processing error : " + unexpected.getMessage());
            this.writeResponse(caller, httpResponse, (XmlaResponse)response);
        }
        finally {
            String attachedXmlaSessionId;
            HttpSession session = httpRequest.getSession(false);
            if (session != null && (attachedXmlaSessionId = (String)session.getAttribute("icCubeServer.xmlaSessionContext")) == null) {
                session.invalidate();
            }
        }
    }

    @Override
    protected void onFinallyForSchemaLifeCycleRequest(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
        if (!request.isExecutionModePrepare()) {
            super.onFinallyForSchemaLifeCycleRequest(requestContext, request);
        }
    }

    @Override
    protected void onFinallyForSchemaLifeCycleRequestEx(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
        if (!request.isExecutionModePrepare()) {
            super.onFinallyForSchemaLifeCycleRequestEx(requestContext, request);
        }
    }

    protected XmlaQuery setupXmlaQuery(byte[] httpContent) throws SOAPException, IOException {
        CdDefaultSoapEnvelope soapEnvelope = new CdDefaultSoapEnvelope(httpContent);
        if (OlapLoggers.XMLA_REQUEST.isDebugEnabled()) {
            OlapLoggers.XMLA_REQUEST.debug((Object)("XMLA SOAP :" + String.valueOf(soapEnvelope)));
        }
        String uuid = UUID.randomUUID().toString();
        return XmlaQueryParser.parseSoapEnvelope((String)uuid, (CdSoapEnvelope)soapEnvelope);
    }

    @Override
    protected XmlaResponse createSuccessResponse(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request, IcCubeXmlaServerRequestReply reply) {
        XmlaResponse response = reply.getResponse();
        if (response == null) {
            throw new CdProgrammingException("internal error: reply inconsistency");
        }
        return response;
    }

    @Override
    protected XmlaResponse createCancelledResponse(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request, boolean onTimeout, @Nullable String extraInfo) {
        return new XmlaEmptyResponse(request.getXmlaSessionId());
    }

    @Override
    protected XmlaResponse createExceptionResponseEx(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request, Throwable exception) {
        XmlaServerProxyException xspe;
        Throwable xspeCause;
        InvocationTargetException ite;
        Throwable iteCause;
        String sessionId = request.getXmlaSessionId();
        Throwable cause = exception;
        if (cause instanceof XmlaInvocationTargetProxyException) {
            cause = ((XmlaInvocationTargetProxyException)cause).getTarget();
        }
        if (cause instanceof InvocationTargetException && (iteCause = (ite = (InvocationTargetException)cause).getCause()) != null) {
            cause = iteCause;
        }
        if (cause instanceof XmlaServerProxyException && (xspeCause = (xspe = (XmlaServerProxyException)cause).getCause()) != null) {
            cause = xspeCause;
        }
        Logger logger = requestContext.getLogger();
        logger.error((Object)(request.getLoggerInfo() + " : processing error"), cause);
        return new XmlaFault(sessionId == null ? null : sessionId, (CdBabylonService)requestContext.getBabylonService(), cause);
    }

    @Override
    protected XmlaResponse createMissingReplyResponse(IcCubeXmlaServerRequestContext requestContext, IcCubeXmlaServerRequest request) {
        return new XmlaFault(request.getXmlaSessionId(), (CdBabylonService)requestContext.getBabylonService(), "unexpected missing request reply");
    }

    private void writeResponse(CdXmlaCaller caller, HttpServletResponse httpResponse, XmlaResponse reply) throws IOException {
        this.logXmlaSoapResponse(caller, reply);
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("text/xml; charset=UTF-8");
        ServletOutputStream out = httpResponse.getOutputStream();
        BufferedOutputStream buffered = new BufferedOutputStream((OutputStream)out);
        if (OlapLoggers.XMLA_RESPONSE.isDebugEnabled()) {
            OlapLoggers.XMLA_RESPONSE.debug((Object)"XMLA response : sending started ...");
        }
        reply.emitContent(caller, (OutputStream)buffered);
        buffered.flush();
        if (OlapLoggers.XMLA_RESPONSE.isDebugEnabled()) {
            OlapLoggers.XMLA_RESPONSE.debug((Object)"XMLA response : sending done ");
        }
    }

    private byte[] extractHttpContent(HttpServletRequest request) throws IOException {
        int count;
        int len = request.getContentLength();
        if (len < 0) {
            len = 4096;
        }
        ServletInputStream in = request.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(len);
        byte[] tmp = new byte[4096];
        while ((count = in.read(tmp)) != -1) {
            buffer.write(tmp, 0, count);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private void logXmlaSoapResponse(CdXmlaCaller caller, XmlaResponse response) {
        try {
            if (OlapLoggers.XMLA_RESPONSE.isDebugEnabled()) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                response.emitContent(caller, (OutputStream)buffer);
                byte[] xmlResponse = buffer.toByteArray();
                OlapLoggers.XMLA_RESPONSE.debug((Object)("HTTP : SOAP response - " + new String(xmlResponse, "UTF-8")));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

