/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print.chrome;

import crazydev.common.exception.CdException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.http.IcCubeHttpComponent;
import crazydev.iccube.server.print.IcCubePrintComponent;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubeErrorPrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobCommandLine;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeChromePrintJobResult;
import crazydev.iccube.server.request.processor.print.chrome.IcCubeChromeProxy;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import io.webfolder.cdp.command.Browser;
import io.webfolder.cdp.command.IO;
import io.webfolder.cdp.command.Page;
import io.webfolder.cdp.event.Events;
import io.webfolder.cdp.event.browser.DownloadProgress;
import io.webfolder.cdp.event.browser.DownloadWillBegin;
import io.webfolder.cdp.event.log.EntryAdded;
import io.webfolder.cdp.event.runtime.ConsoleAPICalled;
import io.webfolder.cdp.event.runtime.ExceptionThrown;
import io.webfolder.cdp.exception.CdpException;
import io.webfolder.cdp.exception.CdpReadTimeoutException;
import io.webfolder.cdp.exception.LoadTimeoutException;
import io.webfolder.cdp.session.Session;
import io.webfolder.cdp.type.browser.GetVersionResult;
import io.webfolder.cdp.type.constant.DownloadBehavior;
import io.webfolder.cdp.type.constant.DownloadState;
import io.webfolder.cdp.type.constant.TransferMode;
import io.webfolder.cdp.type.io.ReadResult;
import io.webfolder.cdp.type.log.LogEntry;
import io.webfolder.cdp.type.page.PrintToPDFResult;
import io.webfolder.cdp.type.runtime.ExceptionDetails;
import io.webfolder.cdp.type.runtime.RemoteObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class IcCubeChromePrintService
extends IcCubePrintService {
    private final OlapDirectories directories;
    private final IcCubeChromeProxy chrome;

    public IcCubeChromePrintService(IcCubeHttpComponent httpComponent, IcCubePrintComponent printComponent, OlapDirectories directories, IcCubePrintComponentConfiguration configuration) {
        super(httpComponent, printComponent, true);
        this.directories = directories;
        this.chrome = new IcCubeChromeProxy(directories, configuration);
    }

    @Override
    public boolean canRestart() {
        return true;
    }

    @Override
    public void setUp() throws CdException {
        this.chrome.setup();
    }

    public void restart() throws CdException {
        this.chrome.restart(true);
    }

    @Override
    public void shutdownNow() {
        this.chrome.shutdownNow();
    }

    public int getMaxActiveCount() {
        return this.chrome.getMaxActiveCount();
    }

    public boolean isRunning() {
        return this.chrome.isRunning();
    }

    @Nullable
    public GetVersionResult getVersion() {
        return this.chrome.getVersion();
    }

    @Nullable
    public String getPID() {
        return this.chrome.getPID();
    }

    @Nullable
    public String getDebug() {
        return this.chrome.getDebug();
    }

    @Nullable
    public Date getStartTime() {
        return this.chrome.getStartTime();
    }

    public int getJobCountTotal() {
        return this.chrome.getJobCountTotal();
    }

    public int getJobCountUptime() {
        return this.chrome.getJobCountUptime();
    }

    public String getPermitCount() {
        return this.chrome.getPermitCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IcCubePrintJobResult doExecutePrintJob(OlapBabylonService babylon, IcCubePrintJob job) {
        try {
            long startMS = System.currentTimeMillis();
            OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") started [request:" + job.getRequestUUID() + "]"));
            this.chrome.onPrintingJobStarted();
            String browserContext = this.chrome.createBrowserContext(job.getUuid());
            try {
                if (browserContext == null) {
                    IcCubeErrorPrintJobResult icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, "Chrome not available (missing browser context: please contact your icCube administrator)");
                    return icCubeErrorPrintJobResult;
                }
                IcCubePrintJobResult icCubePrintJobResult = this.executePrintingJob(startMS, job, browserContext);
                return icCubePrintJobResult;
            }
            finally {
                this.chrome.disposeBrowserContext(job.getUuid(), browserContext);
            }
        }
        catch (CdpException | InterruptedException ex) {
            int timeout = job.getTimeout();
            OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") printing [timeout:" + timeout + "sec.] : print error (cancelled?) "), ex);
            return new IcCubeErrorPrintJobResult(job, "Error printing report : " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private IcCubePrintJobResult executePrintingJob(long startMS, IcCubePrintJob job, String browserContext) {
        String reportURL = job.getChromeNavigateURL(this.listeningUrl);
        IcCubePrintJobCommandLine commandLine = job.getCommandLine();
        int timeout = job.getTimeout();
        int waitPeriodMS = job.getWaitPeriodMS();
        try (Session session = this.chrome.createSession(browserContext);){
            IcCubeChromePrintJobResult icCubeChromePrintJobResult;
            block21: {
                block20: {
                    if (session == null) {
                        IcCubeErrorPrintJobResult icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, "Chrome not available (missing browser session: please contact your icCube administrator)");
                        return icCubeErrorPrintJobResult;
                    }
                    OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") Chrome browser context [" + browserContext + "] session [" + session.getId() + "]"));
                    OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") Chrome browser context [" + browserContext + "] session [" + session.getId() + "]"));
                    this.enableLogs(session, job);
                    OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") printing [timeout:" + timeout + "sec.] [wait:" + waitPeriodMS + "]: Chrome (headless) navigating to : " + reportURL));
                    OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") printing [timeout:" + timeout + "sec.] [wait:" + waitPeriodMS + "]: Chrome (headless) navigating to : " + reportURL));
                    session.navigate(reportURL);
                    int timeoutMS = 1000 * timeout;
                    int remainingTimeoutMS = Math.max(waitPeriodMS, timeoutMS - (int)(System.currentTimeMillis() - startMS));
                    session.waitDocumentReady(remainingTimeoutMS);
                    timeoutMS = 1000 * timeout;
                    remainingTimeoutMS = Math.max(waitPeriodMS, timeoutMS - (int)(System.currentTimeMillis() - startMS));
                    OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") waitingUntil( " + remainingTimeoutMS + "ms )"));
                    OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") waitingUntil( " + remainingTimeoutMS + "ms )"));
                    boolean gotIt = session.waitUntil(s -> {
                        boolean found;
                        boolean bl = found = this.safeCompareVariable((Session)s, "ic3printStatus") || this.safeCompareVariable((Session)s, "status");
                        if (OlapLoggers.PRINT.isDebugEnabled()) {
                            OlapLoggers.PRINT.debug((Object)("[printing] checking variables status [ic3printStatus|status] " + found));
                        }
                        return found;
                    }, remainingTimeoutMS, waitPeriodMS, true);
                    OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") waitingUntil() completed"));
                    OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") waitingUntil() completed"));
                    if (gotIt) break block20;
                    OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") printing [timeout:" + timeout + " sec.] : timeout without ic3reportRendered:true"));
                    int debugWaitTime = commandLine.getDebugWaitTime();
                    if (debugWaitTime > 0) {
                        if (OlapLoggers.PRINT.isDebugEnabled()) {
                            OlapLoggers.PRINT.debug((Object)("[printing] waiting for debugging: " + debugWaitTime + "s"));
                        }
                        session.wait(1000 * debugWaitTime);
                    }
                    IcCubeErrorPrintJobResult icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, "timeout after " + timeout + " seconds");
                    OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") completed"));
                    return icCubeErrorPrintJobResult;
                }
                if (job.getAttachmentType() != AlertAttachmentType.WIDGET) break block21;
                byte[] content = this.exportWidgetData(session, startMS, job);
                String contentType = !"csv".equals(job.getWidgetFormat()) ? "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" : "text/csv";
                String widgetFileName = job.getWidgetFileName();
                OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") print (widget) job finished in server [" + widgetFileName + "]"));
                IcCubeChromePrintJobResult icCubeChromePrintJobResult2 = new IcCubeChromePrintJobResult(job, contentType, content, widgetFileName);
                OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") completed"));
                return icCubeChromePrintJobResult2;
            }
            try {
                byte[] content = IcCubeChromePrintService.printToPDF(session, job, commandLine);
                String contentType = "application/pdf";
                String pdfName = job.getPdfName();
                OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") print (pdf) job finished in server [" + pdfName + "]"));
                icCubeChromePrintJobResult = new IcCubeChromePrintJobResult(job, "application/pdf", content, pdfName);
            }
            catch (LoadTimeoutException ex) {
                IcCubeErrorPrintJobResult icCubeErrorPrintJobResult;
                block22: {
                    String message = "[printing] WaitDocReady: timeout after " + timeout + " seconds [" + ex.getMessage() + "]";
                    OlapLoggers.PRINT.info((Object)message);
                    icCubeErrorPrintJobResult = new IcCubeErrorPrintJobResult(job, "Error printing report : " + message);
                    OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") completed"));
                    if (session == null) break block22;
                    session.close();
                }
                return icCubeErrorPrintJobResult;
                {
                    catch (Throwable throwable) {
                        OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") completed"));
                        throw throwable;
                    }
                }
            }
            OlapLoggers.PRINT_CONSOLE.warn((Object)("[printing] job (" + job.getUuid() + ") completed"));
            return icCubeChromePrintJobResult;
        }
    }

    private void enableLogs(Session session, IcCubePrintJob job) {
        session.getCommand().getLog().enable();
        session.getCommand().getRuntime().enable();
        String uuid = job.getUuid();
        session.addEventListener((e, value) -> {
            String v;
            if (Events.LogEntryAdded.equals((Object)e)) {
                EntryAdded entryAdded = (EntryAdded)value;
                LogEntry entry = entryAdded.getEntry();
                String level = entry.getLevel().toString().toUpperCase(Locale.ENGLISH);
                v = String.format("[%s] [%s] %s %s", entry.getSource(), level, entry.getText(), Objects.toString(entry.getUrl(), ""));
                switch (entry.getLevel()) {
                    case Error: {
                        OlapLoggers.PRINT_CONSOLE.error((Object)("[" + uuid + "] Chrome log. console: " + v));
                        break;
                    }
                    case Warning: {
                        OlapLoggers.PRINT_CONSOLE.warn((Object)("[" + uuid + "] Chrome log. console: " + v));
                        break;
                    }
                    default: {
                        OlapLoggers.PRINT_CONSOLE.info((Object)("[" + uuid + "] Chrome log. console: " + v));
                    }
                }
            }
            if (Events.RuntimeConsoleAPICalled.equals((Object)e)) {
                ConsoleAPICalled ca = (ConsoleAPICalled)value;
                String type = ca.getType().toString().toUpperCase(Locale.ENGLISH);
                block9: for (RemoteObject next : ca.getArgs()) {
                    Object val = next.getValue();
                    String v2 = String.format("[%s] %s %s", type, Objects.toString(next.getDescription(), ""), Objects.toString(val, ""));
                    switch (ca.getType()) {
                        case Error: {
                            OlapLoggers.PRINT_CONSOLE.error((Object)("[" + uuid + "] Chrome runtime. console: " + v2));
                            continue block9;
                        }
                        case Warning: {
                            OlapLoggers.PRINT_CONSOLE.warn((Object)("[" + uuid + "] Chrome runtime. console: " + v2));
                            continue block9;
                        }
                        default: {
                            OlapLoggers.PRINT_CONSOLE.info((Object)("[" + uuid + "] Chrome runtime. console: " + v2));
                            continue block9;
                        }
                        case Debug: 
                        case Trace: 
                    }
                    OlapLoggers.PRINT_CONSOLE.debug((Object)("[" + uuid + "] Chrome runtime. console: " + v2));
                }
            }
            if (Events.RuntimeExceptionThrown.equals((Object)e)) {
                ExceptionThrown eT = (ExceptionThrown)value;
                ExceptionDetails details = eT.getExceptionDetails();
                String msg = details != null ? details.getText() : "";
                v = String.format("[ERROR] unhandled exception %s", Objects.toString(msg, ""));
                OlapLoggers.PRINT_CONSOLE.error((Object)("[" + uuid + "] Chrome runtime. console: " + v));
            }
        });
    }

    private boolean safeCompareVariable(Session session, String name) {
        try {
            return "ic3reportRendered:true".equalsIgnoreCase((String)session.getVariable(name, String.class));
        }
        catch (NullPointerException ex) {
            OlapLoggers.PRINT.warn((Object)("[printing] Could not access " + name + " variable (NPE)"), (Throwable)ex);
            return false;
        }
        catch (CdpReadTimeoutException timeout) {
            OlapLoggers.PRINT.warn((Object)("[printing] Could not access " + name + " variable (timeout)"), (Throwable)timeout);
            throw timeout;
        }
        catch (CdpException ex) {
            String error = ex.getMessage();
            if (error != null && error.endsWith("is not defined")) {
                OlapLoggers.PRINT.warn((Object)("[printing] Could not access " + name + " variable (not defined)"));
                return false;
            }
            OlapLoggers.PRINT.warn((Object)("[printing] Could not access " + name + " variable (exception)"), (Throwable)ex);
            return false;
        }
    }

    private byte[] exportWidgetData(Session session, long startMS, IcCubePrintJob job) {
        File folder;
        int timeout = job.getTimeout();
        int waitPeriodMS = job.getWaitPeriodMS();
        try {
            CdVFileSystem vfs = this.directories.getVfs();
            folder = vfs.createTmpDirectory(CdVFileSystemTmpReason.CHROME_EXPORT_WIDGET, this.directories.getTmpDirectory__());
        }
        catch (IOException ex) {
            OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") could not create export widget tmp. folder"), (Throwable)ex);
            throw new RuntimeException("could not create export widget tmp. folder : " + ex.getMessage());
        }
        try {
            String widgetId = job.getWidgetId();
            String format = job.getWidgetFormat();
            AtomicReference downloadedState = new AtomicReference();
            AtomicReference downloadedFileName = new AtomicReference();
            OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") generating the WIDGET data [" + widgetId + "][" + format + "] into [" + folder.getAbsolutePath() + "]"));
            session.addEventListener((event, value) -> {
                if (Events.BrowserDownloadWillBegin.equals((Object)event)) {
                    DownloadWillBegin dwb = (DownloadWillBegin)value;
                    String filename = dwb.getSuggestedFilename();
                    OlapLoggers.PRINT.debug((Object)("[printing] on-event : " + String.valueOf(event) + " [filename:" + filename + "]"));
                    downloadedFileName.set(filename);
                } else if (Events.BrowserDownloadProgress.equals((Object)event)) {
                    DownloadProgress dp = (DownloadProgress)value;
                    DownloadState state = dp.getState();
                    OlapLoggers.PRINT.debug((Object)("[printing] on-event : " + String.valueOf(event) + " " + String.valueOf(state)));
                    if (DownloadState.Completed.equals((Object)state) || DownloadState.Canceled.equals((Object)state)) {
                        downloadedState.set(state);
                    }
                }
            });
            Browser browser = session.getCommand().getBrowser();
            String browserContextId = session.getBrowserContextId();
            browser.setDownloadBehavior(DownloadBehavior.Allow, browserContextId, folder.getAbsolutePath(), Boolean.valueOf(true));
            String res = (String)session.callFunction("ic3.export.toExcel", String.class, new Object[]{widgetId, format});
            OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") generating the WIDGET data [" + res + "] notified"));
            int timeoutMS = 1000 * timeout;
            int remainingTimeoutMS = Math.max(waitPeriodMS, timeoutMS - (int)(System.currentTimeMillis() - startMS));
            session.waitUntil(s -> downloadedState.get() != null, remainingTimeoutMS, waitPeriodMS, true);
            DownloadState gotIt = (DownloadState)downloadedState.get();
            if (DownloadState.Completed.equals((Object)gotIt)) {
                byte[] data;
                String fileName = (String)downloadedFileName.get();
                if (CdStringUtils.isNullOrBlank((String)fileName)) {
                    OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") unexpected missing WIDGET filename"));
                    throw new RuntimeException("unexpected missing WIDGET filename");
                }
                File downloaded = new File(folder, fileName);
                if (!downloaded.exists()) {
                    OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") unexpected missing WIDGET file [" + downloaded.getAbsolutePath() + "]"));
                    throw new RuntimeException("unexpected missing WIDGET file [" + downloaded.getName() + "]");
                }
                OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") generating the WIDGET data [" + res + "] completed"));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (FileInputStream in = new FileInputStream(downloaded);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (IOException ex) {
                    OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") unexpected WIDGET data copy error"), (Throwable)ex);
                    throw new RuntimeException("unexpected WIDGET data copy error : " + ex.getMessage());
                }
                byte[] byArray = data = out.toByteArray();
                return byArray;
            }
            OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") unexpected WIDGET status [" + String.valueOf(gotIt) + "]"));
            throw new RuntimeException("unexpected WIDGET status [" + String.valueOf(gotIt) + "]");
        }
        finally {
            CdVFileSystemUtils.deleteQuietly((File)folder);
        }
    }

    private static byte[] printToPDF(Session session, IcCubePrintJob job, IcCubePrintJobCommandLine commandLine) {
        Double scale = null;
        Double paperWidth = commandLine.paperWidthInches();
        Double paperHeight = commandLine.paperHeightInches();
        Double marginTop = null;
        Double marginBottom = null;
        Double marginLeft = null;
        Double marginRight = null;
        Page page = session.getCommand().getPage();
        OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") generating the PDF data"));
        TransferMode transferMode = TransferMode.ReturnAsStream;
        PrintToPDFResult pdfResult = page.printToPDF(null, null, Boolean.valueOf(true), scale, paperWidth, paperHeight, marginTop, marginBottom, marginLeft, marginRight, null, null, null, null, transferMode);
        byte[] pdf = IcCubeChromePrintService.decodePDFstream(session, job, pdfResult);
        return pdf;
    }

    private static byte[] decodePDFstream(Session session, IcCubePrintJob job, PrintToPDFResult pdfResult) {
        OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") PDF decoding stream"));
        try {
            ReadResult pdfRead;
            IO io = session.getCommand().getIO();
            String pdfStream = pdfResult.getStream();
            int offset = 0;
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            do {
                byte[] decode;
                pdfRead = io.read(pdfStream, Integer.valueOf(offset), Integer.valueOf(0x100000));
                String pdfData = pdfRead.getData();
                OlapLoggers.PRINT.info((Object)("[printing] job (" + job.getUuid() + ") PDF decoding stream: Base64 data [" + pdfData.length() + "]"));
                if (pdfRead.getBase64Encoded() == Boolean.TRUE) {
                    decode = Base64.getDecoder().decode(pdfData);
                    offset += decode.length;
                    fos.write(decode);
                    continue;
                }
                decode = pdfData.getBytes(StandardCharsets.UTF_8);
                offset += decode.length;
                fos.write(decode);
            } while (pdfRead.getEof() != Boolean.TRUE);
            io.close(pdfStream);
            return fos.toByteArray();
        }
        catch (IOException ex) {
            OlapLoggers.PRINT.error((Object)("[printing] job (" + job.getUuid() + ") PDF decoding stream error"), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void onExecutePrintJobFinally(IcCubePrintJob job) {
        this.removeExecutingJob(job);
    }
}

