/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobCommandLine;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.IcCubePrintServletHttpSession;
import crazydev.iccube.server.scheduler.definition.AlertAttachmentType;
import jakarta.servlet.http.HttpSession;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public abstract class IcCubePrintJob {
    protected final String uuid = UUID.randomUUID().toString();
    protected final IcCubePrintServletHttpSession requestingPrincipalHttpSession;
    protected final IcCubePrintJobCommandLine commandLine;
    private final long startTimeMS = System.currentTimeMillis();
    private final OlapPrincipal requestingPrincipal;
    @Nullable
    private final String rootVersion;
    private final int timeout;
    private final int waitPeriodMS;
    private final AtomicReference<Process> printingProcess = new AtomicReference();
    private final AtomicBoolean markedAsExpired = new AtomicBoolean(false);
    private final AtomicReference<HttpSession> session = new AtomicReference();
    private String requestUUID;

    public IcCubePrintJob(IcCubePrintService printService, String requestUUID, OlapPrincipal requestingPrincipal, @Nullable String rootVersion, int timeout, IcCubePrintJobCommandLine commandLine) {
        this.requestUUID = requestUUID;
        this.requestingPrincipal = requestingPrincipal;
        this.requestingPrincipalHttpSession = new IcCubePrintServletHttpSession(requestingPrincipal);
        this.rootVersion = rootVersion;
        this.timeout = printService.setupTimeout(timeout);
        this.waitPeriodMS = printService.configuration.getWaitPeriodMS();
        this.commandLine = commandLine;
        OlapTenant tenant = requestingPrincipal.getTenant();
        String userName = requestingPrincipal.getName();
        String tenantName = tenant != null ? tenant.getName() : "none";
        OlapLoggers.PRINT.info((Object)("[printing] create job (" + this.uuid + ") (user:" + userName + ") (tenant:" + tenantName + ")"));
    }

    public void attachHttpSession(HttpSession session) {
        this.session.set(session);
    }

    @Nullable
    public HttpSession getHttpSession() {
        return this.session.get();
    }

    public boolean isMF() {
        return this.commandLine.isMF();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getRequestUUID() {
        return this.requestUUID;
    }

    public String getCSRFToken() {
        return this.requestingPrincipal.getCSRFToken();
    }

    public long getStartTimeMS() {
        return this.startTimeMS;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getWaitPeriodMS() {
        return this.waitPeriodMS;
    }

    public boolean isInBrowser() {
        return false;
    }

    public abstract String getChromeNavigateURL(String var1);

    public String getPdfName() {
        return "ic3report-" + this.uuid + ".pdf";
    }

    public AlertAttachmentType getAttachmentType() {
        return AlertAttachmentType.PDF;
    }

    @Nullable
    public String getWidgetId() {
        return null;
    }

    @Nullable
    public String getWidgetFormat() {
        return null;
    }

    @Nullable
    public String getWidgetFileName() {
        return null;
    }

    public OlapPrincipal getRequestingPrincipal() {
        return this.requestingPrincipal;
    }

    public IcCubePrintServletHttpSession getRequestingPrincipalHttpSession() {
        return this.requestingPrincipalHttpSession;
    }

    public String processBodySize(String html) {
        return this.commandLine.processBodySize(html);
    }

    public IcCubePrintJobCommandLine getCommandLine() {
        return this.commandLine;
    }

    public String toString() {
        return "[" + this.uuid + "]";
    }
}

