/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.print;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.server.gvi.request.common.GviGenericErrorResponse;
import crazydev.iccube.server.gvi.request.common.GviResponse;
import crazydev.iccube.server.gvi.request.common.errors.GviError;
import crazydev.iccube.server.gvi.request.common.errors.GviErrorCode;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class IcCubeErrorPrintJobResult
extends IcCubePrintJobResult {
    private final int httpErrorCode;
    private String error;

    public IcCubeErrorPrintJobResult(IcCubePrintJob job, String error) {
        this(job, -1, error);
    }

    public IcCubeErrorPrintJobResult(IcCubePrintJob job, int httpErrorCode, String error) {
        super(job);
        this.httpErrorCode = httpErrorCode;
        this.error = error;
    }

    @Override
    @Nullable
    public Serializable getAttachmentContent() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public byte[] getAttachmentContentEx() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public GviResponse getResponse() {
        GviErrorCode errorCode = this.httpErrorCode == 429 ? GviErrorCode.PRINT_ERROR_429 : GviErrorCode.PRINT_ERROR;
        return new GviGenericErrorResponse(new GviError(errorCode, new Serializable[]{this.error}));
    }

    @Override
    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    @Override
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    public boolean isInError() {
        return true;
    }
}

