/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.gwt;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.utils.CdExceptionUtils;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.gwt.base.shared.comm.GwtCancelledReply;
import crazydev.iccube.gwt.base.shared.comm.GwtExpectedExceptionReply;
import crazydev.iccube.gwt.base.shared.comm.GwtExpectedServerException;
import crazydev.iccube.gwt.base.shared.comm.GwtReply;
import crazydev.iccube.gwt.base.shared.comm.request.GwtQuery;
import crazydev.iccube.gwt.base.shared.model.GwtInfo;
import crazydev.iccube.gwt.shared.common.model.UnexpectedExceptionReply;
import crazydev.iccube.gwt.shared.portlets.builder.exceptions.AuthorizationExpectedServerException;
import crazydev.iccube.gwt.shared.portlets.common.command.GwtAbstractMdxQuery;
import crazydev.iccube.gwt.shared.portlets.qeditor.model.MdxQueryErrorResult;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.context.IcCubeServerSessionException;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.processor.common.IcCubeRequestProcessor;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequest;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestContext;
import crazydev.iccube.server.request.request.gwt.IcCubeGwtServerRequestReply;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class IcCubeGwtRequestProcessor
extends IcCubeRequestProcessor<GwtReply<? extends GwtInfo>, IcCubeGwtServerRequest, IcCubeGwtServerRequestReply, IcCubeGwtServerRequestContext> {
    public IcCubeGwtRequestProcessor(IcCubeServerTaskExecutor taskExecutor, IcCubeRequestStatusManager statusManager) {
        super(taskExecutor, statusManager);
    }

    private IcCubeGwtServerRequestContext setupRequestContext(HttpServletRequest httpRequest, IcCubeGwtServerRequest request) {
        IcCubeServerSessionContext sessionContext = IcCubeServerSessionContext.getOrCreateSessionContext(httpRequest);
        return new IcCubeGwtServerRequestContext(sessionContext, request);
    }

    public GwtReply<? extends GwtInfo> processGwtRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse, GwtQuery gwtRequest) {
        IcCubeGwtServerRequest request = null;
        try {
            OlapRequestId requestId = OlapRequestId.getThreadRequestId((String)gwtRequest.getClientUUID());
            request = new IcCubeGwtServerRequest(requestId, gwtRequest);
            IcCubeGwtServerRequestContext requestContext = this.setupRequestContext(httpRequest, request);
            GwtReply reply = (GwtReply)this.processXyzRequest(requestContext, request);
            return reply;
        }
        catch (IcCubeServerSessionException unexpected) {
            if (request != null) {
                return this.createExpectedExceptionResponse(request, unexpected);
            }
            return this.createUnexpectedExceptionResponse(gwtRequest, (Throwable)((Object)unexpected));
        }
        catch (RuntimeException unexpected) {
            return this.createUnexpectedExceptionResponse(gwtRequest, (Throwable)unexpected);
        }
    }

    @Override
    protected GwtReply<? extends GwtInfo> createSuccessResponse(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request, IcCubeGwtServerRequestReply reply) {
        GwtInfo response = reply.getResponse();
        if (response == null) {
            throw new CdProgrammingException("internal error: reply inconsistency");
        }
        return new GwtReply<GwtInfo>(request.getGwtQuery(), response);
    }

    @Override
    protected GwtReply<? extends GwtInfo> createCancelledResponse(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request, boolean onTimeout, @Nullable String extraInfo) {
        GwtQuery query = request.getGwtQuery();
        if (query instanceof GwtAbstractMdxQuery) {
            GwtAbstractMdxQuery aQuery = (GwtAbstractMdxQuery)query;
            OlapBabylonService babylon = requestContext.getBabylonService();
            CdMdxErrorCode errorCode = !onTimeout ? CdMdxErrorCode.CANCELLED : CdMdxErrorCode.TIMEOUT;
            MdxQueryErrorResult response = new MdxQueryErrorResult(request.getSchema(), aQuery.getQueryId(), errorCode.getValue(), errorCode.asMessage((CdBabylonService)babylon, new Serializable[0]), null);
            return new GwtReply<MdxQueryErrorResult>(request.getGwtQuery(), response);
        }
        return new GwtCancelledReply(request.getGwtQuery());
    }

    @Override
    protected GwtReply<? extends GwtInfo> createExceptionResponseEx(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request, Throwable exception) {
        if (exception instanceof OlapRoleAuthorizationRuntimeException) {
            return this.createNotAuthorizedResponse(requestContext, request, (OlapRoleAuthorizationRuntimeException)exception);
        }
        if (exception instanceof OlapRoleAuthorizationException) {
            return this.createNotAuthorizedResponse(requestContext, request, (OlapRoleAuthorizationException)exception);
        }
        if (exception instanceof GwtExpectedServerException) {
            return this.createExpectedExceptionResponse(request, (GwtExpectedServerException)exception);
        }
        return this.createUnexpectedExceptionResponse(request, exception);
    }

    private GwtReply<? extends GwtInfo> createNotAuthorizedResponse(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request, OlapRoleAuthorizationRuntimeException exception) {
        OlapLoggers.GWT_REQUEST.error((Object)(request.getLoggerInfo() + " : not authorized"), (Throwable)exception);
        OlapBabylonService babylon = requestContext.getBabylonService();
        CdError error = exception.getError();
        return new GwtExpectedExceptionReply(request.getGwtQuery(), new AuthorizationExpectedServerException(null, error.toString(), error.asMessage((CdBabylonService)babylon)));
    }

    private GwtReply<? extends GwtInfo> createNotAuthorizedResponse(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request, OlapRoleAuthorizationException exception) {
        OlapLoggers.GWT_REQUEST.error((Object)(request.getLoggerInfo() + " : not authorized"), (Throwable)exception);
        OlapBabylonService babylon = requestContext.getBabylonService();
        CdError error = exception.getError();
        return new GwtExpectedExceptionReply(request.getGwtQuery(), new AuthorizationExpectedServerException(null, error.toString(), error.asMessage((CdBabylonService)babylon)));
    }

    private GwtReply<? extends GwtInfo> createExpectedExceptionResponse(IcCubeGwtServerRequest request, IcCubeServerSessionException exception) {
        OlapLoggers.GWT_REQUEST.error((Object)(request.getLoggerInfo() + " : processing error"), (Throwable)((Object)exception));
        return new GwtExpectedExceptionReply(request.getGwtQuery(), exception.getLocalizedMessage());
    }

    private GwtReply<? extends GwtInfo> createExpectedExceptionResponse(IcCubeGwtServerRequest request, GwtExpectedServerException exception) {
        OlapLoggers.GWT_REQUEST.error((Object)(request.getLoggerInfo() + " : processing error"), (Throwable)exception);
        return new GwtExpectedExceptionReply(request.getGwtQuery(), exception);
    }

    private GwtReply<? extends GwtInfo> createUnexpectedExceptionResponse(IcCubeGwtServerRequest request, Throwable unexpected) {
        OlapLoggers.GWT_REQUEST.error((Object)(request.getLoggerInfo() + " : unexpected processing error"), unexpected);
        return new UnexpectedExceptionReply(request.getGwtQuery(), CdExceptionUtils.getStackTraceAsString((Throwable)unexpected));
    }

    private GwtReply<? extends GwtInfo> createUnexpectedExceptionResponse(GwtQuery request, Throwable unexpected) {
        OlapLoggers.GWT_REQUEST.error((Object)("GWT request [" + request.getClass().getSimpleName() + "] : unexpected processing error"), unexpected);
        return new UnexpectedExceptionReply(request, CdExceptionUtils.getStackTraceAsString((Throwable)unexpected));
    }

    @Override
    protected GwtReply<? extends GwtInfo> createMissingReplyResponse(IcCubeGwtServerRequestContext requestContext, IcCubeGwtServerRequest request) {
        return new UnexpectedExceptionReply(request.getGwtQuery(), "unexpected missing request reply");
    }
}

