/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.processor.cache;

import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.pub.principal.OlapInternalPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.processor.cache.IcCubeMdxResultCacheException;
import crazydev.iccube.server.request.processor.cache.OlapEngineMdxResultCacheSessionContext;
import java.util.Locale;
import java.util.UUID;

public abstract class IcCubeMdxResultCacheInfo {
    private final OlapResultCacheKey cacheKey;

    public IcCubeMdxResultCacheInfo(OlapResultCacheKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    public String getSchemaName() {
        return this.cacheKey.getSchemaName();
    }

    public OlapSchema getSchema() {
        return this.cacheKey.getSchema();
    }

    public IcCubeServerSessionContext setupServerSessionContext(IcCubeServerApplicationContext applicationContext) {
        String sessionId = UUID.randomUUID().toString();
        OlapEngineApplicationContext engineApplicationContext = applicationContext.getOlapEngineApplicationContext();
        String roleName = this.cacheKey.getRoleName();
        Locale locale = this.cacheKey.getLocale();
        OlapInternalPrincipal principal = new OlapInternalPrincipal("mdx-cache-user", roleName, locale);
        boolean sessionLess = false;
        OlapEngineMdxResultCacheSessionContext engineSessionContext = new OlapEngineMdxResultCacheSessionContext(engineApplicationContext, false, sessionId, (OlapPrincipal)principal);
        return new IcCubeServerSessionContext(applicationContext, null, sessionId, engineSessionContext);
    }

    public final void execute(IcCubeServerApplicationContext applicationContext) {
        try {
            this.unsafeExecute(applicationContext);
        }
        catch (RuntimeException ex) {
            throw new IcCubeMdxResultCacheException("MDX result cache rebuild : failed to execute the request", ex);
        }
    }

    protected abstract void unsafeExecute(IcCubeServerApplicationContext var1);
}

