/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.executor;

import crazydev.iccube.common.executor.IOlapThreadPoolExecutorFutureTask;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorFutureTaskQueue;
import crazydev.iccube.common.executor.OlapThreadFactory;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorServiceQueue;
import crazydev.iccube.server.request.executor.IcCubeServerTaskPriorityQueue;
import crazydev.iccube.server.request.executor.IcCubeServerTaskRunnable;
import crazydev.iccube.server.request.executor.IcCubeServerTaskRunnableFuture;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class IcCubeServerTaskExecutorService
extends ThreadPoolExecutor {
    public IcCubeServerTaskExecutorService(int threadCount) {
        super(Math.max(1, threadCount), threadCount, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new OlapThreadPoolExecutorServiceQueue((IOlapThreadPoolExecutorFutureTaskQueue)new IcCubeServerTaskPriorityQueue()), (ThreadFactory)new OlapThreadFactory("schema-task"));
    }

    public int getQueuedTaskCount() {
        return this.getQueue().size();
    }

    public int getMaxThreadCount() {
        return this.getMaximumPoolSize();
    }

    public int getActiveThreadCount() {
        return this.getActiveCount();
    }

    public void freezeForSchema(Logger logger, String reqUUID, String schema) {
        OlapThreadPoolExecutorServiceQueue queue = (OlapThreadPoolExecutorServiceQueue)this.getQueue();
        queue.freezeForSchema(logger, reqUUID, schema);
    }

    public void unfreezeForSchema(Logger logger, String reqUUID, String schema) {
        OlapThreadPoolExecutorServiceQueue queue = (OlapThreadPoolExecutorServiceQueue)this.getQueue();
        queue.unfreezeForSchema(logger, reqUUID, schema);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        IcCubeServerTaskRunnable r = (IcCubeServerTaskRunnable)runnable;
        return new IcCubeServerTaskRunnableFuture<T>(r, value);
    }

    @Override
    public void execute(Runnable command) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Task " + command.toString() + " rejected from " + this.toString());
        }
        IcCubeServerTaskRunnableFuture task = (IcCubeServerTaskRunnableFuture)command;
        if (!this.getQueue().offer(task)) {
            throw new RejectedExecutionException("Task " + command.toString() + " rejected from " + this.toString());
        }
        if (this.isShutdown() && this.remove(task)) {
            task.cancel(false);
        } else {
            this.prestartAllCoreThreads();
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        IcCubeServerTaskRunnableFuture future = (IcCubeServerTaskRunnableFuture)r;
        OlapThreadPoolExecutorServiceQueue queue = (OlapThreadPoolExecutorServiceQueue)this.getQueue();
        queue.onAfterExecute((IOlapThreadPoolExecutorFutureTask)future);
    }
}

