/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.request.executor;

import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.olap.executor.IOlapExecutor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import crazydev.iccube.request.task.IcCubeTask;
import crazydev.iccube.server.request.executor.IcCubeServerSameThreadExecutorService;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutorService;
import crazydev.iccube.server.request.executor.IcCubeServerTaskRunnable;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;

public class IcCubeServerTaskExecutor
implements IOlapExecutor {
    private final IcCubeServerTaskExecutorService schemaTaskExecutorService;
    private final IcCubeServerSameThreadExecutorService defaultExecutorService;
    private final IcCubeRequestStatusManager statusManager;

    public IcCubeServerTaskExecutor(OlapEngineComponentConfiguration olapEngineConfiguration, IcCubeRequestStatusManager statusManager) {
        this(statusManager, olapEngineConfiguration.getProperties().getOlapEngineSimultaneousRequestCount());
    }

    public IcCubeServerTaskExecutor(IcCubeRequestStatusManager statusManager, int schemaTaskExecutorThreadCount) {
        this.statusManager = statusManager;
        this.schemaTaskExecutorService = new IcCubeServerTaskExecutorService(schemaTaskExecutorThreadCount);
        this.defaultExecutorService = new IcCubeServerSameThreadExecutorService();
    }

    public int getQueuedTaskCount() {
        return this.schemaTaskExecutorService.getQueuedTaskCount();
    }

    public int getMaxThreadCount() {
        return this.schemaTaskExecutorService.getMaxThreadCount();
    }

    public int getActiveThreadCount() {
        return this.schemaTaskExecutorService.getActiveThreadCount();
    }

    public void freezeForSchema(Logger logger, String reqUUID, String schema) {
        this.schemaTaskExecutorService.freezeForSchema(logger, reqUUID, schema);
    }

    public void unfreezeForSchema(Logger logger, String reqUUID, String schema) {
        this.schemaTaskExecutorService.unfreezeForSchema(logger, reqUUID, schema);
    }

    public void shutdownNow() {
        OlapLoggers.GENERAL.info((Object)"[TASK] shutdown requested");
        this.schemaTaskExecutorService.shutdownNow();
        this.defaultExecutorService.shutdownNow();
        OlapLoggers.GENERAL.info((Object)"[TASK] bye");
    }

    public Future submit(IcCubeServerTask task) throws RejectedExecutionException {
        Future<?> completion;
        IcCubeServerTaskRunnable runnable = new IcCubeServerTaskRunnable(task);
        IcCubeSchemaAccessLock lock = task.getLock();
        if (lock != null) {
            completion = this.schemaTaskExecutorService.submit(runnable);
            this.statusManager.onRequestTaskSubmitted((IcCubeTask)task, completion);
        } else {
            completion = this.defaultExecutorService.submit(this.statusManager, task, runnable);
        }
        return completion;
    }
}

