/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository.fs;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsPermissions;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsProfile;
import crazydev.iccube.common.lock.DirectoryLock;
import crazydev.iccube.common.lock.DirectoryLockException;
import crazydev.iccube.common.lock.ExclusiveDirectoryLock;
import crazydev.iccube.common.lock.NoneDirectoryLock;
import crazydev.iccube.directories.OlapClusterConfiguration;
import crazydev.iccube.exception.OlapTunneledExceptionR;
import crazydev.iccube.fs.OlapAttachment;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDoc;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsDocFile;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.server.repository.Binary;
import crazydev.iccube.server.repository.NodeMeta;
import crazydev.iccube.server.repository.PathNotFoundException;
import crazydev.iccube.server.repository.Repository;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.fs.FileBinary;
import crazydev.iccube.server.repository.fs.FileMeta;
import crazydev.iccube.server.repository.fs.FileNode;
import crazydev.iccube.server.repository.fs.FileNodeIterator;
import crazydev.iccube.server.repository.fs.FileNodeIteratorEmpty;
import crazydev.iccube.server.repository.fs.FileNodeIteratorNIO;
import crazydev.iccube.server.repository.fs.FilePathUtils;
import crazydev.iccube.server.repository.fs.FileRepositoryEmpty;
import crazydev.iccube.server.repository.fs.FileRepositoryTenantRootException;
import crazydev.iccube.server.repository.fs.FileSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class FileRepository
extends Repository<FileSession, FileNode> {
    public static final OlapPathEntry FILE_REPOSITORY_LOCK_NAME = OlapPathEntry.create((String)".lock");
    public static final String ICC_META = ".icc-meta";
    public static final OlapPathEntry META_FILE_EXTENSION = OlapPathEntry.create((String)".icc-meta");
    protected final OlapFileSystem fs;
    private final DirectoryLock repositoryLock;
    private final ReadWriteLock accessLock = new ReentrantReadWriteLock();
    private final boolean isDocs;
    private boolean shutdown;

    private FileRepository(CdVFileSystem vfs, boolean exclusive, OlapDocsMimeTypes mimeTypes, File root, boolean isDocs) throws DirectoryLockException {
        super(mimeTypes);
        this.fs = OlapFileSystem.createFileSystem((CdVFileSystem)vfs, (File)root);
        this.shutdown = false;
        OlapLoggers.DOC_REPOSITORY.info((Object)("[docs] starting the docs (file) repository [exclusive:" + exclusive + "] [" + root.getAbsolutePath() + "]"));
        this.repositoryLock = exclusive ? new ExclusiveDirectoryLock("docs", root) : new NoneDirectoryLock("docs");
        this.repositoryLock.acquire();
        this.isDocs = isDocs;
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] docs (file) repository started");
    }

    private FileRepository(OlapDocsMimeTypes mimeTypes, OlapFileSystem fs, boolean isDocs) throws DirectoryLockException {
        super(mimeTypes);
        this.fs = fs;
        this.shutdown = false;
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] starting the docs (file) repository [file-system]");
        this.repositoryLock = new NoneDirectoryLock("docs");
        this.repositoryLock.acquire();
        this.isDocs = isDocs;
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] docs (file) repository started");
    }

    protected FileRepository(CdVFileSystem vfs, OlapDocsMimeTypes mimeTypes, boolean isDocs) {
        super(mimeTypes);
        this.fs = OlapFileSystem.createFileSystem((CdVFileSystem)vfs, null);
        this.shutdown = false;
        this.repositoryLock = new NoneDirectoryLock("docs");
        this.isDocs = isDocs;
    }

    @Override
    protected File createTmpFileForDownload(File tmpDirectory, String extension) throws IOException {
        return this.fs.createTmpFileForDownload(tmpDirectory, extension);
    }

    @Override
    public File createTmpFileForUpload(File tmpDirectory, String extension) throws IOException {
        return this.fs.createTmpFileForUpload(tmpDirectory, extension);
    }

    @Override
    public boolean isDocs() {
        return this.isDocs;
    }

    @Override
    public void forEachNode(FileSession session, FileNode root, Consumer<FileNode> consumer) throws RepositoryException {
        if (!this.isDocs) {
            return;
        }
        try {
            root.processAllFiles(entry -> true, file -> {
                String path = this.fs.getPath(file.path.toFile());
                OlapFile node = this.fs.create(path);
                consumer.accept(new FileNode(session, node));
            });
        }
        catch (OlapTunneledExceptionR ex) {
            throw new RepositoryException("file repository IO error : " + ex.getActual().getMessage(), ex.getActual());
        }
        catch (IOException ex) {
            throw new RepositoryException("file repository IO error : " + ex.getMessage(), ex);
        }
    }

    @Override
    public String getAllPermissions(FileSession session) throws RepositoryException {
        if (!this.isDocs) {
            return "";
        }
        try {
            FileNode root = this.getRootNode(session);
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder sb = new StringBuilder();
            root.processAllFiles(entry -> {
                File file = entry.toFile();
                boolean accepted = file.isDirectory() || file.getName().endsWith(ICC_META);
                return accepted;
            }, file -> {
                if (!Files.isDirectory(file.path, new LinkOption[0])) {
                    Object scope;
                    File file_ = file.path.toFile();
                    String name = file_.getName();
                    if (name.equals(ICC_META)) {
                        scope = this.fs.getPath(file_.getParentFile());
                    } else {
                        scope = this.fs.getPath(file_);
                        scope = ((String)scope).substring(0, ((String)scope).length() - ICC_META.length());
                    }
                    if (!((String)scope).startsWith("/")) {
                        scope = "/" + (String)scope;
                    }
                    try {
                        List lines = file.fs.readAllLines(file_);
                        FileMeta meta = FileMeta.restore(lines);
                        meta.dumpForGetAllPermissions(sb, (String)scope, lineSeparator);
                    }
                    catch (IOException ex) {
                        throw new OlapTunneledExceptionR((Exception)ex);
                    }
                }
            });
            return sb.toString();
        }
        catch (OlapTunneledExceptionR ex) {
            throw new RepositoryException("file repository IO error : " + ex.getActual().getMessage(), ex.getActual());
        }
        catch (IOException ex) {
            throw new RepositoryException("file repository IO error : " + ex.getMessage(), ex);
        }
    }

    public static FileRepository create(CdVFileSystem vfs, OlapClusterConfiguration cluster, OlapDocsMimeTypes mimeTypes, File location, boolean isDocs) throws RepositoryException {
        boolean exclusive = !cluster.isActive();
        return FileRepository.create(vfs, exclusive, mimeTypes, location, isDocs);
    }

    public static FileRepository create(CdVFileSystem vfs, boolean exclusive, OlapDocsMimeTypes mimeTypes, File location, boolean isDocs) throws RepositoryException {
        if (location == null) {
            throw new RuntimeException("Missing docs (file) repository location");
        }
        if (!location.exists()) {
            throw new RuntimeException("The docs (file) repository location does not exist [" + location.getAbsolutePath() + "]");
        }
        if (!location.isDirectory()) {
            throw new RuntimeException("The docs (file) repository location is not a directory [" + location.getAbsolutePath() + "]");
        }
        try {
            return new FileRepository(vfs, exclusive, mimeTypes, location, isDocs);
        }
        catch (DirectoryLockException ex) {
            throw new RepositoryException("Could not start the docs (file) repository", ex);
        }
    }

    public static FileRepository create(OlapDocsMimeTypes mimeTypes, OlapFileSystem location, boolean isDocs) throws RepositoryException {
        try {
            return new FileRepository(mimeTypes, location, isDocs);
        }
        catch (DirectoryLockException ex) {
            throw new RepositoryException("Could not start the docs (file) repository", ex);
        }
    }

    public static FileRepository empty(CdVFileSystem vfs, OlapDocsMimeTypes mimeTypes) {
        return new FileRepositoryEmpty(vfs, mimeTypes);
    }

    @Override
    public void shutdown() {
        block6: {
            OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] shutting down the file repository");
            Lock lock = this.accessLock.writeLock();
            lock.lock();
            try {
                if (!this.shutdown) {
                    try {
                        this.repositoryLock.release();
                    }
                    catch (DirectoryLockException ex) {
                        OlapLoggers.DOC_REPOSITORY.error((Object)"[docs] failed to release the file repository lock");
                    }
                    this.shutdown = true;
                    break block6;
                }
                OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] nothing done (duplicated shutdown)");
            }
            finally {
                lock.unlock();
            }
        }
        OlapLoggers.DOC_REPOSITORY.info((Object)"[docs] file repository has been shutdown");
    }

    @Override
    public void logConfiguration() {
    }

    @Override
    public OlapPath root() {
        return OlapPath.ROOT;
    }

    @Override
    public FileSession login(String userName, String roleName, boolean readOnly, @Nullable OlapRoleFlatDocsProfile profile) throws RepositoryException {
        return new FileSession(this, readOnly, userName, roleName, profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OlapAttachment download(FileSession session, File tmpDirectory, OlapPath absPath, List<String> entries) throws RepositoryException, IOException {
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            OlapAttachment olapAttachment = super.download(session, tmpDirectory, absPath, entries);
            return olapAttachment;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAncestorOf(FileSession session, OlapPath absPath1, OlapPath absPath2) throws RepositoryException {
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            File possibleChild = new File(FilePathUtils.toFilePath(absPath2));
            File possibleParent = new File(FilePathUtils.toFilePath(absPath1));
            boolean bl = this.isChildOf(possibleChild, possibleParent);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeExists(FileSession session, OlapPath absPath) throws RepositoryException {
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            boolean exist;
            String filePath = FilePathUtils.toFilePath(absPath);
            OlapFile file = this.fs.create(filePath);
            boolean bl = exist = file.exists();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileNode getNode(FileSession session, OlapPath absPath) throws RepositoryException {
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            if (!this.nodeExists(session, absPath)) {
                if (this.fs.isTenantRootMissing()) {
                    throw new FileRepositoryTenantRootException();
                }
                throw new PathNotFoundException(absPath.toErrorPath());
            }
            OlapFile file = this.fs.create(FilePathUtils.toFilePath(absPath));
            FileNode fileNode = new FileNode(session, file);
            return fileNode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(FileSession session, OlapPath absPath) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            OlapFile file = this.fs.create(FilePathUtils.toFilePath(absPath));
            OlapFile metaFile = this.metaFile(file);
            boolean directoryOperation = file.isDirectory();
            if (!file.delete()) {
                throw new RepositoryException("Could not delete [" + String.valueOf(absPath) + "]");
            }
            if (!directoryOperation && metaFile != null && metaFile.exists() && !metaFile.delete()) {
                OlapLoggers.DOC_REPOSITORY.warn((Object)("[docs] could not remove meta-information [" + file.getPath() + "]"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(FileSession session, OlapPath srcAbsPath, OlapPath destAbsPath) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            OlapFile srcFile = this.fs.create(FilePathUtils.toFilePath(srcAbsPath));
            OlapFile destFile = this.fs.create(FilePathUtils.toFilePath(destAbsPath));
            if (!srcFile.exists()) {
                return;
            }
            OlapFile srcMetaFile = this.metaFile(srcFile);
            boolean directoryOperation = srcFile.isDirectory();
            try {
                srcFile.move(destFile);
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not move [" + srcFile.getPath() + "] to [" + destFile.getPath() + "]", ex);
            }
            if (!directoryOperation) {
                OlapFile destMetaFile = this.metaFile(destFile);
                this.moveMeta(srcMetaFile, destMetaFile);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void moveMeta(@Nullable OlapFile srcMetaFile, @Nullable OlapFile destMetaFile) throws RepositoryException {
        if (srcMetaFile == null) {
            if (destMetaFile != null && destMetaFile.exists() && !CdVFileSystemUtils.deleteQuietly((File)destMetaFile.__getUnderlying())) {
                throw new RepositoryException("Could not delete meta-information [" + destMetaFile.getPath() + "]");
            }
            return;
        }
        if (destMetaFile == null) {
            throw new RepositoryException("Could not move meta-information [" + srcMetaFile.getPath() + "] to [null]");
        }
        if (destMetaFile.exists() && !CdVFileSystemUtils.deleteQuietly((File)destMetaFile.__getUnderlying())) {
            OlapLoggers.DOC_REPOSITORY.warn((Object)("[docs] could not delete meta-information [" + srcMetaFile.getPath() + "] [" + destMetaFile.getPath() + "]"));
        }
        if (srcMetaFile.exists()) {
            try {
                Files.move(srcMetaFile.__getUnderlying().toPath(), destMetaFile.__getUnderlying().toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not move meta-information [" + srcMetaFile.getPath() + "] to [" + destMetaFile.getPath() + "]", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(FileSession session, OlapPath srcAbsPath, OlapPath destAbsPath) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            OlapFile srcFile = this.fs.create(FilePathUtils.toFilePath(srcAbsPath));
            OlapFile destFile = this.fs.create(FilePathUtils.toFilePath(destAbsPath));
            if (!srcFile.exists()) {
                return;
            }
            boolean directoryOperation = srcFile.isDirectory();
            OlapFile srcMetaFile = this.metaFile(srcFile);
            try {
                Files.copy(srcFile.__getUnderlying().toPath(), destFile.__getUnderlying().toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not copy [" + String.valueOf(srcAbsPath) + "] to [" + String.valueOf(destAbsPath) + "]", ex);
            }
            if (!directoryOperation) {
                OlapFile destMetaFile = this.metaFile(destFile);
                this.copyMeta(srcMetaFile, destMetaFile);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void copyMeta(@Nullable OlapFile srcMetaFile, @Nullable OlapFile destMetaFile) throws RepositoryException {
        if (srcMetaFile == null) {
            if (destMetaFile != null && destMetaFile.exists() && !CdVFileSystemUtils.deleteQuietly((File)destMetaFile.__getUnderlying())) {
                throw new RepositoryException("Could not delete meta-information [" + destMetaFile.getPath() + "]");
            }
            return;
        }
        if (destMetaFile == null) {
            throw new RepositoryException("Could not copy meta-information [" + srcMetaFile.getPath() + "] to [null]");
        }
        if (destMetaFile.exists() && !CdVFileSystemUtils.deleteQuietly((File)destMetaFile.__getUnderlying())) {
            OlapLoggers.DOC_REPOSITORY.warn((Object)("[docs] could not delete meta-information [" + srcMetaFile.getPath() + "] [" + destMetaFile.getPath() + "]"));
        }
        if (srcMetaFile.exists()) {
            try {
                Files.copy(srcMetaFile.__getUnderlying().toPath(), destMetaFile.__getUnderlying().toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not copy meta-information [" + srcMetaFile.getPath() + "] to [" + destMetaFile.getPath() + "]", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public FileNode getParentX(FileSession session, FileNode node) throws RepositoryException {
        OlapPath nodePath = node.getPath();
        if (!nodePath.hasParent()) {
            return null;
        }
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            OlapFile file = node.file();
            OlapFile parent = file.getParentFile();
            if (parent == null) {
                FileNode fileNode = null;
                return fileNode;
            }
            if (!parent.exists()) {
                throw new PathNotFoundException("No parent for [" + String.valueOf(node.getPath()) + "]");
            }
            FileNode fileNode = new FileNode((FileSession)node.session(), parent);
            return fileNode;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isSame(FileSession session, FileNode node, FileNode other) throws RepositoryException {
        File nodeF = node.file().__getUnderlying();
        File otherF = other.file().__getUnderlying();
        return FileRepository.isSame(nodeF, otherF);
    }

    @Override
    public boolean isChildOf(FileSession session, FileNode node, FileNode other) throws RepositoryException {
        File possibleChild = node.file().__getUnderlying();
        File possibleParent = other.file().__getUnderlying();
        return this.isChildOf(possibleChild, possibleParent);
    }

    private boolean isChildOf(File possibleChild, File possibleParent) throws RepositoryException {
        for (File parent = possibleChild; parent != null; parent = parent.getParentFile()) {
            if (!FileRepository.isSame(parent, possibleParent)) continue;
            return true;
        }
        return possibleParent.getName().equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(FileSession session, FileNode node, OlapPath relPath) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            if (this.hasNode(session, node, relPath)) {
                this.delete(session, node.getPath().append(relPath));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileNodeIterator getChildNodes(FileSession session, FileNode node) throws RepositoryException {
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            FileNodeIterator nodes;
            FileNodeIterator fileNodeIterator = nodes = this.nodes(session, node);
            return fileNodeIterator;
        }
        finally {
            lock.unlock();
        }
    }

    private FileNodeIterator nodes(FileSession session, FileNode node) throws RepositoryException {
        DirectoryStream stream;
        OlapFile file = node.file();
        if (!file.exists() || file.isFile()) {
            return new FileNodeIteratorEmpty();
        }
        try {
            stream = file.createDirectoryStream(entry -> {
                String fileName = entry.toFile().getName();
                return !fileName.equals(FILE_REPOSITORY_LOCK_NAME.getName()) && !fileName.endsWith(META_FILE_EXTENSION.getName());
            });
        }
        catch (IOException ex) {
            throw new RepositoryException(ex);
        }
        return new FileNodeIteratorNIO(session, file, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileNode addDirectory(FileSession session, FileNode node, OlapPath name) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            OlapFile file = this.fs.create(node.file(), FilePathUtils.toFilePath(name));
            if (!file.mkdir()) {
                throw new RepositoryException("Could not add the directory [" + String.valueOf(node.getPath()) + "] [" + String.valueOf(name) + "]");
            }
            FileNode fileNode = new FileNode((FileSession)node.session(), file);
            return fileNode;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public FileNode addFile(FileSession session, FileNode node, OlapPath name, boolean applyInheritedPermissions, InputStream fileContent) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            OlapFile file = this.fs.create(node.file(), FilePathUtils.toFilePath(name));
            try {
                file.saveFile(fileContent);
                this.updateMeta(file, applyInheritedPermissions);
                FileNode fileNode = new FileNode((FileSession)node.session(), file);
                return fileNode;
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not add the file [" + String.valueOf(node.getPath()) + "]", ex);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public NodeMeta getMeta(FileSession session, FileNode node) throws RepositoryException {
        OlapRoleFlatDocsProfile profile = session.getDocsProfile();
        if (profile == null || profile.isUseDocs() && !profile.isOnError()) {
            Lock lock = this.accessLock.readLock();
            lock.lock();
            try {
                FileMeta meta;
                FileMeta fileMeta = meta = this.getMeta(node.file());
                return fileMeta;
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not retrieve meta-information for [" + String.valueOf(node.getPath()) + "]", ex);
            }
            finally {
                lock.unlock();
            }
        }
        if (profile.isOnError() || profile.isEmpty()) {
            return new FileMeta();
        }
        OlapRoleFlatDocsPermissions perms = profile.getMeta(node.getPath());
        FileMeta meta = FileMeta.restore(perms);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissions(FileSession session, FileNode node, List<OlapDocsSharing> sharings) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            try {
                this.updateMeta(node.file(), sharings);
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not update permissions for [" + String.valueOf(node.getPath()) + "]", ex);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissions(FileSession session, FileNode node, boolean applyInheritedPermissions, List<OlapDocsSharing> sharings) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            try {
                this.updateMeta(node.file(), applyInheritedPermissions, sharings);
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not update permissions for [" + String.valueOf(node.getPath()) + "]", ex);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDocContent(FileSession session, FileNode node, InputStream fileContent) throws RepositoryException {
        Lock lock = this.accessLock.writeLock();
        lock.lock();
        try {
            try {
                node.file().saveFile(fileContent);
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not update the file [" + String.valueOf(node.getPath()) + "]", ex);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDocContent(FileSession session, FileNode node, OlapDocsDoc doc, boolean withFileData) throws RepositoryException {
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            String mimeType = this.mimeTypes.getMimeTypeByExtension(FilePathUtils.toFileName(node.getName()));
            doc.setMimeType(mimeType);
            doc.setFileEditable(this.mimeTypes.isEditable(mimeType));
            if (withFileData) {
                Binary data = this.getDocContent(session, node);
                doc.setDocFile(new OlapDocsDocFile(doc.getDocCaption(), data, mimeType));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary getDocContent(FileSession session, FileNode node) throws RepositoryException {
        Lock lock = this.accessLock.readLock();
        lock.lock();
        try {
            FileBinary data;
            FileBinary fileBinary = data = new FileBinary(node);
            return fileBinary;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void installWebDashboards(FileSession session, OlapPath app, OlapPath backups, File zip, Predicate<String> filter, boolean backup) throws RepositoryException {
        try {
            this.fs.installWebDashboards(FilePathUtils.toFilePath(app), FilePathUtils.toFilePath(backups), zip, filter, backup);
        }
        catch (IOException ex) {
            throw new RepositoryException("Could not install the Dashboards app.", ex);
        }
    }

    @Override
    public void installWebDashboardsFromBackup(FileSession session, OlapPath app, OlapPath backups, String timestamp) throws RepositoryException {
        try {
            this.fs.installWebDashboardsFromBackup(FilePathUtils.toFilePath(app), FilePathUtils.toFilePath(backups), timestamp);
        }
        catch (IOException ex) {
            throw new RepositoryException("Could not install the Dashboards app. from backup [" + timestamp + "]", ex);
        }
    }

    private void updateMeta(OlapFile file, boolean applyInheritedPermissions) throws IOException {
        FileMeta meta = this.getMeta(file);
        meta.update(applyInheritedPermissions);
        this.saveMeta(file, meta);
    }

    private void updateMeta(OlapFile file, List<OlapDocsSharing> permissions) throws IOException {
        FileMeta meta = this.getMeta(file);
        meta.update(permissions);
        this.saveMeta(file, meta);
    }

    private void updateMeta(OlapFile file, boolean applyInheritedPermissions, List<OlapDocsSharing> permissions) throws IOException {
        FileMeta meta = this.getMeta(file);
        meta.update(applyInheritedPermissions, permissions);
        this.saveMeta(file, meta);
    }

    private void saveMeta(OlapFile file, FileMeta meta) throws IOException {
        OlapFile metaFile = this.metaFile(file);
        if (metaFile == null) {
            throw new IOException("Could not save meta-information (none) file [" + file.getPath() + "]");
        }
        try {
            meta.save(metaFile);
        }
        catch (IOException ex) {
            throw new IOException("Could not save meta-information file [" + metaFile.getPath() + "]");
        }
    }

    private FileMeta getMeta(OlapFile file) throws IOException {
        OlapFile metaFile = this.metaFile(file);
        if (metaFile == null) {
            return new FileMeta();
        }
        try {
            return FileMeta.restore(metaFile);
        }
        catch (IOException ex) {
            throw new IOException("Could not retrieve meta-information file [" + metaFile.getPath() + "]", ex);
        }
    }

    @Nullable
    private OlapFile metaFile(OlapFile file) {
        if (file.isDirectory()) {
            return this.fs.create(file, FilePathUtils.toFileName(META_FILE_EXTENSION));
        }
        if (file.isFile()) {
            OlapFile parentFile = file.getParentFile();
            if (parentFile == null) {
                return this.fs.create(file.getName() + String.valueOf(META_FILE_EXTENSION));
            }
            return this.fs.create(parentFile, file.getName() + String.valueOf(META_FILE_EXTENSION));
        }
        return null;
    }

    private FileNode getRootNode(FileSession session) throws RepositoryException {
        return this.getNode(session, FilePathUtils.createFromFilePath(""));
    }

    public static boolean isSame(File file1, File file2) {
        try {
            Path path1 = file1.toPath();
            Path path2 = file2.toPath();
            boolean equals = Files.isSameFile(path1, path2);
            return equals;
        }
        catch (IOException ex) {
            String absPath1 = file1.getAbsolutePath();
            String absPath2 = file2.getAbsolutePath();
            boolean equals = FilenameUtils.equalsOnSystem((String)absPath1, (String)absPath2);
            return equals;
        }
    }
}

