/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository.fs;

import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.server.repository.fs.FileNode;
import crazydev.iccube.server.repository.fs.FileNodeIterator;
import crazydev.iccube.server.repository.fs.FileSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;

public class FileNodeIteratorNIO
extends FileNodeIterator {
    private final FileSession session;
    private final OlapFile target;
    private final DirectoryStream<Path> stream;
    private final Iterator<Path> iterator;
    private int counted;

    public FileNodeIteratorNIO(FileSession session, OlapFile target, DirectoryStream<Path> stream) {
        this.session = session;
        this.target = target;
        this.stream = stream;
        this.iterator = stream.iterator();
        this.counted = 0;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public FileNode nextNode() {
        if (this.counted++ % 100 == 0 && Thread.interrupted()) {
            throw new RuntimeException("interrupted: directory-iteration");
        }
        Path next = this.iterator.next();
        File underlying = next.toFile();
        String parent = this.target.getPath();
        String path = parent == null ? (underlying.getName().isEmpty() ? underlying.getPath() : underlying.getName()) : new File(parent, underlying.getName()).getPath();
        OlapFile file = this.target.createChild(path, underlying);
        return new FileNode(this.session, file);
    }
}

