/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository.fs;

import crazydev.common.fs.CdVFilePath;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathEntry;
import crazydev.iccube.server.repository.Node;
import crazydev.iccube.server.repository.fs.FilePathUtils;
import crazydev.iccube.server.repository.fs.FileSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Date;
import java.util.function.Consumer;

public class FileNode
extends Node<FileSession> {
    private final OlapFile file;

    public FileNode(FileSession session, OlapFile file) {
        super(session, file.isDirectory());
        this.file = file;
    }

    public OlapFile file() {
        return this.file;
    }

    @Override
    public OlapPathEntry getName() {
        OlapPathEntry name = FilePathUtils.createFromFileName(this.file.getName());
        return name;
    }

    @Override
    public OlapPath getPath() {
        OlapPath path = FilePathUtils.createFromFilePath(this.file.getPath());
        return path;
    }

    @Override
    public Date getLastModified() {
        long lastModified = this.file.__getUnderlying().lastModified();
        if (lastModified > 0L) {
            return new Date(lastModified);
        }
        return null;
    }

    @Override
    public Date getLastModifiedX() {
        File report;
        File underlying = this.file.__getUnderlying();
        if (underlying.isDirectory() && underlying.getName().endsWith(".icc-report") && (report = new File(underlying, "report-definition.icc-report-def")).isFile() && report.exists()) {
            return new Date(report.lastModified());
        }
        return this.getLastModified();
    }

    @Override
    public long getLastModifiedTS() {
        return this.file.__getUnderlying().lastModified();
    }

    public InputStream createInputStream() throws IOException {
        return this.file.createInputStream();
    }

    public void processAllFiles(DirectoryStream.Filter<? super Path> filter, Consumer<CdVFilePath> action) throws IOException {
        this.file.processAllFiles(filter, action);
    }
}

