/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository.fs;

import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsAccessRights;
import crazydev.iccube.authorizationx.flat.definition.docs.OlapRoleFlatDocsPermissions;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsPermissions;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsSharing;
import crazydev.iccube.server.repository.NodeMeta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FileMeta
extends NodeMeta {
    public FileMeta() {
    }

    public FileMeta(boolean applyInheritedPermissions, List<OlapDocsSharing> permissions) {
        super(applyInheritedPermissions, permissions);
    }

    public void update(boolean applyInheritedPermissions) {
        this.applyInheritedPermissions = applyInheritedPermissions;
    }

    public void update(List<OlapDocsSharing> permissions) {
        this.permissions = permissions == null ? new ArrayList() : permissions;
    }

    public void update(boolean applyInheritedPermissions, List<OlapDocsSharing> permissions) {
        this.applyInheritedPermissions = applyInheritedPermissions;
        this.permissions = permissions == null ? new ArrayList() : permissions;
    }

    public void save(OlapFile file) throws IOException {
        if (this.isEmpty()) {
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not delete the meta-information file [" + file.getPath() + "]");
            }
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out, true);
        file.saveFile((InputStream)new ByteArrayInputStream(out.toByteArray()));
    }

    public static FileMeta restore(OlapFile file) throws IOException {
        if (!file.exists()) {
            return new FileMeta();
        }
        List lines = file.readAllLines();
        FileMeta meta = FileMeta.restore(lines);
        return meta;
    }

    public static FileMeta restore(@Nullable OlapRoleFlatDocsPermissions perms) {
        if (perms == null) {
            return new FileMeta();
        }
        String roleName = perms.getRoleName();
        boolean applyInheritedPermissions = perms.isApplyInheritedPermissions();
        OlapRoleFlatDocsAccessRights accessRights = perms.getPermissions();
        ArrayList<OlapDocsSharing> sharings = new ArrayList<OlapDocsSharing>();
        sharings.add(new OlapDocsSharing(roleName, accessRights == OlapRoleFlatDocsAccessRights.READ ? OlapDocsPermissions.READ : OlapDocsPermissions.WRITE));
        return new FileMeta(applyInheritedPermissions, sharings);
    }
}

