/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.repository.fs;

import crazydev.iccube.server.repository.Binary;
import crazydev.iccube.server.repository.RepositoryException;
import crazydev.iccube.server.repository.fs.FileNode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class FileBinary
implements Binary {
    private final FileNode node;
    private InputStream stream;

    public FileBinary(FileNode node) {
        this.node = node;
    }

    @Override
    public InputStream createInputStream() throws RepositoryException {
        if (this.stream == null) {
            try {
                this.stream = this.node.createInputStream();
            }
            catch (IOException ex) {
                throw new RepositoryException("Could not read the file [" + String.valueOf(this.node.getPath()) + "]", ex);
            }
        }
        return this.stream;
    }

    @Override
    public void dispose() {
        if (this.stream != null) {
            IOUtils.closeQuietly((InputStream)this.stream);
            this.stream = null;
        }
    }
}

