/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.loggers;

import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.Nullable;

public class OlapLoggerLevelManager {
    private final Map<String, Level> defaultValues = new HashMap<String, Level>();
    private final Map<String, Level> overriddenValues = new HashMap<String, Level>();

    public void applyOverrides() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoggerLevel> getLoggerLevels() {
        ArrayList<LoggerLevel> infos = new ArrayList<LoggerLevel>();
        Map<String, Level> map = this.defaultValues;
        synchronized (map) {
            Logger root = LogManager.getRootLogger();
            if (root instanceof org.apache.logging.log4j.core.Logger) {
                LoggerContext context = ((org.apache.logging.log4j.core.Logger)root).getContext();
                Collection loggers = context.getLoggers();
                for (org.apache.logging.log4j.core.Logger logger : loggers) {
                    infos.add(this.createLoggerLevel_Unsafe((Logger)logger));
                }
            }
        }
        return infos;
    }

    private LoggerLevel createLoggerLevel_Unsafe(Logger logger) {
        String overriddenLevel;
        boolean hasOverriddenLevel;
        String name = logger.getName();
        String defaultLevel = OlapLoggerLevelManager.level(this.getDefaultLevel_Unsafe(logger));
        if (this.overriddenValues.containsKey(name)) {
            hasOverriddenLevel = true;
            overriddenLevel = OlapLoggerLevelManager.level(this.overriddenValues.get(name));
        } else {
            hasOverriddenLevel = false;
            overriddenLevel = null;
        }
        return new LoggerLevel(name, defaultLevel, hasOverriddenLevel, overriddenLevel);
    }

    @Nullable
    private Level getDefaultLevel_Unsafe(Logger logger) {
        String name = logger.getName();
        if (this.defaultValues.containsKey(name)) {
            return this.defaultValues.get(name);
        }
        return logger.getLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerLevel overrideDefaultLevel(Logger logger, @Nullable Level level) {
        String name = logger.getName();
        OlapLoggers.GENERAL.info((Object)("[LOG4J] overriding default level [" + logger.getName() + ":" + String.valueOf(logger.getLevel()) + "] to [" + String.valueOf(level) + "]"));
        Map<String, Level> map = this.defaultValues;
        synchronized (map) {
            this.defaultValues.putIfAbsent(name, logger.getLevel());
            this.overriddenValues.put(name, level);
            Configurator.setLevel((String)logger.getName(), (Level)level);
            return this.createLoggerLevel_Unsafe(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToDefaultLevels() {
        OlapLoggers.GENERAL.info((Object)"[LOG4J] reset default levels");
        Map<String, Level> map = this.defaultValues;
        synchronized (map) {
            for (Map.Entry<String, Level> entry : this.defaultValues.entrySet()) {
                String name = entry.getKey();
                Level level = entry.getValue();
                Logger logger = LogManager.getLogger((String)name);
                Configurator.setLevel((String)logger.getName(), (Level)level);
            }
            this.overriddenValues.clear();
        }
    }

    @Nullable
    private static String level(@Nullable Level level) {
        return level != null ? level.toString() : null;
    }

    public static class LoggerLevel {
        public final String name;
        @Nullable
        public final String defaultLevel;
        public final boolean hasOverriddenLevel;
        @Nullable
        public final String overriddenLevel;

        public LoggerLevel(String name, @Nullable String defaultLevel, boolean hasOverriddenLevel, @Nullable String overriddenLevel) {
            this.name = name;
            this.defaultLevel = defaultLevel;
            this.hasOverriddenLevel = hasOverriddenLevel;
            this.overriddenLevel = overriddenLevel;
        }
    }
}

