/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.server.loggers;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import crazydev.common.utils.CdStringUtils;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class OlapLoggerLevel {
    @Expose
    @SerializedName(value="logger")
    private final String logger;
    @Expose
    @SerializedName(value="level")
    private final String level;

    public OlapLoggerLevel(String logger, String level) {
        this.logger = logger;
        this.level = level;
    }

    public String getLogger() {
        return this.logger;
    }

    public String getLevel() {
        return this.level;
    }

    @Nullable
    public static Level level(@Nullable String levelName) {
        if (levelName == null || CdStringUtils.isNullOrBlank((String)levelName)) {
            return null;
        }
        switch (levelName.toUpperCase()) {
            case "TRACE": {
                return Level.TRACE;
            }
            case "DEBUG": {
                return Level.DEBUG;
            }
            case "WARN": {
                return Level.WARN;
            }
            case "INFO": {
                return Level.INFO;
            }
            case "ERROR": {
                return Level.ERROR;
            }
            case "FATAL": {
                return Level.FATAL;
            }
            case "ALL": {
                return Level.ALL;
            }
            case "OFF": {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException();
    }
}

